/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern window_node *current_window;
extern WINDOW *chat_win;
extern WINDOW *buddy_win;

buddy_pounce_node *buddy_pounce_head = NULL;

/* addbuddypounce <who> <when> <type> <otherstuff>
   if type = send_message.. otherstuff = sendtowho then message to send
   if type = beep... otherstuff = number of times
   if type = call program.. otherstuff = command */
void addbuddypouncenode(char **args, int numofargs)
{
   buddy_pounce_node *cur = buddy_pounce_head;
   char *who;
   unsigned char type, when;
   unsigned int p_num;

   if(numofargs < 4)
     return;

   if(cur == NULL)
     {
	buddy_pounce_head = (buddy_pounce_node*)MALLOC(sizeof(buddy_pounce_node), "addbuddypouncenode");
	buddy_pounce_head->next = NULL;
	buddy_pounce_head->pounce_number = 0;
	cur = buddy_pounce_head;
     }
   else
     {
	while(cur->next)
	  cur = cur->next;

	p_num = cur->pounce_number;

	cur->next = (buddy_pounce_node*)MALLOC(sizeof(buddy_pounce_node), "addbuddypouncenode");
	cur = cur->next;
	cur->pounce_number = p_num + 1;
	cur->next = NULL;
     }

   who = args[1];
   when = atoi(args[2]);
   type = atoi(args[3]);

   cur->next = NULL;
   strcpy(cur->who, stripname(who));
   cur->type = type;
   cur->when = when;

   switch(type)
     {
      case SEND_MESSAGE:
	strcpy(cur->event.send_message.whotosendto, stripname(args[4]));
	cur->event.send_message.message = (char*)MALLOC(strlen(args[5]), "addbuddypouncenode");
	strcpy(cur->event.send_message.message, args[5]);
	break;

      case BEEP:
	cur->event.numberofbeeps = atoi(args[4]);
	break;

      case CALL_PROGRAM:
	cur->event.command = (char*)MALLOC(strlen(args[4]), "addbuddypouncenode");
	strcpy(cur->event.command, args[4]);
	break;

      default:
	break;
     }
}

void checkforbuddypounce(char *who, unsigned char when)
{
   buddy_pounce_node *cur = buddy_pounce_head;
   buddy_pounce_node *prev = NULL;

   if(buddy_pounce_head == NULL)
     return;

   while(cur)
     {
	char *tmp = stripname(who);
	if(!strcmp(tmp, cur->who))
	  {
	     if(when & cur->when)
	       {
		  switch(cur->type)
		    {
		     case SEND_MESSAGE:
		       send_message(cur->event.send_message.whotosendto, cur->event.send_message.message, 1);
		       FREE(cur->event.send_message.message, "checkforbuddypounce");
		       break;

		     case BEEP:
			 {
			    int i;
			    for(i = 0; i < cur->event.numberofbeeps; i++)
			      {
				 print("\a");
				 usleep(10);
			      }
			 }
		       break;

		     case CALL_PROGRAM:
		       system(cur->event.command);
		       FREE(cur->event.command, "checkforbuddypounce");
		       touchwin(current_window->window);
		       wrefresh(current_window->window);

		       touchwin(chat_win);
		       wrefresh(chat_win);

		       touchwin(buddy_win);
		       wrefresh(buddy_win);
		       break;

		     default:
		       break;
		    }

		  if(prev)
		    prev->next = cur->next;
		  if(cur == buddy_pounce_head)
		    {
		       if(cur->next)
			 buddy_pounce_head = cur->next;
		       else
			 buddy_pounce_head = NULL;
		    }
		    {
		       buddy_pounce_node *tmp = cur->next;
		       FREE(cur, "checkforbuddypounce");
		       cur = tmp;
		       continue;
		    }
	       }
	  }
	prev = cur;
	cur = cur->next;
     }
}

void print_pounces(void)
{
   buddy_pounce_node *cur;

   for(cur = buddy_pounce_head; cur; cur = cur->next)
     {
	wattron(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK));
	wprintw(current_window->window, "[%d] who: ", cur->pounce_number);
	wattron(current_window->window, CP(COLOR_WHITE, COLOR_BLACK));
	wprintw(current_window->window, "%s ", cur->who);
	wattron(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK));
	wprintw(current_window->window, "when: ");
	wattron(current_window->window, CP(COLOR_WHITE, COLOR_BLACK));
	wprintw(current_window->window, "%d ", cur->when);
	wattron(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK));
	wprintw(current_window->window, "type: ");
	wattron(current_window->window, CP(COLOR_WHITE, COLOR_BLACK));
	wprintw(current_window->window, "%d ", cur->type);

	wattron(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK));
	if(cur->type == SEND_MESSAGE)
	  {
	     wprintw(current_window->window, "to: ");
	     wattron(current_window->window, CP(COLOR_WHITE, COLOR_BLACK));
	     wprintw(current_window->window, "%s ", cur->event.send_message.whotosendto);
	     wattron(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK));
	     wprintw(current_window->window, "message: ");
	     wattron(current_window->window, CP(COLOR_WHITE, COLOR_BLACK));
	     wprintw(current_window->window, "%s\n", cur->event.send_message.message);
	  }
	else if(cur->type == BEEP)
	  {
	     wprintw(current_window->window, "beep ");
	     wattron(current_window->window, CP(COLOR_WHITE, COLOR_BLACK));
	     wprintw(current_window->window, "%d ", cur->event.numberofbeeps);
	     wattron(current_window->window, CP(COLOR_MAGENTA, COLOR_BLACK));
	     wprintw(current_window->window, "times\n");
	  }
	else if(cur->type == CALL_PROGRAM)
	  {
	     wprintw(current_window->window, "call: ");
	     wprintw(current_window->window, "%s\n", cur->event.command);
	  }
     }
   wrefresh(current_window->window);
}

void remove_pounce(int pounce_number)
{
   buddy_pounce_node *cur;
   buddy_pounce_node *prev = NULL;

   for(cur = buddy_pounce_head; cur; cur = cur->next)
     {
	if(cur->pounce_number == pounce_number)
	  {
	     switch(cur->type)
	       {
		case SEND_MESSAGE:
		  FREE(cur->event.send_message.message, "remove_pounce");
		  break;

		case BEEP:
		  break;

		case CALL_PROGRAM:
		  FREE(cur->event.command, "remove_pounce");

		  break;

		default:
		  break;
	       }
	     if(prev)
	       prev->next = cur->next;
	     if(cur == buddy_pounce_head)
	       {
		  if(cur->next)
		    buddy_pounce_head = cur->next;
		  else
		    buddy_pounce_head = NULL;
	       }
	     FREE(cur, "remove_pounce");
	     return;
	  }
	prev = cur;
     }
}

void clearpounces(void)
{
   buddy_pounce_node *cur_bpn = buddy_pounce_head;
   int i;
   
   if(cur_bpn)
     {
	while(cur_bpn->next)
	  cur_bpn = cur_bpn->next;

	for(i = 0; i <= cur_bpn->pounce_number; i++)
	  remove_pounce(i);
     }

   return;
}

