/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __Fragment_h
#define __Fragment_h

#ifndef __PTypes_h
#include "PTypes.h"
#endif

#ifndef __PListS_h
#include "PListS.h"
#endif

#ifndef __AutoFree_h
#include "AutoFree.h"
#endif

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

#ifndef __LocationNode_h
#include "LocationNode.h"
#endif

class Symbol;
class Stmt;
class Bytecode;
class Program;
class VarPool;

class Fragment : public PLinkS<Fragment>, public AutoFree
{
public:
	enum
	{
		// special task IDs
		kNoTaskID = -1,
		kMultiTaskID = -2
	};

				Fragment(bool isTask, Symbol *name, Stmt *body);
				~Fragment();

	void		SetLocations(LocationNode *start, LocationNode *end);

	int					GetNumber()	const	{ return fNumber; }
	Symbol*				GetName() const		{ return fName; }
	bool				IsTask() const		{ return fIsTask; }
	RCX_ChunkType		GetChunkType() const	{ return fIsTask ? kRCX_TaskChunk : kRCX_SubChunk; }
	int					GetTaskID() const	{ return fTaskID; }
	Stmt*				GetBody()			{ return fBody; }
	int					GetLocalMask() const	{ return fLocalMask; }
	void				SetLocalMask(int m)	{ fLocalMask = m; }
	
	void		SetNumber(int n)	{ fNumber = n; }
	void		AssignTaskID(int n);	// only affects kRCX_SubFragment types
	void		SetBody(Stmt *s)	{ fBody = s; }
	
	void		Emit(Bytecode &b);
	void		Check();
	
private:
	bool		fIsTask;
	Symbol*		fName;
	Stmt*		fBody;
	int			fNumber;
	int			fTaskID;
	int			fLocalMask;
	LexLocation	fStart;
	LexLocation	fEnd;
};

#endif
