/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */

#ifndef __Expr_h
#define __Expr_h

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

#ifndef __AutoFree_h
#include "AutoFree.h"
#endif

#ifndef __Variable_h
#include "Variable.h"
#endif

class Bytecode;
class Mapping;


class Expr : public AutoFree
{
public:
	enum {
		kIllegalEA = -1
	};
	
	virtual	~Expr() = 0;
	
	virtual Expr*		Clone(Mapping *) const = 0;
	
	virtual bool		PromiseConstant() const { return false; }
	virtual bool		Evaluate(int & /*value */) const	{ return false; }

	virtual bool		PromiseSensor() const	{ return false; }
	
	virtual int			GetLValue() const	{ return kIllegalVar; }
	
	virtual bool		Contains(int /*var*/) const { return false; };


	// calls to emit code
	RCX_Value	EmitAny(Bytecode &b, const struct LexLocation *loc) const;
	bool		EmitTo(Bytecode &b, int dst, const struct LexLocation *loc) const;
	RCX_Value	EmitConstrained(Bytecode &b, long mask, const struct LexLocation *loc) const;
	bool		EmitSide(Bytecode &b, const struct LexLocation *loc) const;

protected:
	// virtual code emit methods for derrived classes
	virtual RCX_Value	EmitAny_(Bytecode &b, const struct LexLocation *loc) const = 0;
	virtual bool		EmitTo_(Bytecode &b, int dst, const struct LexLocation *loc) const;
	virtual bool		EmitSide_(Bytecode &b, const struct LexLocation *loc) const;
	
	static int GetTempVar(Bytecode &b, const LexLocation *loc);
};


// use this to build a typemask for EmitConstrained()
#define TYPEMASK(t)	(1L << (t))

// masks for EmitConstrained()
#define MATH_MASK	(TYPEMASK(kRCX_VariableType) + \
					TYPEMASK(kRCX_ConstantType))
#define SET_MASK	-1
#define CODE_MASK(c)	((c)==kRCX_SetVar ? SET_MASK : MATH_MASK)


#endif
