/****************************************************************************/
/* ##   ##         #####   #####  ##     **        NoSQL RDBMS - crypt      */
/* ###  ##        ####### ####### ##     **        $Revision: 2.4.0 $       */
/* #### ##        ###     ##   ## ##     ************************************/
/* #######  ####  #####   ##   ## ##     **   Carlo Strozzi (c) 1998-2000   */
/* ####### ######   ##### ## # ## ##     ************************************/
/* ## #### ##  ##     ### ##  ### ##     **           Written by            */
/* ##  ### ###### ####### ######  ###### **          Carlo Strozzi          */
/* ##   ##  ####   #####   #### # ###### **     e-mail: carlos@linux.it     */
/****************************************************************************/
/*  NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.                          */
/*  This program comes with ABSOLUTELY NO WARRANTY; for details             */
/*  refer to the GNU General Public License.                                */
/****************************************************************************

   Compile with: cc -o crypt -lcrypt crypt.c

   Takes an eight-byte key, followed by a newline, followed by a two-byte
   salt and an ending newline from STDIN, and writes the encrypted equivalent
   to STDOUT, in the usual 13-byte format. 

   Usage example:  printf 'ABcdeFgh\n2X\n' | crypt

   Result on STDOUT: 2XSIySnuuCSoo

   A simple way to set the 'salt' string from within a shell script is
   to use 'date +%S'.

   Warning: providing the cleartext password through stdin is quite
   unsecure. Please use the 'pwcrypt' program as opposed to this one.

****************************************************************************/

#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <crypt.h>

static void error(void);

int main(void)
{
  int len;
  char *r, key[10], salt[4];
    
  fgets( key,  sizeof(key),  stdin ); 
  r=key; while(*r != '\n' && r < key+sizeof(key)) r++;
  *r='\0';

  fgets( salt, sizeof(salt), stdin );
  r=salt; while(*r != '\n' && r < salt+sizeof(salt)) r++;
  *r='\0';

  len = strlen( r = crypt( key, salt ) );
  if ( write( STDOUT_FILENO, r, len ) != len ) error();
  exit(0);
}

static void error()
{
  (void)fprintf( stderr, "crypt: %s\n", strerror( errno ) );
  exit(1);
}

/* End of program */
