// Single File library
var loadTimelibrary1 = typeof window.library1 === "undefined"
describe("library1", function() {
	it("should load library1 only once", function() {
		loadTimelibrary1.should.be.ok;
	});

	it("should load a component", function() {
		require("./lib/component").should.be.eql("lib1 component");
	});

	it("should load async submodules with require.ensure even if single == true", function(done) {
		var sameTick = true;
		require.ensure(["submodule1", "submodule2"], function(require) {
			sameTick.should.be.eql(true);
			require("submodule1").should.be.eql("submodule1");
			require("submodule2").should.be.eql("submodule2");
			require("submodule3")().should.be.eql("submodule3");
			require.ensure([], function(require) {
				sameTick.should.be.eql(true);
				done();
			});
		});
		setImmediate(function() {
			sameTick = false;
		});
	});
});
module.exports = true;