/**
 * @file output.c
 *
 * This is the output object. It remains unwritten. If you have grand schemes,
 * implement them here.
 * 
 */

#include <lib/njamd.h>
#include <lib/output.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

/** @FIXME Get RID of this and use the output object.. */
int __nj_efd;


void __nj_output_bootstrap_init(struct nj_output *output)
{
	__nj_efd = output->fd = dup(STDERR_FILENO);

}

/**
 * Second stage init of output
 *
 * This is where you would do something like set up an XML stream, or
 * socket, if the user so requested (use the prefs, luke)
 */
void __nj_output_user_init(struct nj_output *output, struct nj_prefs *prefs)
{
	return;
}

void __nj_output_fini(struct nj_output *output)
{

}

void __nj_output_fatal_user_error(int class, int code, nj_addr_t ptr, 
		struct nj_heap_entry *entry, char *format, ...)
{
	/* Fatal error... print message, dump callstack, die */
	struct nj_output *output = &__NJAMD__.output;
    char outbuf[1024];
    va_list ap;
    int len;
	va_start(ap, format);
	len = vsnprintf(outbuf, sizeof(outbuf), format, ap);

	if(len > 0)
		write(output->fd, outbuf, len);
	else
		write(output->fd, outbuf, strlen(outbuf));

	va_end(ap);

	exit(1);
}

void __nj_output_fatal_internal_error(int eclass, int code, char *function, 
		int line, char *format, ...)
{

}

void __nj_output_user_warning(int wclass, int code, nj_addr_t ptr,
		struct nj_heap_entry *entry, char *format, ...)
{

}

void __nj_output_internal_warning(char *function, int line, char *format, ...)
{

}

/**@{ @name Old Information reporting routines 
 * @FIXME: Get RID of these and use the real output object...
 */


/**
 * A printf function guaranteed not to call malloc.
 *
 * This function writes out to __nj_efd, which is stderr in non-gui
 * operations. It doesn't call malloc, and the output size is limited to 1024
 * (local buffer)
 * @param format The string format
 * @param ... Arguments.
 *
 * @TODO To output object
 */
void __nj_eprintf(const char *format, ...)
{
    char outbuf[1024];
    va_list ap;
    int len;
	va_start(ap, format);
	len = vsnprintf(outbuf, sizeof(outbuf), format, ap);
	if(len > 0)
		write(__nj_efd, outbuf, len);
	else
	write(__nj_efd, outbuf, strlen(outbuf));
	va_end(ap);
}

/**
 * Internal perror that will never call malloc.
 * 
 * We needed our own printf and perror that write immeditaly, and can be
 * guaranteed not to use malloc ever.
 *
 * @param s Error prefix string 
 */
void __nj_perror(const char *s)
{
	__nj_eprintf("%s: %s\n", s, strerror(errno));
}

/** 
 * Prints an error message then exits if we run out of memory. 
 */
void __nj_critical_error(char *str)
{
#ifdef __linux__
	int fd;
	char did_oc = 0;
	char mmc_str[32];
	int mmc = 0;
#endif
	if(str)
		__nj_perror(str);

	/** @FIXME: Handle more errors */
	switch(errno)
	{
		case ENOMEM:
#ifdef __linux__
			if((fd = open(LINUX_PROC_MAX_MAP_COUNT, O_RDONLY) != -1))
			{
				read(fd, mmc_str, sizeof(mmc_str));
				mmc = strtol(mmc_str, NULL, 0);
				close(fd);
			}

			if((fd = open(LINUX_PROC_OVERCOMMIT, O_RDONLY)) != -1)
			{
				read(fd, &did_oc, 1);
				did_oc -= '0';
				close(fd);
			}

			switch(__NJAMD__.prefs.dyn.free_type)
			{
				case NJ_CHK_FREE_ERROR:
					if(did_oc && mmc > 65536)
						__nj_eprintf("\nNJAMD: Address space exhaustion.\nSet NJAMD_CHK_FREE=segv or none\n");
					else if(did_oc)
						__nj_eprintf("\nNJAMD: Address space exhaustion.\nDid you try the proc_map patch?\n");
					else
						__nj_eprintf("\nNJAMD: Address space exhaustion.\nRun sysctl -w vm.overcommit_memory=1 as root, or set NJAMD_CHK_FREE=segv or none\n");
					break;
				case NJ_CHK_FREE_SEGV:
					if(did_oc && mmc > 65536)
						__nj_eprintf("\nNJAMD: Address space exhaustion.\nSet NJAMD_CHK_FREE=none\n");
					else if(did_oc)
						__nj_eprintf("\nNJAMD: Address space exhaustion.\nDid you try the proc_map patch?\n");
					else
						__nj_eprintf("\nNJAMD: Address space exhaustion.\nRun sysctl -w vm.overcommit_memory=1 as root, or set NJAMD_CHK_FREE=segv or none\n");
					break;
				default:
					if(did_oc && mmc > 65536)
						__nj_eprintf("\nNJAMD: Address space exhaustion.\n");
					else if(did_oc)
						__nj_eprintf("\nNJAMD: Address space exhaustion.\nDid you try the proc_map patch?\n");
					else
						__nj_eprintf("\nNJAMD: Address space exhaustion.\nRun sysctl -w vm.overcommit_memory=1 and try the proc_map patch.\n");
					break;
			}
#else
			switch(__NJAMD__.prefs.dyn.free_type)
			{
				case NJ_CHK_FREE_ERROR:
					__nj_eprintf("\nNJAMD: Address space exhaustion.\nSet NJAMD_CHK_FREE=segv or none\n");
					break;
				case NJ_CHK_FREE_SEGV:
					__nj_eprintf("\nNJAMD: Address space exhaustion.\nSet NJAMD_CHK_FREE=none\n");
					break;
				default:
					__nj_eprintf("\nNJAMD: Address space exhaustion.\nDid you try telling your OS to overcommit virtual memory?\n");
					break;
			}

#endif
			/* Turn off printing of usage stats here */
			exit(ENOMEM);
			break;
		default:
			exit(ENOMEM);
	}
}
/*@}*/

// vim:ts=4
