#include <fe/njamd.h>
#include <fe/fe.h>
#include <fe/console/console.h>
#ifdef HAVE_GTK
#include <fe/gui/gui.h>
#endif
#include <fe/util/err.h>

static void njSetOptions(int argc, char* argv[], NJOPTIONS* opts);
static void njPrintHelp (void);

void njStartApplication(int argc, char* argv[])
{
	NJOPTIONS opts;

	njSetOptions(argc, argv, &opts);

#ifdef HAVE_GTK
	if (opts.appType == GUI)
		njGUIStart(argc, argv, &opts);
	else if (opts.appType == CONSOLE)
#endif
		njConsStart(&opts);
#ifdef HAVE_GTK
	else
#endif
		err(EXIT_FAILURE, "opts.appType == %i", (int) opts.appType);
}

static void njSetOptions(int argc, char* argv[], NJOPTIONS* opts)
{
#ifdef HAVE_GTK
	Display* display;
#endif
	int c;
	int guiAvailable;

	opts->appType = BESTGUESS;
	opts->argv0 = NULL;
	opts->args  = NULL;

	while ((c = getopt(argc, argv, "ce:gh")) != -1) {
		switch (c) {
		case 'c':
			opts->appType = CONSOLE;
			break;
		case 'e':
			opts->argv0 = *(argv + optind - 1);
			opts->args  = argv + optind;
			goto done;
		case 'g':
			opts->appType = GUI;
			break;
		case 'h':
			njPrintHelp();
			err(EXIT_FAILURE, NULL);
		case '?':
			njPrintHelp();
			err(EXIT_FAILURE, "Unrecognized option: -%c", optopt);
		}
	}

done:

#ifdef HAVE_GTK
	if ((display = XOpenDisplay(NULL)) != NULL) {
		XCloseDisplay(display);
		guiAvailable = 1;
	} 
	else
#endif
	{
		guiAvailable = 0;
	}

	if (opts->appType == GUI && !guiAvailable)
		err(EXIT_FAILURE, "Unable to start GUI: X not running");

	if (guiAvailable && opts->appType != CONSOLE)
		opts->appType = GUI;
	else
		opts->appType = CONSOLE;

	if (opts->appType == CONSOLE && opts->argv0 == NULL) {
		njPrintHelp();
		err(EXIT_FAILURE,
			"You must specify the -e option with the console version");
	}
}

static void njPrintHelp(void)
{
	printf("Usage:\n");
	printf(" -c                Use console mode.\n");
	printf(" -e program [args] Execute program with optional args.  This must be the last\n");
	printf("                   option on the command line, and is required if the\n");
	printf("                   console version of the application is being run.\n");
	printf(" -g                Use GUI mode.\n");
	printf(" -h                Display help and exit.\n");
}
// vim:ts=4
