/** 
 * @file prefs.h
 *
 * Provides the preference structures of NJAMD
 */
#ifndef __NJ_LIB_PREFS_H__
#define __NJ_LIB_PREFS_H__
#include <config.h>
#include <sys/types.h>

#ifdef _THREAD_SAFE
# include <pthread.h>
#endif

/** Provides the prefrences that can only be set before runtime. 
 * 9 bits.. oh well we lose a byte. */
struct nj_static_prefs
{
	u_int dump_stats	   : 1;	/**< True,false */
	u_int dump_leaks	   : 1;	/**< true,false */
	u_int persist		   : 1;	/**< Does shit stick around after we die? */
	u_int allow_read	   : 1;	/**< Allow reads past the end of the buffer? */
	u_int allow_free_0	   : 1;	/**< Allow free of NULL? */
	u_int allow_malloc_0   : 1;	/**< allow malloc of 0? */
	u_int store_retaddrs   : 1;	/**< Store retaddrs at all? */
	u_int mutable_alloc	   : 1;	/**< Can we change the alloc type? */
	u_int core_dump_type   : 2;	/**< Hard, soft, none */
	u_int callstack_depth  : 6; /**< Fixed callstack depth */
};

/** Provides a snapshot of the runtime mutable NJAMD state, to protect
 * against race conditions. Fits in 32bits */
struct nj_dynamic_prefs
{
    u_int trace_libs 	: 1;	/**< Trace through libraries? */
    u_int info_on_free 	: 1;	/**< Provide info on free? MUST provide a callstack depth to change this */
    u_int alloc_type 	: 2;	/**< Allocation type */
    u_int free_type 	: 2;	/**< Free protection type */
    u_int align 		: 26;	/**< Alignment, unshifted */
};

struct nj_prefs
{
	struct nj_static_prefs  stat;
	struct nj_dynamic_prefs dyn;
#ifdef _THREAD_SAFE
	pthread_mutex_t set_lock;
#endif
};


void __nj_prefs_bootstrap_init(struct nj_prefs *);
void __nj_prefs_user_init(struct nj_prefs *);
void __nj_prefs_fini(struct nj_prefs *);
void __nj_prefs_set(struct nj_prefs *, struct nj_dynamic_prefs);
struct nj_dynamic_prefs __nj_prefs_get(struct nj_prefs *);
void __nj_prefs_load_from_env(struct nj_prefs *);

#endif /* prefs.h*/
// vim:ts=4
