/**
 * @file output.h
 *
 * The user output object
 *
 */
#ifndef __NJ_LIB_OUTPUT_H__
#define __NJ_LIB_OUTPUT_H__

#include <unistd.h>
#include <config.h>
#include <lib/prefs.h>
#include <lib/heap_entry.h>

struct nj_output
{
	int fd;			/**< Thats all she wrote for now */
};

void __nj_output_bootstrap_init(struct nj_output *);
void __nj_output_user_init(struct nj_output *, struct nj_prefs *);
void __nj_output_fini(struct nj_output *);
void __nj_output_fatal_user_error(int, int, nj_addr_t, struct nj_heap_entry *, char *, ...);
void __nj_output_fatal_internal_error(int, int, char *, int, char *, ...);
void __nj_output_user_warning(int, int, nj_addr_t, struct nj_heap_entry *, char *, ...);
void __nj_output_internal_warning(char *, int, char *, ...);

void __nj_eprintf(const char *, ...);
void __nj_critical_error(char *);
void __nj_perror(const char *);

#endif /* output.h */
// vim:ts=4

