/**
 * @file njamd.h
 *
 * The NJAMD object.
 * 
 */
#ifndef __NJ_LIB_NJAMD_H__
#define __NJ_LIB_NJAMD_H__

#include <lib/allocator.h>
#include <lib/threads.h>
#include <lib/signals.h>
#include <lib/output.h>
#include <lib/prefs.h>
#include <lib/libc_syms.h>
#include <config.h>

#ifdef _THREAD_SAFE
# include <pthread.h>
#endif

/**@{ @name NJAMD states */
#define NJ_STATE_NONE					0
#define NJ_STATE_BOOTSTRAPPED			1
#define NJ_STATE_CROSSED_MAIN			2
#define NJ_STATE_USER_READY				3
#define NJ_STATE_DESTRUCT				4
/*@}*/

/** Main njamd object */
struct nj_njamd
{
	struct	nj_allocator		allocator; /**< njamd allocator */
	struct	nj_libc_syms		libc_syms; /**< libc symbol source */
	struct	nj_signals			signals;   /**< Signal handlers */
	struct 	nj_threads			threads;   /**< Thread crap */
	struct	nj_output			output;    /**< Output */
	struct 	nj_prefs			prefs;	   /**< Prefs */
#ifdef _THREAD_SAFE
	pthread_mutex_t				init_lock; /**< The initialization lock */
#endif
	u_int	active_threads					: 1; /**< Do we have active threads yet? */
	u_int	state							: 3; /**< State of the allocator */
	void	(*libc_exit)(int);					 /**< Exit symbol */
};

extern struct nj_njamd __NJAMD__;

void __nj_njamd_bootstrap_init(struct nj_njamd *);
void __nj_njamd_user_init(struct nj_njamd *);
void __nj_njamd_fini();

#endif /* njamd.h */
// vim:ts=4
