/* run the display for an arrow in a workspace 
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static GraphicviewClass *parent_class = NULL;

static void
iarrowview_destroy( GtkObject *object )
{
	iArrowview *iarrowview;

#ifdef DEBUG
	printf( "iarrowview_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_IARROWVIEW( object ) );

	iarrowview = IARROWVIEW( object );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void 
iarrowview_refresh( vObject *vobject )
{
	iArrowview *iarrowview = IARROWVIEW( vobject );
	iArrow *iarrow = IARROW( vobject->iobject );

#ifdef DEBUG
	printf( "iarrowview_refresh: " );
	row_name_print( HEAPMODEL( iarrow )->row );
	printf( "\n" );
#endif /*DEBUG*/

	set_gcaption( iarrowview->label, "%s", 
		NN( IOBJECT( iarrow )->caption ) );

	VOBJECT_CLASS( parent_class )->refresh( vobject );
}

static void
iarrowview_class_init( iArrowviewClass *class )
{
	GtkObjectClass *object_class = (GtkObjectClass *) class;
	vObjectClass *vobject_class = (vObjectClass *) class;

	parent_class = g_type_class_peek_parent( class );

	object_class->destroy = iarrowview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	vobject_class->refresh = iarrowview_refresh;
}

static gboolean
iarrowview_event_cb( GtkWidget *widget, GdkEvent *ev, 
	iArrowview *iarrowview )
{
	iArrow *iarrow = IARROW( VOBJECT( iarrowview )->iobject );
	Row *row = HEAPMODEL( iarrow )->row;

	gboolean handled = FALSE;

        switch( ev->type ) {
        case GDK_BUTTON_PRESS:
		if( ev->button.button == 1 ) {
			row_select_modifier( row, ev->button.state );
			handled = TRUE;
		}
		break;

        case GDK_2BUTTON_PRESS:
		if( ev->button.button == 1 ) {
			GSList *iimages = CLASSMODEL( iarrow )->iimages;

			if( iimages ) 
				/* Don't pop the edit method ... instead, 
				 * open an image view for the image that 
				 * the arrow is defined on.
				 */
				(void) imageview_new_area( 
					IIMAGE( iimages->data ),
					&iarrow->instance.area );
			else
				model_edit( widget, MODEL( iarrow ) );

			handled = TRUE;
		}
		break;

	default:
		break;
	}

	return( handled );
}

static void
iarrowview_init( iArrowview *iarrowview )
{
	GtkWidget *eb;

#ifdef DEBUG
	printf( "iarrowview_init\n" );
#endif /*DEBUG*/

        eb = gtk_event_box_new();
        gtk_box_pack_start( GTK_BOX( iarrowview ), eb, FALSE, FALSE, 0 );
	iarrowview->label = gtk_label_new( "" );
        gtk_misc_set_alignment( GTK_MISC( iarrowview->label ), 0, 0.5 );
        gtk_misc_set_padding( GTK_MISC( iarrowview->label ), 2, 0 );
        gtk_container_add( GTK_CONTAINER( eb ), iarrowview->label );
	set_name( eb, "caption_widget" );
        gtk_signal_connect( GTK_OBJECT( eb ), "event",
                GTK_SIGNAL_FUNC( iarrowview_event_cb ), iarrowview );

        gtk_widget_show_all( GTK_WIDGET( eb ) );
}

GtkType
iarrowview_get_type( void )
{
	static GtkType iarrowview_type = 0;

	if( !iarrowview_type ) {
		static const GtkTypeInfo info = {
			"iArrowview",
			sizeof( iArrowview ),
			sizeof( iArrowviewClass ),
			(GtkClassInitFunc) iarrowview_class_init,
			(GtkObjectInitFunc) iarrowview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		iarrowview_type = gtk_type_unique( TYPE_GRAPHICVIEW, &info );
	}

	return( iarrowview_type );
}

View *
iarrowview_new( void )
{
	iArrowview *iarrowview = gtk_type_new( TYPE_IARROWVIEW );

	return( VIEW( iarrowview ) );
}
