# -*- coding: utf-8 -*-
#
#  win_dll.py - a (Real) Windows DLL loader for ninix
#  Copyright (C) 2004 by linjian
#  Copyright (C) 2004-2013 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2011 by henryhu
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import sys
import struct
import logging
import traceback
from ctypes import cdll, c_char_p, c_long, create_string_buffer, byref
import _ctypes


## FIXME ##
DEFAULT_SCORE = 300 # 150


class Shiori(object):

    def __init__(self, dll_name):
        self.dll_name = dll_name
        self.pathdic = []
        self.reqdic = []
        self.dll = None

    def find(self, topdir, dll_name):
        bits = struct.calcsize('P') * 8 # XXX: cross-platform way to determine
        if os.name == 'nt' and bits == 32:
            return DEFAULT_SCORE
        else:
            return 0

    def show_description(self):
        logging.info(
            'Shiori: a (Real) Windows DLL loader for ninix\n'
            '        Copyright (C) 2004 by linjian\n'
            '        Copyright (C) 2004-2013 by Shyouzou Sugitani\n'
            '        Copyright (C) 2011 by henryhu')

    def load(self, topdir):
        self.dir = topdir
        try:
            self.dll = cdll.LoadLibrary(os.path.join(self.dir, self.dll_name))
        except:
            logging.error('DLL({0}) load fail!'.format(self.dll_name))
            #    traceback.print_exc()
            self.dll = None
        if self.dll:
            if self.dir.endswith(os.sep):
                topdir = self.dir
            else:
                topdir = ''.join((self.dir, os.sep))
            path = create_string_buffer(topdir)
            self.pathdic += [path] # so python would not free it
#            logging.debug(repr(self.pathdic))
            # since DLL would free it (...)
            # we must not allow python to free it
            ret = self.dll.load(path, len(topdir))
#            logging.debug('load result: {0:d}'.format(ret))
            return ret
        else:
            return 0

    def unload(self):
        if self.dll:
            self.dll.unload()
            try:
                _ctypes.FreeLibrary(self.dll._handle)
            except:
                pass
            self.dll = None

    def request(self, req_string):
        if self.dll:
            reqf = self.dll.request
            reqf.restype = c_char_p
            request = create_string_buffer(req_string)
            # since DLL may free it (...)
            # we must not allow python to free it
            self.reqdic += [request] # so python would not free it
            rlen = c_long(len(request))
#            logging.debug('request: {0}'.format(req_string))
            ret = reqf(request, byref(rlen))
#            logging.debug('result len: {0:d}'.format(rlen.value))
#            logging.debug(ret)
            return ret
        else:
            return '' # FIXME
