/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import java.util.ArrayList;
import java.util.Map;
import mlsub.typing.AtomicConstraint;
import mlsub.typing.Constraint;
import mlsub.typing.Monotype;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;

public class MonotypeLeqCst
extends AtomicConstraint {
    private Monotype m1;
    private Monotype m2;

    public MonotypeLeqCst(Monotype m1, Monotype m2) {
        this.m1 = m1;
        this.m2 = m2;
    }

    @Override
    AtomicConstraint substitute(Map map2) {
        Monotype new1 = this.m1.substitute(map2);
        Monotype new2 = this.m2.substitute(map2);
        if (new1 == this.m1 && new2 == this.m2) {
            return this;
        }
        return new MonotypeLeqCst(new1, new2);
    }

    @Override
    void enter() throws TypingEx {
        Typing.leq(this.m1, this.m2);
    }

    public static Constraint constraint(Monotype[] c1, Monotype[] c2) {
        ArrayList<MonotypeLeqCst> a = new ArrayList<MonotypeLeqCst>(c1.length);
        for (int i = 0; i < c1.length; ++i) {
            Monotype m1 = c1[i];
            Monotype m2 = c2[i];
            if (m1.equals(m2)) continue;
            a.add(new MonotypeLeqCst(m1, m2));
        }
        return new Constraint(null, a.toArray(new AtomicConstraint[a.size()]));
    }

    public String toString() {
        return this.m1 + " <: " + this.m2;
    }
}

