/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IncrementExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.expr.ThisExp;
import java.util.Enumeration;
import java.util.Hashtable;

public class FindCapturedVars
extends ExpWalker {
    Hashtable unknownDecls = null;
    ModuleExp currentModule = null;

    public static void findCapturedVars(Expression exp) {
        exp.walk(new FindCapturedVars());
    }

    @Override
    protected Expression walkApplyExp(ApplyExp exp) {
        Expression value;
        Declaration decl;
        boolean skipFunc = false;
        if (exp.func instanceof ReferenceExp && !Compilation.usingTailCalls && (decl = Declaration.followAliases(((ReferenceExp)exp.func).binding)) != null && decl.context instanceof ModuleExp && (value = decl.getValue()) instanceof LambdaExp) {
            LambdaExp lexp = (LambdaExp)value;
            LambdaExp cur = this.getCurrentLambda();
            if (!lexp.getNeedsClosureEnv()) {
                skipFunc = true;
            }
        }
        if (!skipFunc) {
            exp.func = exp.func.walk(this);
        }
        if (this.exitValue == null) {
            exp.args = this.walkExps(exp.args);
        }
        return exp;
    }

    @Override
    public void walkDefaultArgs(LambdaExp exp) {
        if (exp.defaultArgs == null) {
            return;
        }
        super.walkDefaultArgs(exp);
        for (Declaration param = exp.firstDecl(); param != null; param = param.nextDecl()) {
            if (param.isSimple()) continue;
            exp.setFlag(true, 512);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkModuleExp(ModuleExp exp) {
        Expression expression;
        Hashtable saveDecls;
        ModuleExp saveModule;
        block5: {
            int i;
            Enumeration e;
            int count;
            saveModule = this.currentModule;
            saveDecls = this.unknownDecls;
            this.currentModule = exp;
            this.unknownDecls = null;
            try {
                expression = this.walkLambdaExp(exp);
                if (this.unknownDecls == null) break block5;
                count = this.unknownDecls.size();
                e = this.unknownDecls.keys();
                i = 0;
            }
            catch (Throwable throwable) {
                if (this.unknownDecls != null) {
                    int count2 = this.unknownDecls.size();
                    Enumeration e2 = this.unknownDecls.keys();
                    int i2 = 0;
                    Expression[] init = new Expression[1];
                    LetExp let = new LetExp(init);
                    Declaration env = let.addDeclaration("env$", Compilation.typeEnvironment);
                    init[0] = new ApplyExp(Compilation.getCurrentEnvironmentMethod, Expression.noExpressions);
                    env.setCanRead(true);
                    env.noteValue(init[0]);
                    Expression[] exps = new Expression[count2 + 1];
                    while (e2.hasMoreElements()) {
                        String id = (String)e2.nextElement();
                        Declaration decl = (Declaration)this.unknownDecls.get(id);
                        Expression[] args = new Expression[]{new ReferenceExp(env), new QuoteExp(id)};
                        SetExp set = new SetExp(decl, (Expression)new ApplyExp(Compilation.getBindingEnvironmentMethod, args));
                        set.setDefining(true);
                        exps[i2] = set;
                        ++i2;
                    }
                    exps[i2] = this.currentModule.body;
                    let.setBody(new BeginExp(exps));
                    this.currentModule.body = let;
                }
                this.currentModule = saveModule;
                this.unknownDecls = saveDecls;
                throw throwable;
            }
            Expression[] init = new Expression[1];
            LetExp let = new LetExp(init);
            Declaration env = let.addDeclaration("env$", Compilation.typeEnvironment);
            init[0] = new ApplyExp(Compilation.getCurrentEnvironmentMethod, Expression.noExpressions);
            env.setCanRead(true);
            env.noteValue(init[0]);
            Expression[] exps = new Expression[count + 1];
            while (e.hasMoreElements()) {
                String id = (String)e.nextElement();
                Declaration decl = (Declaration)this.unknownDecls.get(id);
                Expression[] args = new Expression[]{new ReferenceExp(env), new QuoteExp(id)};
                SetExp set = new SetExp(decl, (Expression)new ApplyExp(Compilation.getBindingEnvironmentMethod, args));
                set.setDefining(true);
                exps[i] = set;
                ++i;
            }
            exps[i] = this.currentModule.body;
            let.setBody(new BeginExp(exps));
            this.currentModule.body = let;
        }
        this.currentModule = saveModule;
        this.unknownDecls = saveDecls;
        return expression;
    }

    @Override
    protected Expression walkFluidLetExp(FluidLetExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            Declaration bind = this.allocUnboundDecl(decl.getName());
            this.capture(bind);
            decl.base = bind;
        }
        return super.walkLetExp(exp);
    }

    @Override
    protected Expression walkLetExp(LetExp exp) {
        if (exp.body instanceof BeginExp) {
            Expression[] inits = exp.inits;
            int len = inits.length;
            BeginExp bexp = (BeginExp)exp.body;
            Expression[] exps = bexp.exps;
            if (bexp.length > len) {
                Declaration decl = exp.firstDecl();
                for (int i = 0; i < len; ++i) {
                    if (inits[i] == QuoteExp.nullExp && exps[i] instanceof SetExp) {
                        SetExp set = (SetExp)exps[i];
                        if ((set.new_value instanceof LambdaExp || set.new_value instanceof QuoteExp) && set.binding == decl) {
                            inits[i] = set.new_value;
                            exps[i] = QuoteExp.voidExp;
                        }
                    }
                    decl = decl.nextDecl();
                }
            }
        }
        return super.walkLetExp(exp);
    }

    public void capture(Declaration decl) {
        LambdaExp declValue;
        if (!decl.getCanRead() && !decl.getCanCall()) {
            return;
        }
        if (decl.getFlag(65536)) {
            return;
        }
        if (decl.field != null && decl.field.getStaticFlag()) {
            return;
        }
        if (decl.getFlag(16384) && decl.getValue() instanceof QuoteExp) {
            return;
        }
        LambdaExp curLambda = this.getCurrentLambda();
        LambdaExp declLambda = decl.getContext().currentLambda();
        LambdaExp oldParent = null;
        LambdaExp chain = null;
        while (curLambda != declLambda && curLambda.getInlineOnly()) {
            LambdaExp curParent = curLambda.outerLambda();
            if (curParent != oldParent) {
                chain = curParent.firstChild;
                oldParent = curParent;
            }
            ApplyExp curReturn = curLambda.returnContinuation;
            if (chain == null || curReturn == null) {
                curLambda.setCanCall(false);
                return;
            }
            curLambda = curReturn.context;
            chain = chain.nextSibling;
        }
        if (Compilation.usingCPStyle() ? curLambda instanceof ModuleExp : curLambda == declLambda) {
            return;
        }
        Expression value = decl.getValue();
        if (value == null || !(value instanceof LambdaExp)) {
            declValue = null;
        } else {
            declValue = (LambdaExp)value;
            if (declValue.getInlineOnly()) {
                return;
            }
            if (declValue.isHandlingTailCalls()) {
                declValue = null;
            } else if (declValue == curLambda && !decl.getCanRead()) {
                return;
            }
        }
        if (decl.getFlag(2048)) {
            decl.setSimple(false);
        } else if (decl.getCanRead() || declValue == null) {
            LambdaExp parent;
            LambdaExp heapLambda = curLambda;
            heapLambda.setImportsLexVars();
            LambdaExp outer = parent = heapLambda.outerLambda();
            while (outer != declLambda && outer != null) {
                heapLambda = outer;
                if (!decl.getCanRead() && declValue == outer) break;
                heapLambda.setNeedsStaticLink();
                outer = heapLambda.outerLambda();
            }
            if (decl.base != null) {
                decl.base.setCanRead(true);
                this.capture(decl.base);
            }
            if (decl.isSimple()) {
                if (declLambda.capturedVars == null && !(declLambda instanceof ModuleExp) && !(declLambda instanceof ClassExp)) {
                    declLambda.heapFrame = new Variable("heapFrame");
                    declLambda.heapFrame.setArtificial(true);
                }
                decl.setSimple(false);
                if (!decl.isPublic()) {
                    decl.nextCapturedVar = declLambda.capturedVars;
                    declLambda.capturedVars = decl;
                }
            }
        }
    }

    Declaration allocUnboundDecl(String name) {
        Declaration decl;
        if (this.unknownDecls == null) {
            this.unknownDecls = new Hashtable(100);
            decl = null;
        } else {
            decl = (Declaration)this.unknownDecls.get(name);
        }
        if (decl == null) {
            decl = this.currentModule.addDeclaration(name);
            decl.setSimple(false);
            decl.setPrivate(true);
            if (this.currentModule.isStatic()) {
                decl.setFlag(2048);
            }
            decl.setCanRead(true);
            decl.setFlag(65536);
            decl.setIndirectBinding(true);
            this.unknownDecls.put(name, decl);
        }
        return decl;
    }

    @Override
    protected Expression walkReferenceExp(ReferenceExp exp) {
        Declaration decl = exp.getBinding();
        if (decl == null) {
            decl = this.allocUnboundDecl(exp.getName());
            exp.setBinding(decl);
        } else {
            this.capture(Declaration.followAliases(decl));
        }
        return exp;
    }

    @Override
    protected Expression walkThisExp(ThisExp exp) {
        if (exp.getBinding() != null) {
            this.capture(exp.getBinding());
        }
        return exp;
    }

    @Override
    protected Expression walkSetExp(SetExp exp) {
        Declaration decl = exp.binding;
        if (decl == null) {
            exp.binding = decl = this.allocUnboundDecl(exp.getName());
        } else {
            this.capture(Declaration.followAliases(decl));
        }
        return super.walkSetExp(exp);
    }

    @Override
    public Expression walkIncrementExp(IncrementExp exp) {
        Declaration decl = Declaration.followAliases(exp.decl);
        if (decl != null) {
            this.capture(decl);
        }
        return super.walkIncrementExp(exp);
    }
}

