/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure1;

public class IncrementProc
extends Procedure1
implements Inlineable {
    private Declaration fieldDecl;
    private boolean increment;
    private boolean returnOld;

    public IncrementProc(Declaration field, boolean returnOld, boolean increment) {
        this.fieldDecl = field;
        this.returnOld = returnOld;
        this.increment = increment;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Field field = this.fieldDecl.field;
        CodeAttr code = comp.getCode();
        ClassType ctype = field.getDeclaringClass();
        Expression[] args = exp.getArgs();
        boolean ignore = target instanceof IgnoreTarget;
        boolean isLong = field.getType().getSize() > 4;
        PrimType type = isLong ? Type.long_type : Type.int_type;
        args[0].compile(comp, ctype);
        code.emitDup(ctype);
        code.emitGetField(field);
        if (!ignore && this.returnOld) {
            code.emitDup(isLong ? 2 : 1, 1);
        }
        if (isLong) {
            code.emitPushLong(1L);
        } else {
            code.emitPushInt(1);
        }
        if (this.increment) {
            code.emitAdd(type);
        } else {
            code.emitSub(type);
        }
        if (!ignore && !this.returnOld) {
            code.emitDup(isLong ? 2 : 1, 1);
        }
        code.emitPutField(field);
        if (!ignore) {
            target.compileFromStack(comp, field.getType());
        }
    }

    public Type getReturnType(Expression[] args) {
        return this.fieldDecl.getType();
    }

    public Object apply1(Object arg1) {
        throw new RuntimeException("not implemented");
    }
}

