/*  VER 050   TAB P   $Id: auth.c,v 1.16.2.1 2002/01/29 06:44:48 egil Exp $
 *
 *  authorization related stuff
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: auth.c,v $
 *  Revision 1.16.2.1  2002/01/29 06:44:48  egil
 *  Changing from xmalloc, xrealloc, xstrcpy to
 *  malloc_perfect, realloc_perfect and strdup_perfect
 *
 *  Revision 1.16  1998/09/14 05:41:04  src
 *  Added setenv.h
 *
 *  Revision 1.15  1998/09/13 13:29:21  src
 *  Always use setenv() if not putenv()
 *
 *  Revision 1.14  1998/09/11 09:17:41  src
 *  Check path consistency (--no-path) and length (--max-path)
 *  GNU style option --help, --version, --dry-run, changed --noxx to --no-xx
 *  Check for putenv and setenv, added xstrcpy
 *
 *  Revision 1.13  1998/09/09 07:32:10  src
 *  Version 1.1
 *
 *  Revision 1.12  1998/09/03 05:14:30  src
 *  Improved bad syntax messages
 *
 *  Revision 1.10  1998/09/03 02:49:29  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.9  1998/09/02 06:50:30  src
 *  newsx version 1.0
 *
 *  Revision 1.8  1998/09/02 06:34:41  src
 *  Support @-syntax in newsfeeds, and support AUTHINFO GENERIC
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "nntp.h"

#if !defined(HAVE_PUTENV) && !defined(HAVE_SETENV)
#include "../lib/setenv.h"
#endif

/*
 *  pick authorisation info
 */
void 
get_authinfo(char *file)
{
    FILE *f;
    char *p;
    int n = 0;
    static char buf[BUFSIZ];

    if (!(f = fopen(file,"r"))) {
	log_msg(L_ERRno,"can't open authorization file \"%s\"",file);
	exit_cleanup(10);
    }
    while (fgets(buf,BUFSIZ,f)) {
	p = buf;
	while (isspace(*p)) ++p;
	if (p[0] && p[0] != '#') {
	    ai_username = p;
	    while (*p && !isspace(*p)) ++p;
	    if (!*p) {
	      bad:
		bad_syntax(buf,n,2,"authinfo");
		exit_cleanup(10);
	    }
	    *p++ = '\0';
	    ++n;
	    log_msg(L_DEBUGMORE,"username %s",ai_username);
	    while (isspace(*p)) ++p;
	    if (!*p) goto bad;
	    ai_password = p;
	    while (*p && !isspace(*p)) ++p;
	    *p = '\0';
	    break;
	}
    }
    fclose(f);
}

/*
 * handle AUTHINFO GENERIC.
 *      -- Peter Maydell <pmaydell@chiark.greenend.org.uk> 08/1998
 *
 * AUTHINFO GENERIC is handled by running a user-specified
 * program to deal with the challenge and response.
 * The program is specified in the NNTPAUTH environment variable;
 * this has already been read into the username string.
 *
 * This code is essentially from a hacked inews that I think Ian
 * Jackson had a hand in...
 */
static void
do_authinfo_generic(char *username)
{
    char buf[NNTP_STRLEN];
    FILE *tfile;
    char *fdsenv;
    int cookie;

    /* get connection details (filedescriptors) */
    SOCKET_D *sock = current_socket();

    fdsenv = getenv("NNTP_AUTH_FDS");
    if (!fdsenv || sscanf(fdsenv, "%*u.%*u.%u",&cookie) != 1) {
	 tfile = tmpfile();
	 if (!tfile) {
	    log_msg(L_ERRno,"cannot create temp file");
	    unlock_exit(1);
	 }
	 cookie = fileno(tfile);
    }

    /* We set NNTP_AUTH_FDS to let the child process know which
     * file descriptors to use to read and write to the news server.
     * If the no-action flag was set then sock->r_str and sock->w_str
     * will be zero, so don't try either setting NNTP_AUTH_FDS or
     * spawning the authentication process, to avoid a coredump...
     */
    if (!noaction_opt) {
	char env[1024];
#ifdef HAVE_PUTENV
	sprintf(env,"NNTP_AUTH_FDS=%d.%d.%d",
	       fileno(sock->r_str),fileno(sock->w_str),cookie);
	putenv(strdup_perfect(env));
	/* suspect that some putenv's might need an allocated value */
#else
	 sprintf(env,"%d.%d.%d",
	       fileno(sock->r_str),fileno(sock->w_str),cookie);
	 setenv("NNTP_AUTH_FDS",env,1);
#endif
    }

    sprintf(buf,"AUTHINFO GENERIC %.990s%s", username, newline);
    put_server(buf);
    /* forking the new process is a fact worth noting... */
    log_msg(L_INFO, "spawning authinfo generic process: %s",username);
    progtitle("spawning authinfo generic process");
    if (!noaction_opt) {
       if (system(username)) {
	  log_msg(L_ERR,"authentication failed");
	  unlock_exit(4);
       }
    }
    /* if we got this far we successfully authenticated ourselves */
}

/*
 *  AUTHINFO USER
 */
static void
do_authinfo_user(char *username,char *password)
{
    char buf[NNTP_STRLEN];
    char *endptr;

    /* send the username to the server */
    sprintf(buf, "AUTHINFO USER %s%s", username,newline);
    if (!put_server(buf)) exit_cleanup(9);
    if (noaction_opt) return;

    /* get the response and check it's okay */
    if (!get_server_nntp(buf, sizeof(buf))) exit_cleanup(9);
    if (strtoul(buf,&endptr,10) != NEED_AUTHDATA) {
	log_msg(L_ERR,"NNTP authinfo protocol error: got \"%s\"", buf);
	exit_cleanup(4);
    }
			
    /* send the password to the server, 
       avoiding announcing password too loudly */
    sprintf(buf, "AUTHINFO PASS *%s", newline);
    log_msg(L_PUT,"%s", buf);
    sprintf(buf, "AUTHINFO PASS %s%s", password,newline);
    if (!put_server_nolog(buf)) exit_cleanup(9);
    memset(buf,0,sizeof(buf));

    /* get the response and check it's okay */
    if (!get_server_nntp(buf, sizeof(buf))) {
	exit_cleanup(9);
    }
    if (strtoul(buf,&endptr,10) != OK_AUTH) {
	log_msg(L_ERR,"NNTP authorization failed: got \"%s\"", buf);
	exit_cleanup(9);
    }
}

/*
 *  check in the authinfo username and password with the
 *  server 
 */
void 
do_authinfo(char *username,char *password)
{
    progtitle("do authinfo");

    if (ai_isgeneric) do_authinfo_generic(username);
    else do_authinfo_user(username,password);
}

/*
 *  send mode reader command to INN to switch to nnrpd
 *  so we can do a NEWNEWS.
 */
void 
do_mode_reader(void)
{
    char buf[NNTP_STRLEN];
    char *endptr;

    progtitle("mode reader");
    /* send the command to the server */
    sprintf(buf, "MODE READER%s", newline);
    if (!put_server(buf)) exit_cleanup(9);
    if (noaction_opt) return;

    /* get the response and check it's okay */
    if (!get_server_nntp(buf,sizeof(buf))) exit_cleanup(9);

    switch (strtoul(buf,&endptr,10)) {
    case OK_NOPOST:
	/* BUG: handle this? */
    case OK_CANPOST:
	break;
    default:
	log_msg(L_ERR,"NNTP mode reader protocol error: got \"%s\"", buf);
	exit_cleanup(4);
    }
}
