#ifdef _WIN32
#pragma warning(disable:4786)
#endif

#include <PkiClient.h>
#include <openssl/conf.h>

#include <openssl/conf.h>

PkiClient PkiConnection(NULL);
PKI_PKCS12 AdminP12;
int NoCleanUp = 0;
int dontdestroy = 0;
time_t starttime;
mString email;



class EntityInfo
{
public:
	EntityInfo()
	{
		m_port = 0;
		m_type = -1;
	}
	EntityInfo(const EntityInfo & other)
	{
		*this = other;
	}
	~EntityInfo()
	{
	}
	bool operator=(const EntityInfo & other)
	{
		m_host = other.m_host;
		m_port = other.m_port;
		m_type = other.m_type;
		m_options = other.m_options;
		m_links = other.m_links;
		m_rmlinks = other.m_rmlinks;
		m_strType = other.m_strType;
		m_cert = other.m_cert;
		return true;
	}
	void set_host(const mString & host)
	{
		m_host = host;
	}
	const mString & get_host() const
	{
		return m_host;
	}
	void set_port(int port)
	{
		m_port = port;
	}
	int get_port() const
	{
		return m_port;
	}
	void set_type(int type, const mString & strType)
	{
		m_type = type;
		m_strType = strType;
	}
	const mString & get_strType() const
	{
		return m_strType;
	}
	int get_type() const
	{
		return m_type;
	}
	map<mString, mString> & get_options()
	{
		return m_options;
	}
	const mString & get_options(const mString & name) const
	{
		return ((EntityInfo*)this)->m_options[name];
	}
	mVector<mString> & get_links()
	{
		return m_links;
	}
	const mVector<mString> & get_links() const
	{
		return m_links;
	}
	mVector<mString> & get_rmlinks()
	{
		return m_rmlinks;
	}
	const mVector<mString> & get_rmlinks() const
	{
		return m_rmlinks;
	}

	const PKI_CERT & get_cert() const
	{
		return m_cert;
	}

	PKI_CERT & get_cert()
	{
		return m_cert;
	}
private:
	mString m_host;
	int m_port;
	int m_type;
	mString m_strType;
	map<mString, mString> m_options;
	mVector<mString> m_links;
	mVector<mString> m_rmlinks;
	PKI_CERT m_cert;
};


void create_pki(const mString & name, EntityInfo & entity);
void create_std_entity(const mString & name, EntityInfo & entity);
void destroy_std_entity(const char * name);
void link_entity(const mString & name, const EntityInfo & entity);
void configure_ca(CONF *conf, const mString & name, const EntityInfo & entity);
void configure_ra(CONF *conf, const mString & name, const EntityInfo & entity);
void get_entity_conf(const mString & name, PKI_CERT & cert, EntityConfBody & conf);
void set_entity_conf(const PKI_CERT & cert, const EntityConfBody & conf);
void init_ca(const mString & name, const EntityInfo & entity);
void test_logs(const mString & name, const EntityInfo & entity);



void add_link(const char * from, const char * to);
void rem_link(const char * from, const char * to);
void create_cas();
void create_child_ca(PkiClient * RootCaConnection, const char * child_name);
void request_certs(const NewpkiThread * myThread, void * param);
void test_server_users(const EntityInfo & entity);
void test_pki_users(const mString & name, const EntityInfo & entity);
void destroy_entity(const mString & name, const EntityInfo & entity);


map<mString, EntityInfo> entities;

void clean_up(int wait = 1)
{
	std::map<mString, EntityInfo>::iterator i;

	if(!NoCleanUp && !dontdestroy)
	{
		for(i=entities.begin(); i != entities.end(); i++)
		{
			destroy_entity(i->first, i->second);
		}
	}
	if(wait)
		getchar();
	exit(1);
}


int int_string_cb(const char * value, int len, void *arg)
{
	mVector<mString> * list = (mVector<mString> *)arg;
	mString val = value;
	val = val.Left(len);
	list->push_back(val);
	return 1;
}

int main(int argc, char* argv[])
{
	CONF *conf;
	long errorline;
	char * strEntities;
	mVector<mString> entitiesList;
	STACK_OF(CONF_VALUE) *nval;
	CONF_VALUE *val;	
	size_t i;
	int j;
	std::map<mString, EntityInfo>::iterator iEntity;
	time_t tt1;
	time_t tt2;
	mVector< NewpkiThread* > Threads;
	NewpkiThread* newThread;
	unsigned long threads;
	char * p12file = NULL;
	AdminReqLogin login;
	int type;
	mString pkiname;
	char * strTmp;


	NewpkiThread::SignalStart();


#	ifdef _WIN32
		WSADATA StartupData;
		WSAStartup(0x101, &StartupData);
#	endif

	INIT_OPENSSL();


	
	conf = NCONF_new(NULL);
	if (NCONF_load(conf, "tests.conf", &errorline) <= 0)
	{
		if (errorline <= 0)
			fprintf(stderr, "error loading the config file '%s'\n",
				"tests.conf");
		else
			fprintf(stderr, "error on line %ld of config file '%s'\n"
				,errorline, "tests.conf");

		NCONF_free(conf);
		return 1;
	}

	strEntities = NCONF_get_string(conf, NULL, "entities");
	if(!strEntities)
	{
		fprintf(stderr, "You must specify an entities list in the global section\n");
		NCONF_free(conf);
		return 1;
	}

	strTmp = NCONF_get_string(conf, NULL, "email");
	if(!strTmp)
	{
		fprintf(stderr, "You must specify an email entry in the global section\n");
		NCONF_free(conf);
		return 1;
	}
	email = strTmp;

	strTmp = NCONF_get_string(conf, NULL, "dontdestroy");
	if(strTmp)
	{
		sscanf(strTmp, "%d", &dontdestroy);
	}

	if (!CONF_parse_list(strEntities, ',', 0, int_string_cb, &entitiesList))
	{
		ERR_print_errors_fp(stderr);
		NCONF_free(conf);
		return 1;
	}

	for(i=0; i<entitiesList.size(); i++)
	{
		if (!(nval = NCONF_get_section(conf, entitiesList[i].c_str())))
		{
			fprintf(stderr, "You must specify a section for %s\n", entitiesList[i].c_str());
			NCONF_free(conf);
			return 1;
		}
		for (j = 0; j < sk_CONF_VALUE_num(nval); j++)
		{
			val = sk_CONF_VALUE_value(nval, j);
			if(strcmp(val->name, "host") == 0)
			{
				entities[entitiesList[i]].set_host(val->value);
			}
			else if(strcmp(val->name, "port") == 0)
			{
				entities[entitiesList[i]].set_port(atoi(val->value));
			}
			else if(strcmp(val->name, "type") == 0)
			{
				if(strcmp(val->value, "PKI") == 0)
				{
					if(pkiname.size())
					{
						fprintf(stderr, "You can only have one PKI\n");
						NCONF_free(conf);
						return 1;
					}
					entities[entitiesList[i]].set_type(ENTITY_TYPE_PKI, val->value);
					p12file = NCONF_get_string(conf, entitiesList[i].c_str(), "loadp12");
					pkiname = entitiesList[i];
				}
				else if(strcmp(val->value, "REPOSITORY") == 0)
				{
					entities[entitiesList[i]].set_type(ENTITY_TYPE_REPOSITORY, val->value);
				}
				else if(strcmp(val->value, "RA") == 0)
				{
					entities[entitiesList[i]].set_type(ENTITY_TYPE_RA, val->value);
				}
				else if(strcmp(val->value, "CA") == 0)
				{
					entities[entitiesList[i]].set_type(ENTITY_TYPE_CA, val->value);
				}
				else if(strcmp(val->value, "PUBLICATION") == 0)
				{
					entities[entitiesList[i]].set_type(ENTITY_TYPE_PUBLICATION, val->value);
				}
				else if(strcmp(val->value, "KEYSTORE") == 0)
				{
					entities[entitiesList[i]].set_type(ENTITY_TYPE_KEY_STORE, val->value);
				}
				else if(strcmp(val->value, "BACKUP") == 0)
				{
					entities[entitiesList[i]].set_type(ENTITY_TYPE_BACKUP, val->value);
				}
				else if(strcmp(val->value, "EE") == 0)
				{
					entities[entitiesList[i]].set_type(ENTITY_TYPE_EE, val->value);
				}
				else
				{
					fprintf(stderr, "Invalid entity type for [%s]\n", entitiesList[i].c_str());
					NCONF_free(conf);
					return 1;
				}
			}
			else if(strcmp(val->name, "links") == 0)
			{
				if (!CONF_parse_list(val->value, ',', 0, int_string_cb, &entities[entitiesList[i]].get_links()))
				{
					ERR_print_errors_fp(stderr);
					NCONF_free(conf);
					return 1;
				}
			}
			else if(strcmp(val->name, "rmlinks") == 0)
			{
				if (!CONF_parse_list(val->value, ',', 0, int_string_cb, &entities[entitiesList[i]].get_rmlinks()))
				{
					ERR_print_errors_fp(stderr);
					NCONF_free(conf);
					return 1;
				}
			}
			else
			{
				entities[entitiesList[i]].get_options()[val->name] = val->value;
			}
		}
	}

	// Validate the entity section
	for(iEntity=entities.begin(); iEntity != entities.end(); iEntity++)
	{

		if(!iEntity->second.get_host().size())
		{
			fprintf(stderr, "You must specify a host value for entity %s\n", iEntity->first.c_str());
			NCONF_free(conf);
			return 1;
		}
		if(!iEntity->second.get_port())
		{
			fprintf(stderr, "You must specify a port value for entity %s\n", iEntity->first.c_str());
			NCONF_free(conf);
			return 1;
		}
		if(iEntity->second.get_type() == -1)
		{
			fprintf(stderr, "You must specify a type value for entity %s\n", iEntity->first.c_str());
			NCONF_free(conf);
			return 1;
		}

		switch(iEntity->second.get_type())
		{
			case ENTITY_TYPE_CA:
				if(iEntity->second.get_options("extensions") == "")
				{
					fprintf(stderr, "You must specify a extensions value for CA %s\n", iEntity->first.c_str());
					NCONF_free(conf);
					return 1;
				}
				if (!(nval = NCONF_get_section(conf, iEntity->second.get_options("extensions").c_str())))
				{
					fprintf(stderr,"Couldn't find section %s for CA %s\n", iEntity->second.get_options("extensions").c_str(), iEntity->first.c_str());
					NCONF_free(conf);
					return 1;
				}
				if( !(iEntity->second.get_options("rootca") == "") )
				{
					if(entities.find(iEntity->second.get_options("rootca")) == entities.end())
					{
						fprintf(stderr, "Couldn't find rootca %s for CA %s\n", iEntity->second.get_options("rootca").c_str(), \
										iEntity->first.c_str());
						NCONF_free(conf);
						return 1;
					}
				}
				break;
			case ENTITY_TYPE_RA:
				if(iEntity->second.get_options("threads") == "")
				{
					fprintf(stderr, "You must specify a threads value for RA %s\n", iEntity->first.c_str());
					NCONF_free(conf);
					return 1;
				}
				if(iEntity->second.get_options("profiles") == "")
				{
					fprintf(stderr, "You must specify a profiles value for RA %s\n", iEntity->first.c_str());
					NCONF_free(conf);
					return 1;
				}
				break;
		}
	}

	if(!pkiname.size())
	{
		fprintf(stderr, "You must specify one PKI entity\n");
		NCONF_free(conf);
		return 1;
	}

	if(!p12file) // Are we supposed to create the entities?
	{
		NoCleanUp = 0;

		// Do the creation of the PKI first
		for(iEntity=entities.begin(); iEntity != entities.end(); iEntity++)
		{
			if(iEntity->second.get_type() != ENTITY_TYPE_PKI)
				continue;
			create_pki(iEntity->first, iEntity->second);
			break;
		}

		// Do the creation of the repositories
		for(iEntity=entities.begin(); iEntity != entities.end(); iEntity++)
		{
			if(iEntity->second.get_type() != ENTITY_TYPE_REPOSITORY)
				continue;
			create_std_entity(iEntity->first, iEntity->second);
		}

		// Do the creation of all the others
		for(iEntity=entities.begin(); iEntity != entities.end(); iEntity++)
		{
			if(iEntity->second.get_type() == ENTITY_TYPE_REPOSITORY ||
				iEntity->second.get_type() == ENTITY_TYPE_PKI)
				continue;
			create_std_entity(iEntity->first, iEntity->second);
		}

		// We now link the entities
		for(iEntity=entities.begin(); iEntity != entities.end(); iEntity++)
		{
			link_entity(iEntity->first, iEntity->second);
		}


		// Configure the entities
		for(iEntity=entities.begin(); iEntity != entities.end(); iEntity++)
		{
			switch(iEntity->second.get_type())
			{
				case ENTITY_TYPE_CA:
					configure_ca(conf, iEntity->first, iEntity->second);
					break;
				case ENTITY_TYPE_RA:
					configure_ra(conf, iEntity->first, iEntity->second);
					break;
			}
		}

		// We test the server uses creation
		test_server_users(entities[pkiname]);

		// We wait a bit for the conf to propagate
		time(&tt1);
		do
		{
			NewpkiThread::Sleep(1000);
			printf(".");
			fflush(stdout);
			time(&tt2);
		}
		while( (tt2 - tt1) < 180);
		printf("\n");

		// Initialize the CA
		for(iEntity=entities.begin(); iEntity != entities.end(); iEntity++)
		{
			if(iEntity->second.get_type() != ENTITY_TYPE_CA)
				continue;

			init_ca(iEntity->first, iEntity->second);
		}

		// Test the logs
		for(iEntity=entities.begin(); iEntity != entities.end(); iEntity++)
		{
			test_logs(iEntity->first, iEntity->second);
		}

	}
	else
	{
		NoCleanUp = 1;
		
		if(!AdminP12.LoadFromFile(p12file, "azerty"))
		{
			ERR_print_errors_fp(stderr);
			clean_up();
		}

		// Create the connection to the PKI entity
		if(!PkiConnection.Connect(entities[pkiname].get_host(), entities[pkiname].get_port(), AdminP12.GetEndUserCert(), NULL))
		{
			fprintf(stderr, PkiConnection.GetError());
			clean_up();
		}
		login.Clear();
		login.set_entity(pkiname);
		if(!PkiConnection.UserLogin(login, type))
		{
			fprintf(stderr, PkiConnection.GetError());
			clean_up();
		}
	}

	// Start the profiles generation
	time(&starttime);
	for(iEntity=entities.begin(); iEntity != entities.end(); iEntity++)
	{
		if(iEntity->second.get_type() != ENTITY_TYPE_RA)
			continue;

		threads = iEntity->second.get_options("threads").c_ulng();

		for(i=0; i<threads; i++)
		{
			newThread = new NewpkiThread();
			newThread->Create(request_certs, (void*)&iEntity->first);
			newThread->Start();
			Threads.push_back(newThread);
			NewpkiThread::Sleep(7000);
		}
	}



	bool ShouldContinue;
	do
	{
		ShouldContinue = false;
		for(i=0; i<Threads.size(); i++)
		{
			if(Threads[i]->IsRunning())
			{
				ShouldContinue = true;
				break;
			}
		}
		NewpkiThread::Sleep(1000);
	}
	while(ShouldContinue);

	NCONF_free(conf);
	clean_up(0);
	return 1;
}

/*

void destroy_std_entity(const mString & name)
{
	mVector<EntityEntryInfo> m_entities;
	size_t i;

	if(!PkiConnection.EnumEntities(m_entities))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}

	for(i = 0; i < m_entities.size(); i++)
	{
		if(m_entities[i].get_name() == name)
		{
			break;
		}
	}
	if(i == m_entities.size())
	{
		fprintf(stderr,"Could not find entity %s\n", name.c_str());
		clean_up();
	}

	if(!PkiConnection.RevokeEntityCert(m_entities[i].get_certificate().GetSerial()))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}

	if(!RootConnection.DeleteEntity(name))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
}

*/


void destroy_entity(const mString & name, const EntityInfo & entity)
{
	EntityCreationReq req;
	EntityCreationResp resp;
	HashTable_Dn Dn;
	PkiClient RootConnection(NULL);
	AdminReqLogin login;
	int type;

	if(!RootConnection.Connect(entity.get_host(), entity.get_port(), PKI_CERT::EmptyInstance, NULL))
	{
		fprintf(stderr, RootConnection.GetError());
		return;
	}
	login.set_username("root");
	login.set_password("root");

	if(!RootConnection.UserLogin(login, type))
	{
		fprintf(stderr, RootConnection.GetError());
		return;
	}

	RootConnection.DeleteEntity(name);
}

void set_mail_conf(const EntityInfo & entity)
{
	EmailConf mail_conf;
	mString mail_server;
	mString mail_port;
	int pos;

	if(!entity.get_options("smtp").size())
		return;

	mail_server = entity.get_options("smtp");
	pos = mail_server.find(":", 0);
	if(pos != 1)
	{
		mail_port = mail_server.Right(mail_server.size() - pos - 1);
		mail_server = mail_server.Left(pos);
	}
	else
	{
		mail_port = "25";
	}
	mail_conf.set_port(mail_port.c_ulng());
	mail_conf.set_server(mail_server);

	if(!PkiConnection.ResourceLock(entity.get_cert().GetStringName()))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
	if(!PkiConnection.SetEntityMailConf(entity.get_cert(), mail_conf))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
	if(!PkiConnection.ResourceUnlock(entity.get_cert().GetStringName()))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
}

void create_pki(const mString & name, EntityInfo & entity)
{
	EntityCreationReq req;
	EntityCreationResp resp;
	HashTable_Dn Dn;
	PkiClient RootConnection(NULL);
	AdminReqLogin login;
	int type;
	FILE * fd;



	printf("Creating PKI : %s...\n", name.c_str());

	if(!RootConnection.Connect(entity.get_host(), entity.get_port(), PKI_CERT::EmptyInstance, NULL))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}
	login.set_username("root");
	login.set_password("root");

	if(!RootConnection.UserLogin(login, type))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}

	req.set_name(name);
	req.get_datas().set_type(ENTITY_TYPE_PKI);
	Dn.Add("organizationalUnitName", "Tests PKI");
	Dn.Add("organizationName", "NewPKI");
	Dn.Add("countryName", "FR");
	Dn.Add("stateOrProvinceName", "75");
	Dn.Add("localityName", "Paris");
	Dn.To_X509_NAME(req.get_datas().get_pkiCreate().get_dn());
	req.get_datas().get_pkiCreate().set_email(email);
	req.get_datas().get_pkiCreate().set_validity(365);

	// Admin certificate
	req.get_datas().get_pkiCreate().get_admincreate().set_cn("PKI - Administrator");
	req.get_datas().get_pkiCreate().get_admincreate().set_email("frederic.giudicelli@newpki.org");
	req.get_datas().get_pkiCreate().get_admincreate().set_pkiadmin(1);
	req.get_datas().get_pkiCreate().get_admincreate().get_ukey().set_type(PKI_USER_KEY_TYPE_SOFTKEY);
	req.get_datas().get_pkiCreate().get_admincreate().get_ukey().get_softkey().set_password("azerty");
	req.get_datas().get_pkiCreate().get_admincreate().get_ukey().get_softkey().set_keylen(1024);


	req.get_datas().get_pkiCreate().get_entitiesCa().set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN);
	req.get_datas().get_pkiCreate().get_entitiesCa().set_keylen(1024);
	req.get_datas().get_pkiCreate().set_rootCa(req.get_datas().get_pkiCreate().get_entitiesCa());
	req.get_datas().get_pkiCreate().set_ocspCa(req.get_datas().get_pkiCreate().get_entitiesCa());
	req.get_datas().get_pkiCreate().set_usersCa(req.get_datas().get_pkiCreate().get_entitiesCa());
	req.get_datas().get_pkiCreate().set_entityKey(req.get_datas().get_pkiCreate().get_entitiesCa());
	
	if(!RootConnection.CreateEntity(req, resp))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}

	if(!AdminP12.Load(resp.get_pkiCreate().get_p12().GetPemPKCS12(), "azerty"))
	{
		ERR_print_errors_fp(stderr);
		clean_up();
	}

	// Create the connection to the PKI entity
	if(!PkiConnection.Connect(entity.get_host(), entity.get_port(), AdminP12.GetEndUserCert(), NULL))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
	login.Clear();
	login.set_entity(name);
	if(!PkiConnection.UserLogin(login, type))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}

	// Set its certificate
	PkiConnection.GetEntityCert(entity.get_cert());

	// Set the mail conf
	set_mail_conf(entity);

	if(entity.get_options("savep12").size())
	{
		fd = fopen(entity.get_options("savep12").c_str(), "wb");
		if(!fd)
		{
			fprintf(stderr, strerror(errno));
			clean_up();
		}

		if(i2d_PKCS12_fp(fd, AdminP12.GetPKCS12()) <= 0)
		{
			fclose(fd);
			ERR_print_errors_fp(stderr);
			clean_up();
		}
		fclose(fd);
	}
}

void create_std_entity(const mString & name, EntityInfo & entity)
{
	EntityCreationReq req;
	EntityCreationResp resp;
	EntitySignatureReq sign_req;
	EntitySignatureResp sign_resp;
	EntityInitReq init_req;
	PkiClient RootConnection(NULL);
	AdminReqLogin login;
	int type;
	mVector<EntityEntryInfo> m_entities;
	size_t i;

	printf("Creating %s : %s...\n", entity.get_strType().c_str(), name.c_str());

	if(!RootConnection.Connect(entity.get_host(), entity.get_port(), PKI_CERT::EmptyInstance, NULL))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}
	login.set_username("root");
	login.set_password("root");

	if(!RootConnection.UserLogin(login, type))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}

	req.set_name(name);
	req.get_datas().set_type(entity.get_type());

	if(entity.get_type() != ENTITY_TYPE_PUBLICATION)
	{
		req.get_datas().get_entityKey().set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN);
		req.get_datas().get_entityKey().set_keylen(1024);
	}
	else
	{
		req.get_datas().get_pubCreate().get_entityKey().set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN);
		req.get_datas().get_pubCreate().get_entityKey().set_keylen(1024);

		req.get_datas().get_pubCreate().get_ocspKey().set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN);
		req.get_datas().get_pubCreate().get_ocspKey().set_keylen(1024);
	}

	if(!RootConnection.CreateEntity(req, resp))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}
	if(resp.get_type() != entity.get_type())
	{
		NEWPKIerr(CLIENT_ERROR_TXT, ERROR_BAD_DATAS);
		ERR_print_errors_fp(stderr);
		clean_up();
	}
	if(!sign_req.get_body().set_type(entity.get_type()))
	{
		ERR_print_errors_fp(stderr);
		clean_up();
	}
	sign_req.set_name(name);
	sign_req.set_email(email);
	
	if(entity.get_type() == ENTITY_TYPE_PUBLICATION)
	{
		if(!sign_req.get_body().get_signPub().set_entitypubkey(resp.get_pubCreate().get_entityKey()))
		{
			ERR_print_errors_fp(stderr);
			clean_up();
		}
		if(!sign_req.get_body().get_signPub().set_ocsppubkey(resp.get_pubCreate().get_ocspKey()))
		{
			ERR_print_errors_fp(stderr);
			clean_up();
		}
	}
	else if(entity.get_type() == ENTITY_TYPE_REPOSITORY)
	{
		if(!sign_req.get_body().get_signRep().set_entitypubkey(resp.get_entityPubKey()))
		{
			ERR_print_errors_fp(stderr);
			clean_up();
		}
		sign_req.get_body().get_signRep().set_address(entity.get_host());
		sign_req.get_body().get_signRep().set_port(entity.get_port());
	}
	else
	{
		if(!sign_req.get_body().set_entitypubkey(resp.get_entityPubKey()))
		{
			ERR_print_errors_fp(stderr);
			clean_up();
		}
	}

	if(!PkiConnection.SignEntity(sign_req, sign_resp))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}

	init_req.set_name(name);
	if(!init_req.set_signResp(sign_resp))
	{
		ERR_print_errors_fp(stderr);
		clean_up();
	}

	if(!RootConnection.InitEntity(init_req))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}

	// Set its certificate
	if(!PkiConnection.EnumEntities(m_entities))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}

	for(i = 0; i < m_entities.size(); i++)
	{
		if(m_entities[i].get_name() == name)
		{
			entity.get_cert() = m_entities[i].get_certificate();
			break;
		}
	}
	if(i == m_entities.size())
	{
		fprintf(stderr,"Could not find entity %s\n", name.c_str());
		clean_up();
	}

	// Set the mail conf
	set_mail_conf(entity);
}

void link_entity(const mString & name, const EntityInfo & entity)
{
	mVector<EntityLinks> links;
	EntityLinks * link;
	size_t i;
	if(!PkiConnection.ResourceLock(PKI_ENTITIES_LINKS_RESOURCE))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
	if(!PkiConnection.GetEntitiesLinks(links))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
	link = get_EntityLink(links, name);
	if(!link)
	{
		fprintf(stderr, "Couldn't find link for %s\n", name.c_str());
		clean_up();
	}
	for(i=0; i<entity.get_links().size(); i++)
	{
		if(!add_LinkToEntity(links, *link, entity.get_links()[i]))
		{
			fprintf(stderr, "Failed to add link from %s to %s\n", name.c_str(), entity.get_links()[i].c_str());
			clean_up();
		}
	}
	for(i=0; i<entity.get_rmlinks().size(); i++)
	{
		if(!del_LinkToEntity(links, *link, entity.get_rmlinks()[i]))
		{
			fprintf(stderr, "Failed to remove link from %s to %s\n", name.c_str(), entity.get_links()[i].c_str());
			clean_up();
		}
	}
	if(!PkiConnection.SetEntitiesLinks(links))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
	if(!PkiConnection.ResourceUnlock(PKI_ENTITIES_LINKS_RESOURCE))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
}

void configure_ra(CONF *conf, const mString & name, const EntityInfo & entity)
{
	PKI_CERT entity_cert;
	EntityConfBody entity_conf;

	printf("Configuring RA : %s...\n", name.c_str());

	// We set its conf
	get_entity_conf(name, entity_cert, entity_conf);
	entity_conf.get_raConf().RA_CONF_PTR.set_minkeylen(512);
	set_entity_conf(entity_cert, entity_conf);
}

void configure_ca(CONF *conf, const mString & name, const EntityInfo & entity)
{
	PKI_CERT entity_cert;
	EntityConfBody entity_conf;
	HashTable_String entity_exts;
	ReqCreateRootCa root_ca_info;
	STACK_OF(CONF_VALUE) *nval;
	CONF_VALUE *val;
	int i;
	mString extensions;
	entity_exts.AllowDuplicateNames();

	printf("Configuring CA : %s...\n", name.c_str());

	// Load the extensions
	extensions = entity.get_options("extensions");
	if(!extensions.size())
	{
		fprintf(stderr,"You must specify extensions for CA %s\n", name.c_str());
		clean_up();
	}
	if (!(nval = NCONF_get_section(conf, extensions.c_str())))
	{
		fprintf(stderr,"Couldn't find section %s for CA %s\n", extensions.c_str(), name.c_str());
		clean_up();
	}
	for (i = 0; i < sk_CONF_VALUE_num(nval); i++)
	{
		val = sk_CONF_VALUE_value(nval, i);
		entity_exts.Add(val->name, val->value);
	}

	// We set its conf
	get_entity_conf(name, entity_cert, entity_conf);
	entity_conf.get_caConf().CA_CONF_PTR.set_crlvalidityhours(1);
	entity_exts.To_EXTENSION_VALUE(entity_conf.get_caConf().CA_CONF_PTR.get_exts());
	set_entity_conf(entity_cert, entity_conf);
}

void get_entity_conf(const mString & name, PKI_CERT & cert, EntityConfBody & conf)
{
	mVector<EntityEntryInfo> m_entities;
	size_t i;

	if(!PkiConnection.EnumEntities(m_entities))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}

	for(i = 0; i < m_entities.size(); i++)
	{
		if(m_entities[i].get_name() == name)
		{
			cert = m_entities[i].get_certificate();
			break;
		}
	}
	if(i == m_entities.size())
	{
		fprintf(stderr,"Could not find entity %s\n", name.c_str());
		clean_up();
	}

	if(!PkiConnection.ResourceLock(cert.GetStringName()))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}

	if(!PkiConnection.GetEntityConf(cert, conf))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
}

void set_entity_conf(const PKI_CERT & cert, const EntityConfBody & conf)
{
	if(!PkiConnection.SetEntityConf(cert, conf))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
	if(!PkiConnection.ResourceUnlock(cert.GetStringName()))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
}

void init_ca(const mString & name, const EntityInfo & entity)
{
	PkiClient EntityConnection(NULL);
	PkiClient RootCaConnection(NULL);
	HashTable_Dn Dn;
	int type;
	AdminReqLogin login;
	ExtensionValue extval;
	ReqCreateRootCa root_ca_info;
	ReqCreateChildCa ca_create;
	PKI_CSR	csr;
	PKI_P7B p7b;
	mString root_ca_name;

	// We connect to the CA to be initialized
	if(!EntityConnection.Connect(entity.get_host(), entity.get_port(), AdminP12.GetEndUserCert(), NULL))
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}
	login.Clear();
	login.set_entity(name);
	if(!EntityConnection.UserLogin(login, type))
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}

	root_ca_name = entity.get_options("rootca");
	if(!root_ca_name.size())
	{
		printf("Creating ROOT CA %s...\n", name.c_str());

		extval.set_name("basicConstraints");
		extval.set_value("critical, CA:TRUE");
		root_ca_info.get_extensions().push_back(extval);
		extval.set_name("nsComment");
		extval.set_value("NewPKI Generated CA Certificate");
		root_ca_info.get_extensions().push_back(extval);
		extval.set_name("subjectKeyIdentifier");
		extval.set_value("hash");
		root_ca_info.get_extensions().push_back(extval);
		extval.set_name("authorityKeyIdentifier");
		extval.set_value("keyid,issuer:always");
		root_ca_info.get_extensions().push_back(extval);
		extval.set_name("nsCertType");
		extval.set_value("sslCA, emailCA, objCA");
		root_ca_info.get_extensions().push_back(extval);
		extval.set_name("keyUsage");
		extval.set_value("keyCertSign, cRLSign, digitalSignature, nonRepudiation, keyEncipherment");
		root_ca_info.get_extensions().push_back(extval);

		Dn.Add("organizationalUnitName", "Dev.");
		Dn.Add("commonName", "NewPKI ROOT CA");
		Dn.Add("emailAddress", email.c_str());
		Dn.Add("organizationName", "NewPKI");
		Dn.Add("countryName", "FR");
		Dn.Add("stateOrProvinceName", "75");
		Dn.Add("localityName", "Paris");
		Dn.To_X509_NAME(root_ca_info.get_dn());

		root_ca_info.set_validity(365);
		root_ca_info.get_privkey().set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN);
		root_ca_info.get_privkey().set_keylen(1024);

		if(!EntityConnection.CreateCaRoot(root_ca_info))
		{
			fprintf(stderr, EntityConnection.GetError());
			clean_up();
		}
		if(!EntityConnection.GenerateCRL())
		{
			fprintf(stderr, EntityConnection.GetError());
			clean_up();
		}
	}
	else
	{
		printf("Creating CHILD CA %s of %s...\n", name.c_str(), root_ca_name.c_str());
		if(!root_ca_name.size())
		{
			fprintf(stderr, "You must specify a rootcaname for CA %s\n", name.c_str());
			clean_up();
		}

		if(entities.find(root_ca_name) == entities.end())
		{
			fprintf(stderr, "Unknown ROOT CA %s for CA %s\n", root_ca_name.c_str(), name.c_str());
			clean_up();
		}

		// We need to connect to the ROOT CA
		if(!RootCaConnection.Connect(entities[root_ca_name].get_host(), entities[root_ca_name].get_port(), AdminP12.GetEndUserCert(), NULL))
		{
			fprintf(stderr, RootCaConnection.GetError());
			clean_up();
		}
		login.Clear();
		login.set_entity(root_ca_name);
		if(!RootCaConnection.UserLogin(login, type))
		{
			fprintf(stderr, RootCaConnection.GetError());
			clean_up();
		}


		Dn.Add("organizationalUnitName", "Dev.");
		Dn.Add("commonName", name.c_str());
		Dn.Add("emailAddress", email.c_str());
		Dn.Add("organizationName", "NewPKI");
		Dn.Add("countryName", "FR");
		Dn.Add("stateOrProvinceName", "75");
		Dn.Add("localityName", "Paris");
		Dn.To_X509_NAME(ca_create.get_dn());
		
		ca_create.get_privkey().set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN);
		ca_create.get_privkey().set_keylen(1024);

		if(!EntityConnection.CreateCaChild(ca_create, csr))
		{
			fprintf(stderr, EntityConnection.GetError());
			clean_up();
		}

		if(!RootCaConnection.SignCSR(csr, 365, "", p7b))
		{
			fprintf(stderr, RootCaConnection.GetError());
			clean_up();
		}
		RootCaConnection.CloseConnection();

		if(!EntityConnection.ImportChildCaCert(p7b))
		{
			fprintf(stderr, EntityConnection.GetError());
			clean_up();
		}
		if(!EntityConnection.GenerateCRL())
		{
			fprintf(stderr, EntityConnection.GetError());
			clean_up();
		}
	}
}

void test_logs(const mString & name, const EntityInfo & entity)
{
	PkiClient EntityConnection(NULL);
	int type;
	AdminReqLogin login;
	AdminReqEnumLogs enlogs;
	mVector<LogEntry> logs;

	fprintf(stderr,"Testing logs on entity %s...\n", name.c_str());

	if(!EntityConnection.Connect(entity.get_host(), entity.get_port(), AdminP12.GetEndUserCert(), NULL))
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}
	login.Clear();
	login.set_entity(name);
	if(!EntityConnection.UserLogin(login, type))
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}

	enlogs.set_index(0);
	enlogs.set_max(50);

	if(!EntityConnection.EnumLOG(enlogs, logs))
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}

	if(!EntityConnection.CheckLogsIntegrity())
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}
}

void request_certs(const NewpkiThread * myThread, void * param)
{
	PkiClient EntityConnection(NULL);
	AdminReqLogin login;
	int type;
	NewpkiProfile profile;
	unsigned long profileid;
	unsigned long ctr;
	HashTable_Dn Dn;
	mString cn;
	NewpkiRequestCert req;
	time_t tt;
	size_t i;
	mString link_name;
	unsigned long profiles;
	mString name = *((mString*)param);

	profiles = entities[name].get_options("profiles").c_ulng();

	if(!EntityConnection.Connect(entities[name].get_host(), entities[name].get_port(), AdminP12.GetEndUserCert(), NULL))
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}
	login.set_entity(name);
	if(!EntityConnection.UserLogin(login, type))
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}


	for(ctr = 0; ctr < profiles; ctr++)
	{
		cn.sprintf("%d-%ld-%ld", NewpkiThread::CurrentThreadId(), ctr, time(NULL));
		Dn.Clear();
		Dn.Add("organizationalUnitName", "Dev.");
		Dn.Add("commonName", cn.c_str());
		Dn.Add("emailAddress", email.c_str());
		Dn.Add("organizationName", "NewPKI");
		Dn.Add("countryName", "FR");
		Dn.Add("stateOrProvinceName", "75");
		Dn.Add("localityName", "Paris");
		Dn.To_X509_NAME(profile.get_dn());

		time(&tt);

		if(!EntityConnection.ImportProfile(profile, profileid))
		{
			fprintf(stderr, EntityConnection.GetError());
			clean_up();
		}
		fprintf(stderr, "%d - %ld [%ld] > %ld\n", NewpkiThread::CurrentThreadId(), ctr, time(NULL) - tt, profileid);

		req.set_profileId(profileid);
		req.set_type(NEWPKI_PROFILE_CERT_TYPE_PKCS12);
		req.get_request().set_type(REQUEST_CERT_BODY_PKCS12);
		req.get_request().get_p12Privdatas().set_keylen(512);
		req.get_request().get_p12Privdatas().set_passwd("azerty");
		req.set_validity(365);

		for(i=0; i<entities[name].get_links().size(); i++)
		{
			link_name = entities[name].get_links()[i];
			if(entities[link_name].get_type() != ENTITY_TYPE_CA)
				continue;
			req.set_caName(link_name);
			time(&tt);
			if(!EntityConnection.RequestCertificate(req, profileid))
			{
				fprintf(stderr, EntityConnection.GetError());
				clean_up();
			}
			fprintf(stderr, "%d - %ld [%ld] > Cert %s\n", NewpkiThread::CurrentThreadId(), ctr, time(NULL) - tt, link_name.c_str());
		}
	}
}

void test_server_users(const EntityInfo & entity)
{
	AdminReqLogin login;
	int type;
	UserInfo user;
	ChangeUserPasswd password;
	PkiClient TotoConnection(NULL);
	mVector<UserEntry> users;
	size_t i;
	ChangePasswd lPasswd;
	PkiClient RootConnection(NULL);

	fprintf(stderr,"Changing root's password to dklflmdskfd...\n");

	if(!RootConnection.Connect(entity.get_host(), entity.get_port(), PKI_CERT::EmptyInstance, NULL))
	{
		fprintf(stderr, RootConnection.GetError());
		return;
	}
	login.set_username("root");
	login.set_password("root");

	if(!RootConnection.UserLogin(login, type))
	{
		fprintf(stderr, RootConnection.GetError());
		return;
	}

	// Change root's password
	lPasswd.set_password("dklflmdskfd");
	if(!RootConnection.ChangePassword(lPasswd))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}
	RootConnection.CloseConnection();
	
	// Reconnect with new password
	fprintf(stderr,"Reconnecting with new root's password...\n");
	if(!RootConnection.Connect(entity.get_host(), entity.get_port(), PKI_CERT::EmptyInstance, NULL))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}
	login.set_username("root");
	login.set_password("dklflmdskfd");
	if(!RootConnection.UserLogin(login, type))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}


	// Rechange password to root
	fprintf(stderr,"Changing root's password back to root...\n");
	lPasswd.set_password("root");
	if(!RootConnection.ChangePassword(lPasswd))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}
	RootConnection.CloseConnection();
	
	// Reconnect with new passaord
	fprintf(stderr,"Reconnecting with new root's password...\n");
	if(!RootConnection.Connect(entity.get_host(), entity.get_port(), PKI_CERT::EmptyInstance, NULL))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}
	login.set_username("root");
	login.set_password("root");
	if(!RootConnection.UserLogin(login, type))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}


	
	fprintf(stderr,"Creating user toto...\n");
	// We now create a user
	user.set_activated(1);
	user.set_name("toto");
	if(!RootConnection.CreateUser(user))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}
	
	// Connect as toto
	fprintf(stderr,"Connecting as toto...\n");
	if(!TotoConnection.Connect(entity.get_host(), entity.get_port(), PKI_CERT::EmptyInstance, NULL))
	{
		fprintf(stderr, TotoConnection.GetError());
		clean_up();
	}
	login.set_username("toto");
	login.set_password("toto");
	if(!TotoConnection.UserLogin(login, type))
	{
		fprintf(stderr, TotoConnection.GetError());
		clean_up();
	}
	TotoConnection.CloseConnection();

	fprintf(stderr,"Enumerating users...\n");
	if(!RootConnection.EnumUsers(users))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}

	for(i=0; i<users.size(); i++)
	{
		if(users[i].get_userInfo().get_name() == "toto")
		{
			break;
		}
	}
	if(i == users.size())
	{
		fprintf(stderr,"Failed to find user toto\n");
		clean_up();
	}


	password.set_userId(users[i].get_userId());
	password.set_password("mldsqmldqsm");

	fprintf(stderr,"root is changing toto's password to mldsqmldqsm...\n");
	if(!RootConnection.ChangeUserPassword(password))
	{
		fprintf(stderr, RootConnection.GetError());
		clean_up();
	}

	// Connect as toto
	fprintf(stderr,"Connecting as toto with new password...\n");
	if(!TotoConnection.Connect(entity.get_host(), entity.get_port(), PKI_CERT::EmptyInstance, NULL))
	{
		fprintf(stderr, TotoConnection.GetError());
		clean_up();
	}
	login.set_username("toto");
	login.set_password("mldsqmldqsm");
	if(!TotoConnection.UserLogin(login, type))
	{
		fprintf(stderr, TotoConnection.GetError());
		clean_up();
	}
	TotoConnection.CloseConnection();
}


void test_pki_users(const mString & name, const EntityInfo & entity)
{
	CreatePkiUserRequest req;
	CreatePkiUserResponse resp;
	PKI_PKCS12 p12;
	AdminReqLogin login;
	int type;
	PkiClient EntityConnection(NULL);


	req.set_cn("toto");
	req.set_email(email);
	req.set_pkiadmin(1);
	req.get_ukey().set_type(PKI_USER_KEY_TYPE_SOFTKEY);
	req.get_ukey().get_softkey().set_keylen(512);
	req.get_ukey().get_softkey().set_password("azerty");

	fprintf(stderr,"Creating PKI admin toto...\n");
	if(!PkiConnection.CreatePkiUser(req, resp))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}

	if(!p12.Load(resp.get_p12().GetPemPKCS12(), "azerty"))
	{
		ERR_print_errors_fp(stderr);
		clean_up();
	}

	if(!EntityConnection.Connect(entity.get_host(), entity.get_port(), p12.GetEndUserCert(), NULL))
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}
	login.set_entity(name);
	if(!EntityConnection.UserLogin(login, type))
	{
		fprintf(stderr, EntityConnection.GetError());
		clean_up();
	}



	if(!PkiConnection.RevokeUserCert(p12.GetEndUserCert().GetSerial()))
	{
		fprintf(stderr, PkiConnection.GetError());
		clean_up();
	}
}
