/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// SockServerADMIN.h: interface for the SockServerADMIN class.
//
//////////////////////////////////////////////////////////////////////

#ifndef SOCKSERVERADMIN_H
#define SOCKSERVERADMIN_H

#include "PKIX_Central.h"
#include <PKI_CERT.h>
#include "SOCK_SERVER.h"

#ifndef MAX_ADMIN_CONNECTIONS
	#define MAX_ADMIN_CONNECTIONS	50
#endif


/*!
	This class handles newpki's protocol
*/
class SockServerADMIN : public SOCK_SERVER  
{
public:
	/*! \brief This is the constructor.
	 */
	SockServerADMIN();

	/*! \brief This is the destructor.
	 */
	virtual ~SockServerADMIN();

	/*! \brief This function loads the provider.
	 *  \param Central [IN] The accessor to the entities.
	 */
	bool Load(PKIX_Central *Central);

private:
	bool ReadRequest(BIO * ssl_bio, SOCKET hSocket, AdminRequest & req);
	static void info_callback(const SSL *s, int where, int ret);
	static int verify_callback(int ok, X509_STORE_CTX *ctx);
	void OnServerStarted();
	void OnConnection(const char * Ip, SOCKET connection);
	void OnServerStopped();
	PKIX_Central * m_Central;
	PKI_CERT m_SslCert;
	SSL_CTX * m_ctx;
};

#endif
