/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// SQL.h: interface for the SQL class.
//
//////////////////////////////////////////////////////////////////////

#ifndef SQL_CONN_H
#define SQL_CONN_H



#ifdef WIN32
	#include <windows.h>
#endif

#include <stdio.h>
#include <mString.h>
#include <mysql/mysql.h>
#include <ReadersWriter.h>


#include <PKI_ERR.h>
#include "SQL.h"

#include <mString.h>

/*!
  This class represents a connection to a SQL database
 */
class SQL_Connection  
{
friend class SQL;

public:
	/*! \brief This is the constructor.
	 *  \param Database [IN] The database.
	 *  \param DB_Server [IN] The sql server address.
	 *  \param DB_Port [IN] The sql server port.
	 *  \param DB_User [IN] The sql account.
	 *  \param DB_Password [IN] The password.
	 *  \exception ExceptionNewPKI An error occured.
	 */
	SQL_Connection(const mString & Database, const mString & DB_Server, unsigned int DB_Port, const mString & DB_User, const mString & DB_Password);

	/*! \brief This is the destructor.
	 */
	virtual ~SQL_Connection();

	/*! \brief This function selects a database.
	 *  \param DataBaseName [IN] The name of the database to use.
	 *  \return true on success, false on failure.
	 */
	bool SelectDatabase(const mString & DataBaseName) const;

	/*! \brief This function clones the connection.
	 *  \return The cloned connection.
	 */
	SQL_Connection * Clone() const;

	/*! \brief This function resume a lost connection to the DB.
	 *  \return true on success, false on failure.
	 */
	bool Reconnect() const;
protected:	
	mString m_Database;
	mString m_DB_Server;
	unsigned int m_DB_Port;
	mString m_DB_User;
	mString m_DB_Password;
	MYSQL * sqlHND;
	ReadersWriter Locker;
	CriticalSection ExecuteLock;
};

#endif

