/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef SSPICONNECTION_H
#define SSPICONNECTION_H

#if defined(_WIN32) && !defined(NO_BIO_MS_SSL)

#include "Connection.h"
#include "bio_ms_ssl.h"


/*!
	This class represents a SSPI (Windows) client connection
*/
class SspiConnection : public Connection
{
public:
	/*! \brief This is the constructor.
	 */
	SspiConnection();

	/*! \brief This is the constructor.
	 */
	~SspiConnection();

	bool connect();
	
	void close();
	
	/*! \brief This function sets the certificate to use for connection.
	 *  \param cert [IN] The certificate.
	 *  \return true on success, false on failure.
	 */
	bool set_certificate(PCCERT_CONTEXT cert);
	
	bool SendRequest(const AdminRequest &request, AdminResponse &response, int ReadTimeout = 0);
	
	/*! \brief This function returns the server certificate.
	 *  \param PeerCert [OUT] The certificate.
	 *  \return true on success, false on failure.
	 */
	bool GetPeerCertificate(PKI_CERT & PeerCert);
private:
	BIO * m_connection;
	PCCERT_CONTEXT m_certificate;
};
#endif

#endif
