/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// NewPKIObject.h: interface for the NewPKIObject class.
//
//////////////////////////////////////////////////////////////////////

#ifndef NEWPKIOBJECT_H
#define NEWPKIOBJECT_H

#include <openssl/asn1.h>
#include <openssl/stack.h>
#include <mString.h>

/*!
	This class represents a ASN1 object
*/
class NewPKIObject  
{
public:
	/*! \brief This is the constructor.
	 *  \exception ExceptionNewPKI An error occured.
	 */
	NewPKIObject();

	/*! \brief This is the destructor.
	 */
	virtual ~NewPKIObject();

	/*! \brief This function duplicates a STACK.
	 *  \param item [IN] The ASN1_ITEM representing the object type in the STACK.
	 *  \param in [IN] The STACK to duplicate.
	 *  \return The duplicated STACK.
	 */
	static STACK * STACK_dup(const ASN1_ITEM * item, const STACK * in);

	/*! \brief This function empties a STACK.
	 *  \param item [IN] The ASN1_ITEM representing the object type in the STACK.
	 *  \param in [IN] The STACK to empty.
	 */
	static void STACK_empty(const ASN1_ITEM * item, STACK * in);
	
	/*! \brief This function frees a STACK.
	 *  \param item [IN] The ASN1_ITEM representing the object type in the STACK.
	 *  \param in [IN] The STACK to free.
	 */
	static void STACK_free(const ASN1_ITEM * item, STACK * in);
	
	/*! \brief This function copies a STACK to another.
	 *  \param item [IN] The ASN1_ITEM representing the object type in the STACK.
	 *  \param in [IN] The STACK to copy from.
	 *  \param out [IN] The STACK to copy to.
	 *  \return true on success, false on failure.
	 */
	static bool STACK_cpy(const ASN1_ITEM * item, const STACK * in, STACK * out);
	
	/*! \brief This function returns the state of the Object.
	 *  \return true when everything is fine else false.
	 */
	bool isOK() const;
	
	/*! \brief This function forces the state of the Object to OK.
	 */
	void set_isOK();
	
	/*! \brief This function clears all the internals.
	 */
	virtual void Clear()=0;
	
	/*! \brief This operator is used to know if the class is set.
	 *  \return return 1 when object is operable and 0 when not.
	 */
	operator int() const;
protected:
	bool Private_toPEM(const mString & name, const ASN1_ITEM *it, ASN1_VALUE * datas, mString &pem_datas) const;
	bool Private_fromPEM(const mString & name, const ASN1_ITEM *it, ASN1_VALUE ** datas, const mString &pem_datas);
	bool m_isOk;
};

#endif
