/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgModifyRepInfo.cpp: implementation of the DlgModifyRepInfo class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgModifyRepInfo.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgModifyRepInfo, wxDialog)
    EVT_BUTTON(IDC_OK, DlgModifyRepInfo::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgModifyRepInfo::OnCancel)
END_EVENT_TABLE()

DlgModifyRepInfo::DlgModifyRepInfo(wxWindow * wParent, const mString & Address, unsigned int Port):wxDialog(wParent, (wxWindowID)-1, _("Modify repository info"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_IsOK = false;
	DlgModifyRepInfo_SetWindow(this);

	m_Port.sprintf("%d", Port);
	((wxTextCtrl *)FindWindow(IDC_ADDRESS))->SetValue(Address.c_str());
	((wxTextCtrl *)FindWindow(IDC_PORT))->SetValue(m_Port);

	CenterOnScreen();
	ShowModal();
}

DlgModifyRepInfo::~DlgModifyRepInfo()
{
}

void DlgModifyRepInfo::OnOk(wxCommandEvent& event)
{
	m_Address = ((wxTextCtrl *)FindWindow(IDC_ADDRESS))->GetValue().GetData();
	if(!m_Address.size())
		return;
	
	m_Port = ((wxTextCtrl *)FindWindow(IDC_PORT))->GetValue();
	if(!m_Port.Len())
		return;

	m_IsOK=true;
	Close(TRUE);
}

void DlgModifyRepInfo::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}

bool DlgModifyRepInfo::IsOK()
{
	return m_IsOK;
}

const mString & DlgModifyRepInfo::GetAddress()
{
	if(!m_IsOK)
		return mString::EmptyInstance;

	return m_Address;
}

unsigned int DlgModifyRepInfo::GetPort()
{
	unsigned int port;
	if(!m_IsOK)
		return 0;
	
	sscanf((char*)m_Port.GetData(), "%d", &port);
	
	return port;
}
