/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgManageACL.cpp: implementation of the DlgManageACL class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"
#include "DlgManageACL.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgManageACLListCtrl, wxListCtrl)
    EVT_LIST_ITEM_SELECTED(IDC_LIST_PKI_USERS, DlgManageACLListCtrl::OnItemClick)
END_EVENT_TABLE()



DlgManageACL * wDlgManageACLParent;

void DlgManageACLListCtrl::OnItemClick(wxListEvent& event)
{
	wDlgManageACLParent->OnItemClick(event);
}


BEGIN_EVENT_TABLE(DlgManageACL, wxDialog)
    EVT_BUTTON(IDC_OK, DlgManageACL::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgManageACL::OnCancel)
    EVT_BUTTON(IDC_ADD, DlgManageACL::OnAdd)
    EVT_BUTTON(IDC_DEL, DlgManageACL::OnDel)
END_EVENT_TABLE()


DlgManageACL::DlgManageACL(wxWindow * wParent, X509Acl & acl):wxDialog(wParent, (wxWindowID)-1, _("Manage ACL"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION), m_acls(acl)
{
	m_IsOK = false;

	wDlgManageACLParent = this;

	DlgManageACL_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(IDC_LIST_PKI_USERS));

	m_imageListSmall = new wxImageList(16, 16, TRUE);
	wxIcon ico;
	ico.CopyFromBitmap(Users_GetBitmap(IDB_USER_SMALL));
	m_imageListSmall->Add( ico );
	ico.CopyFromBitmap(Users_GetBitmap(IDB_GROUP_SMALL));
	m_imageListSmall->Add( ico );


	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("User DN"), wxLIST_ALIGN_DEFAULT, 500);


	w_acls = m_acls;
	

	size_t i;

	m_listCtrl->DeleteAllItems();
	if(!w_acls.get_aclEntries().size())
	{
		m_listCtrl->Enable(FALSE);
		((wxListBox *)FindWindow(IDC_AVAILABE))->Enable(FALSE);
		((wxListBox *)FindWindow(IDC_RIGHTS))->Enable(FALSE);
		((wxButton *)FindWindow(IDC_ADD))->Enable(FALSE);
		((wxButton *)FindWindow(IDC_DEL))->Enable(FALSE);
	}
	else
	{
		for(i=0; i<w_acls.get_aclEntries().size(); i++)
		{
			m_listCtrl->InsertItem(i, w_acls.get_aclEntries()[i].get_name().c_str(), w_acls.get_aclEntries()[i].get_type()==ACL_ENTRY_TYPE_USER?0:1);
			m_listCtrl->SetItemData(i, (long)i);
		}
		m_listCtrl->SetItemState(0, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
	}

	wxListEvent event;
	OnItemClick(event);
		
	CenterOnScreen();
	ShowModal();		
}

DlgManageACL::~DlgManageACL()
{
	m_listCtrl->ClearAll();
	if(m_imageListSmall) delete m_imageListSmall;
}

void DlgManageACL::OnOk(wxCommandEvent& event)
{
	if(DisplayMessage(this, _("Are you sure, you want to modify the ACLs ?"), wxYES_NO) == wxNO) return;

	m_acls = w_acls;
	m_IsOK = true;
	Close(TRUE);
}

void DlgManageACL::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}


void DlgManageACL::OnAdd(wxCommandEvent &event)
{
	int SelectedItem;
	size_t index;
	long entry;

	
	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	index = (size_t)m_listCtrl->GetItemData(SelectedItem);
	

	SelectedItem = ((wxListBox *)FindWindow(IDC_AVAILABE))->GetSelection();
	if(SelectedItem == -1)
		return;
	entry = (long)((wxListBox *)FindWindow(IDC_AVAILABE))->GetClientData(SelectedItem);


	((wxListBox *)FindWindow(IDC_RIGHTS))->Insert(GetACL_String((ACL_TYPE)entry), 0, (void*)entry);
	((wxListBox *)FindWindow(IDC_AVAILABE))->Delete(SelectedItem);

	if(((wxListBox *)FindWindow(IDC_RIGHTS))->GetCount())
	{
		ASN1_BIT_STRING_set_bit(w_acls.get_aclEntries()[index].get_acls(), ACL_TYPE_AUTHENTICATE_ON_ENTITY, 1);
	}

	ASN1_BIT_STRING_set_bit(w_acls.get_aclEntries()[index].get_acls(), entry, 1);
}

void DlgManageACL::OnDel(wxCommandEvent &event)
{
	int SelectedItem;
	long entry;
	size_t index;
	
	
	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	index = (size_t)m_listCtrl->GetItemData(SelectedItem);
	

	SelectedItem = ((wxListBox *)FindWindow(IDC_RIGHTS))->GetSelection();
	if(SelectedItem == -1)
		return;
	entry = (long)((wxListBox *)FindWindow(IDC_RIGHTS))->GetClientData(SelectedItem);


	((wxListBox *)FindWindow(IDC_AVAILABE))->Insert(GetACL_String((ACL_TYPE)entry), 0, (void*)entry);
	((wxListBox *)FindWindow(IDC_RIGHTS))->Delete(SelectedItem);
	if(!((wxListBox *)FindWindow(IDC_RIGHTS))->GetCount())
	{
		ASN1_BIT_STRING_set_bit(w_acls.get_aclEntries()[index].get_acls(), ACL_TYPE_AUTHENTICATE_ON_ENTITY, 0);
	}


	ASN1_BIT_STRING_set_bit(w_acls.get_aclEntries()[index].get_acls(), entry, 0);
}

void DlgManageACL::OnItemClick(wxListEvent &event)
{
	int SelectedItem;
	size_t i, index;

	
	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	index = (size_t)m_listCtrl->GetItemData(SelectedItem);


	((wxListBox *)FindWindow(IDC_RIGHTS))->Clear();
	((wxListBox *)FindWindow(IDC_AVAILABE))->Clear();
	
	for(i=0; i<w_acls.get_aclType().size(); i++)
	{
		if(ASN1_BIT_STRING_get_bit(w_acls.get_aclEntries()[index].get_acls(), w_acls.get_aclType()[i]))
		{
			((wxListBox *)FindWindow(IDC_RIGHTS))->Insert(GetACL_String((ACL_TYPE)w_acls.get_aclType()[i]), 0, (void*)w_acls.get_aclType()[i]);
		}
		else
		{
			((wxListBox *)FindWindow(IDC_AVAILABE))->Insert(GetACL_String((ACL_TYPE)w_acls.get_aclType()[i]), 0, (void*)w_acls.get_aclType()[i]);
		}
	}
}


bool DlgManageACL::IsOK()
{
	return m_IsOK;
}
