/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddPkiUser.cpp: implementation of the DlgAddPkiUser class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"
#include "DlgCsrProperties.h"
#include "DlgAddPkiUser.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddPkiUser, wxDialog)
    EVT_BUTTON(IDC_SHOW, DlgAddPkiUser::OnShow)
    EVT_BUTTON(IDC_OK, DlgAddPkiUser::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddPkiUser::OnCancel)
    EVT_BUTTON(IDC_FILE_IMPORT, DlgAddPkiUser::OnImport)
    EVT_RADIOBUTTON(IDC_KEY_SOFTWARE, DlgAddPkiUser::OnSoftwareKey)
    EVT_RADIOBUTTON(IDC_KEY_HARDWARE, DlgAddPkiUser::OnHardwareKey)
    EVT_RADIOBUTTON(IDC_IMPORT_CSR, DlgAddPkiUser::OnImportCSR)
END_EVENT_TABLE()


DlgAddPkiUser::DlgAddPkiUser(wxWindow * wParent, PkiClient * ClientPki):
		wxDialog(wParent, (wxWindowID)-1, _("Create PKI user"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_ClientPki = ClientPki;
	m_IsOk=false;

	DlgAddPkiUser_SetWindow(this);
	CenterOnScreen();

	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Append("8192 bits", (void*)8192);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Append("4096 bits", (void*)4096);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Append("2048 bits", (void*)2048);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Append("1024 bits", (void*)1024);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Append("512 bits", (void*)512);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->SetSelection(3);

	UserCreation.set_Parent(this);

	bckCsrColour = ((wxTextCtrl *)FindWindow(IDC_CSR))->GetBackgroundColour();


	PkiUserCreation::LoadProviders((wxComboBox *)FindWindow(IDC_KEY_CONTAINER));
#ifndef _WIN32
		((wxRadioButton *)FindWindow(IDC_KEY_HARDWARE))->Enable(FALSE);
#endif

		
	wxCommandEvent event;
	OnSoftwareKey(event);

	ShowModal();
}

DlgAddPkiUser::~DlgAddPkiUser()
{
}

void DlgAddPkiUser::OnCancel(wxCommandEvent& event)
{
	m_IsOk=true;
	Close(TRUE);
}



void DlgAddPkiUser::OnOk(wxCommandEvent& event)
{	
	DlgMessage Msg(this);
	CreatePkiUserRequest request;
	CreatePkiUserResponse response;
	int RsaLen;
	int nItem;
	wxString cn;
	wxString email;
	wxString m_P12Pwd1;
	wxString m_P12Pwd2;



	nItem = ((wxComboBox *)FindWindow(IDC_LIST_LEN))->GetSelection();
	RsaLen = (long)((wxComboBox *)FindWindow(IDC_LIST_LEN))->GetClientData(nItem);

	cn = ((wxTextCtrl *)FindWindow(IDC_NAME))->GetValue();
	email = ((wxTextCtrl *)FindWindow(IDC_MAIL))->GetValue();

	if(!cn.Len() || !email.Len())
		return;
	UserCreation.set_Info(cn.GetData(), email.GetData(), (((wxCheckBox *)FindWindow(IDC_ADMIN_PKI))->GetValue()?1:0));


	if(((wxRadioButton *)FindWindow(IDC_KEY_HARDWARE))->GetValue())
	{
#ifdef _WIN32
		wxString ProviderName;
		ProviderName = ((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->GetValue();
		if(!ProviderName.Len())
		{
			return;
		}
		UserCreation.set_HardwareKey(RsaLen, ProviderName.GetData());
#else
		return;
#endif
	}
	else if(((wxRadioButton *)FindWindow(IDC_KEY_SOFTWARE))->GetValue())
	{
		m_P12Pwd1 = ((wxTextCtrl *)FindWindow(IDC_PWD1))->GetValue();
		if(!m_P12Pwd1.Len())
		{
			return;
		}
		m_P12Pwd2 = ((wxTextCtrl *)FindWindow(IDC_PWD2))->GetValue();
		if(!m_P12Pwd2.Len())
		{
			return;
		}
		if(m_P12Pwd1 != m_P12Pwd2)
		{
			HandleError(_("The two passwords don't match."), this);
			return;
		}
		UserCreation.set_SoftwareKey(RsaLen, m_P12Pwd1.GetData());
	}
	else
	{
		UserCreation.set_PublicKey(Csr.GetX509_PUBKEY());
	}

	if(!UserCreation.generate_Request(request))
	{
		return;
	}


	if(DisplayMessage(this, _("Are you sure, you want to sign this request ?"), wxYES_NO) == wxNO)
	{
		UserCreation.Cancel();
		return;
	}

	Msg.wShow(_("Creating User..."));
	if(!m_ClientPki->CreatePkiUser(request, response))
	{
		UserCreation.Cancel();
		Msg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	Msg.wHide();

	if(!UserCreation.import_Response(response))
		UserCreation.Cancel();

	m_IsOk=true;
	Close(TRUE);
}

void DlgAddPkiUser::OnShow(wxCommandEvent& event)
{
	if(!((wxTextCtrl *)FindWindow(IDC_CSR))->GetValue().Len())
		return;

	DlgCsrProperties Dlg(this, Csr);
}

bool DlgAddPkiUser::IsOk()
{
	return m_IsOk;
}

void DlgAddPkiUser::OnImport(wxCommandEvent &event)
{
	wxFileDialog dialog(this, _("Open CSR"), "", "", _("CSR File (*.csr)|*.csr"), wxOPEN);
	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}

	((wxTextCtrl *)FindWindow(IDC_CSR))->SetValue("");
	((wxButton *)FindWindow(IDC_SHOW))->Enable(FALSE);
	if(!((wxTextCtrl *)FindWindow(IDC_CSR))->LoadFile(dialog.GetPath()))
		return;

	if(!Csr.SetCSR(((wxTextCtrl *)FindWindow(IDC_CSR))->GetValue().GetData()))
	{
		((wxTextCtrl *)FindWindow(IDC_CSR))->SetValue("");
		HandleErrorResult(NULL, this, 0);
		return;
	}
	((wxButton *)FindWindow(IDC_SHOW))->Enable(TRUE);

	const char * value;
	long pos;

	pos = Csr.GetRequestDN().SeekEntryName("commonName", HASHTABLE_NOT_FOUND);
	if(pos != HASHTABLE_NOT_FOUND)
	{
		value = Csr.GetRequestDN().Get(pos);
		if(value)
			((wxTextCtrl *)FindWindow(IDC_NAME))->SetValue(value);
	}

	pos = Csr.GetRequestDN().SeekEntryName("emailAddress", HASHTABLE_NOT_FOUND);
	if(pos != HASHTABLE_NOT_FOUND)
	{
		value = Csr.GetRequestDN().Get(pos);
		if(value)
			((wxTextCtrl *)FindWindow(IDC_MAIL))->SetValue(value);
	}
}


void DlgAddPkiUser::OnSoftwareKey(wxCommandEvent &event)
{
	((wxStaticText *)FindWindow(IDC_LBL_KEY_LEN))->Enable(TRUE);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Enable(TRUE);

	((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->Enable(FALSE);

	((wxTextCtrl *)FindWindow(IDC_PWD1))->Enable(TRUE);
	((wxTextCtrl *)FindWindow(IDC_PWD2))->Enable(TRUE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD1))->Enable(TRUE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD2))->Enable(TRUE);


	((wxTextCtrl *)FindWindow(IDC_CSR))->Enable(FALSE);
	((wxButton *)FindWindow(IDC_FILE_IMPORT))->Enable(FALSE);
	((wxButton *)FindWindow(IDC_SHOW))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_CSR))->SetBackgroundColour(GetBackgroundColour());
}

void DlgAddPkiUser::OnHardwareKey(wxCommandEvent &event)
{
	((wxStaticText *)FindWindow(IDC_LBL_KEY_LEN))->Enable(TRUE);
	((wxTextCtrl *)FindWindow(IDC_NAME))->Enable(TRUE);

	((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->Enable(TRUE);

	((wxTextCtrl *)FindWindow(IDC_PWD1))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_PWD2))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD1))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD2))->Enable(FALSE);

	((wxTextCtrl *)FindWindow(IDC_CSR))->Enable(FALSE);
	((wxButton *)FindWindow(IDC_FILE_IMPORT))->Enable(FALSE);
	((wxButton *)FindWindow(IDC_SHOW))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_CSR))->SetBackgroundColour(GetBackgroundColour());
}


void DlgAddPkiUser::OnImportCSR(wxCommandEvent &event)
{
	((wxStaticText *)FindWindow(IDC_LBL_KEY_LEN))->Enable(FALSE);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Enable(FALSE);

	((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->Enable(FALSE);

	((wxTextCtrl *)FindWindow(IDC_PWD1))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_PWD2))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD1))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD2))->Enable(FALSE);

	((wxTextCtrl *)FindWindow(IDC_CSR))->Enable(TRUE);
	((wxButton *)FindWindow(IDC_FILE_IMPORT))->Enable(TRUE);
	
	if(((wxTextCtrl *)FindWindow(IDC_CSR))->GetValue().Len())
		((wxButton *)FindWindow(IDC_SHOW))->Enable(TRUE);

	((wxTextCtrl *)FindWindow(IDC_CSR))->SetBackgroundColour(bckCsrColour);
}

