# Copyright (c) 2004 Divmod.
# See LICENSE for details.

__version__ = "0.3"
import sys

# This file doesn't have enough evil hacks yet, so here's one more:
## Detect whether we're using new twisted components
def _detectNewComponentsSystem():
    try:
        from twisted.python import components
        return components.AdapterRegistry.__module__ == 'zope.interface.adapter'
    except ImportError:
        return False

if _detectNewComponentsSystem():
    from nevow import compyCompat
    sys.modules['nevow.compy'] = compyCompat
    compy = compyCompat
#end evil hack.

from nevow import compy
from nevow import flat


# Python2.2 has a stupidity where instance methods have name
# '__builtin__.instance method' instead of '__builtin__.instancemethod'
# Workaround this error.
def clean(o):
    if o == '__builtin__.instancemethod' and sys.version_info < (2,3):
        return '__builtin__.instance method'
    return o


def load(S):
    for line in S.split('\n'):
        line = line.strip()
        if line and not line.startswith('#'):
            (a, o, i) = line.split()
            compy.registerAdapter(a, clean(o), i)


def loadFlatteners(S):
    for line in S.split('\n'):
        line = line.strip()
        if line and not line.startswith('#'):
            f, o = line.split()
            flat.registerFlattener(f, clean(o))


namespace = "http://nevow.com/ns/nevow/0.1"
'''The xml namespace of the nevow elements and attributes.'''


basic_adapters = """
formless.annotate.Group                   formless.annotate.MetaTypedInterface        formless.iformless.ITyped

nevow.accessors.DictionaryContainer    __builtin__.dict                         nevow.inevow.IContainer
nevow.accessors.ListContainer          __builtin__.list                         nevow.inevow.IContainer
nevow.accessors.ListContainer          __builtin__.tuple                        nevow.inevow.IContainer

nevow.accessors.FunctionAccessor       __builtin__.function                     nevow.inevow.IGettable
nevow.accessors.FunctionAccessor       __builtin__.method                       nevow.inevow.IGettable
nevow.accessors.FunctionAccessor       __builtin__.instancemethod               nevow.inevow.IGettable
nevow.accessors.DirectiveAccessor      nevow.stan.directive                     nevow.inevow.IGettable
    #

formless.webform.PropertyBindingRenderer  formless.annotate.Property         formless.iformless.IBindingRenderer
formless.webform.MethodBindingRenderer    formless.annotate.MethodBinding    formless.iformless.IBindingRenderer
formless.webform.GroupBindingRenderer     formless.annotate.GroupBinding     formless.iformless.IBindingRenderer

    #

formless.webform.StringRenderer         formless.annotate.String         formless.iformless.ITypedRenderer
formless.webform.StringRenderer         formless.annotate.Integer        formless.iformless.ITypedRenderer
formless.webform.StringRenderer         formless.annotate.Directory      formless.iformless.ITypedRenderer
formless.webform.PasswordRenderer       formless.annotate.Password       formless.iformless.ITypedRenderer
formless.webform.PasswordEntryRenderer  formless.annotate.PasswordEntry  formless.iformless.ITypedRenderer
formless.webform.TextRenderer           formless.annotate.Text           formless.iformless.ITypedRenderer
formless.webform.BooleanRenderer        formless.annotate.Boolean        formless.iformless.ITypedRenderer
formless.webform.ChoiceRenderer         formless.annotate.Choice         formless.iformless.ITypedRenderer
formless.webform.ObjectRenderer         formless.annotate.Object         formless.iformless.ITypedRenderer
formless.webform.NullRenderer           formless.annotate.Request        formless.iformless.ITypedRenderer
formless.webform.NullRenderer           formless.annotate.Context        formless.iformless.ITypedRenderer
formless.webform.FileUploadRenderer     formless.annotate.FileUpload     formless.iformless.ITypedRenderer
formless.webform.ButtonRenderer         formless.annotate.Button         formless.iformless.ITypedRenderer

    #

formless.processors.ProcessGroupBinding    formless.annotate.GroupBinding     formless.iformless.IInputProcessor
formless.processors.ProcessMethodBinding   formless.annotate.MethodBinding    formless.iformless.IInputProcessor
formless.processors.ProcessPropertyBinding    formless.annotate.Property         formless.iformless.IInputProcessor
formless.processors.ProcessTyped           formless.iformless.ITyped           formless.iformless.IInputProcessor
formless.processors.ProcessPassword        formless.annotate.Password         formless.iformless.IInputProcessor
formless.processors.ProcessRequest         formless.annotate.Request          formless.iformless.IInputProcessor
formless.processors.ProcessContext         formless.annotate.Context          formless.iformless.IInputProcessor
formless.processors.ProcessUpload          formless.annotate.FileUpload       formless.iformless.IInputProcessor

    #

formless.webform.FormDefaults     nevow.appserver.NevowRequest                formless.iformless.IFormDefaults
formless.webform.FormDefaults     nevow.testutil.FakeRequest                  formless.iformless.IFormDefaults
formless.webform.FormDefaults     nevow.testutil.FakeSession                  formless.iformless.IFormDefaults
formless.webform.FormDefaults     twisted.web.server.Session                  formless.iformless.IFormDefaults
formless.webform.FormDefaults     twisted.web.woven.guard.GuardSession        formless.iformless.IFormDefaults
formless.webform.FormDefaults     nevow.guard.GuardSession                    formless.iformless.IFormDefaults

formless.webform.FormErrors       twisted.web.server.Session               formless.iformless.IFormErrors
formless.webform.FormErrors       twisted.web.woven.guard.GuardSession     formless.iformless.IFormErrors
formless.webform.FormErrors       nevow.guard.GuardSession                 formless.iformless.IFormErrors
formless.webform.FormErrors       nevow.testutil.FakeSession               formless.iformless.IFormErrors

nevow.appserver.OldResourceAdapter                  twisted.web.resource.IResource      nevow.inevow.IResource

nevow.appserver.sessionFactory  nevow.context.RequestContext    nevow.inevow.ISession
nevow.rend.handFactory   nevow.context.RequestContext    nevow.inevow.IHand
nevow.rend.statusFactory   nevow.context.RequestContext    nevow.inevow.IStatusMessage
nevow.rend.defaultsFactory   nevow.context.RequestContext    formless.iformless.IFormDefaults
nevow.rend.errorsFactory   nevow.context.RequestContext    formless.iformless.IFormErrors
nevow.rend.originalFactory  nevow.context.RequestContext   nevow.inevow.IRequest
nevow.appserver.defaultExceptionHandlerFactory   nevow.context.RequestContext    nevow.inevow.ICanHandleException

nevow.rend.originalFactory  nevow.context.PageContext   nevow.inevow.IRenderer
nevow.rend.originalFactory  nevow.context.PageContext   nevow.inevow.IRendererFactory

nevow.rend.originalFactory  nevow.context.PageContext   formless.iformless.IConfigurableFactory

nevow.url.URLRedirectAdapter nevow.url.URL nevow.inevow.IResource

## The tests rely on these. Remove them ASAP.
nevow.util.remainingSegmentsFactory  nevow.context.RequestContext   nevow.inevow.IRemainingSegments
nevow.util.currentSegmentsFactory  nevow.context.RequestContext   nevow.inevow.ICurrentSegments

nevow.query.QueryContext    nevow.context.WovenContext  nevow.inevow.IQ
nevow.query.QueryLoader     nevow.inevow.IDocFactory      nevow.inevow.IQ
nevow.query.QueryList       __builtin__.list        nevow.inevow.IQ
nevow.query.QueryXml        nevow.stan.xml      nevow.inevow.IQ
"""

load(basic_adapters)


flatteners = """
nevow.flat.flatmdom.MicroDomDocumentSerializer          twisted.web.microdom.Document
nevow.flat.flatmdom.MicroDomTextSerializer              twisted.web.microdom.Text
nevow.flat.flatmdom.MicroDomCommentSerializer           twisted.web.microdom.Comment
nevow.flat.flatmdom.MicroDomElementSerializer           twisted.web.microdom.Element
nevow.flat.flatmdom.MicroDomEntityReferenceSerializer   twisted.web.microdom.EntityReference
nevow.flat.flatmdom.MicroDomCDATASerializer   twisted.web.microdom.CDATASection

nevow.flat.flatstan.ProtoSerializer               nevow.stan.Proto
nevow.flat.flatstan.TagSerializer                 nevow.stan.Tag
nevow.flat.flatstan.EntitySerializer                 nevow.stan.Entity
nevow.flat.flatstan.CommentSerializer             nevow.stan.Comment
nevow.flat.flatstan.XmlSerializer                 nevow.stan.xml
nevow.flat.flatstan.StringSerializer              __builtin__.str
nevow.flat.flatstan.UTF8Serializer                __builtin__.unicode
nevow.flat.flatstan.NoneWarningSerializer         __builtin__.NoneType
nevow.flat.flatstan.StringCastSerializer          __builtin__.int
nevow.flat.flatstan.StringCastSerializer          __builtin__.float
nevow.flat.flatstan.StringCastSerializer          __builtin__.long
nevow.flat.flatstan.StringCastSerializer          __builtin__.bool
nevow.flat.flatstan.ListSerializer                __builtin__.list
nevow.flat.flatstan.StringCastSerializer          __builtin__.dict
nevow.flat.flatstan.ListSerializer                __builtin__.tuple
nevow.flat.flatstan.ListSerializer                __builtin__.generator
nevow.flat.flatstan.FunctionSerializer            __builtin__.function
nevow.flat.flatstan.FunctionSerializer            __builtin__.type
nevow.flat.flatstan.MethodSerializer              __builtin__.instancemethod
nevow.flat.flatstan.CallableInstanceSerializer    nevow.inevow.IRenderer
nevow.flat.flatstan.CallableInstanceSerializer    nevow.inevow.IRendererFactory
nevow.flat.flatstan.DirectiveSerializer           nevow.stan.directive
nevow.flat.flatstan.SlotSerializer                nevow.stan.slot
nevow.flat.flatstan.ContextSerializer             nevow.context.WovenContext
nevow.flat.flatstan.DeferredSerializer            twisted.internet.defer.Deferred
nevow.flat.flatstan.DeferredSerializer            twisted.internet.defer.DeferredList

nevow.url.URLOverlaySerializer            nevow.url.URLOverlay
nevow.url.URLSerializer            nevow.url.URL
nevow.url.URLSerializer            nevow.url.URLPath

    # Itertools uses special types

nevow.flat.flatstan.ListSerializer  itertools.chain
nevow.flat.flatstan.ListSerializer  itertools.count
nevow.flat.flatstan.ListSerializer  itertools.cycle
nevow.flat.flatstan.ListSerializer  itertools.dropwhile
nevow.flat.flatstan.ListSerializer  itertools.ifilter
nevow.flat.flatstan.ListSerializer  itertools.ifilterfalse
nevow.flat.flatstan.ListSerializer  itertools.imap
nevow.flat.flatstan.ListSerializer  itertools.islice
nevow.flat.flatstan.ListSerializer  itertools.izip
nevow.flat.flatstan.ListSerializer  itertools.repeat
nevow.flat.flatstan.ListSerializer  itertools.starmap
nevow.flat.flatstan.ListSerializer  itertools.takewhile

nevow.flat.flatstan.DocFactorySerializer nevow.inevow.IDocFactory

"""

loadFlatteners(flatteners)


__all__ = [
    'accessors', 'appserver', 'blocks', 'canvas', 'compy', 'context', 'dirlist', 'entities', 'events', 'failure', 'guard', 'inevow', 'liveevil',
    'loaders', 'rend', 'stan', 'static', 'tags', 'test', 'testutil', 'url', 'util', 'vhost'
]
