#include <stdio.h>
#include <unistd.h>

#include "libnomad/libnomad.h"

njb_t njbs[ NJB_MAX_DEVICES ];

void getowner( NomadJukebox *jukebox )
{
	const gchar *owner;

	owner = nomad_jukebox_get_ownerstring( jukebox );
	printf( "Owner: %s\n", owner );
}

int main()
{
	guint number;
	NomadJukebox *jukebox;
	gint i;
	GSList *list;
	
	g_type_init();
	g_thread_init( NULL );
	
	NJB_Set_Unicode( NJB_UC_UTF8 );

	number = 0;
	if( NJB_Discover( njbs, 0, &number ) == -1 ) {
		fprintf( stderr, "Error discovering jukeboxes\n" );
	}
	if( number == 0 ) {
		fprintf( stderr, "no NJB devices found\n" );
		return 0;
	}
	
	list = NULL;
	for( i = 0; i < number; i ++ ) {
		jukebox = nomad_jukebox_new( &njbs[ i ] );
		if( ! nomad_jukebox_acquire( jukebox ) ) {
			fprintf( stderr, "failed to acquire jukebox" );
		} else {
			list = g_slist_prepend( list, jukebox );
		}
	}
	
	g_slist_foreach( list, getowner, NULL );
	g_slist_foreach( list, nomad_jukebox_release, NULL );
	g_slist_free( list );
	
	return 0;
}
