/*
                                  NETWIB
                             Network library
                Copyright(c) 1999-2005 Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
                   http://laurentconstantin.free.fr/
                   http://membres.lycos.fr/lauconstantin/
  [my current email address is on the web servers]

                                  -----
  This file is part of Netwib.

  Netwib is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  version 2 as published by the Free Software Foundation.

  Netwib is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details (http://www.gnu.org/).

------------------------------------------------------------------------
*/

#include <netwib/inc/maininc.h>

/*-------------------------------------------------------------*/
netwib_err netwib_uint32_init_rand(netwib_uint32 min,
                                   netwib_uint32 max,
                                   netwib_uint32 *prand)
{
  if (min > max) {
    return(NETWIB_ERR_PAINVALIDRANGE);
  }

  if (prand != NULL) {
    netwib_er(netwib_priv_rand_gene(prand, NULL));
    if (min != 0 || max != 0xFFFFFFFFU) {
      *prand = min + *prand % (max - min + 1);
    }
  }

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwib_uint64_init_rand(netwib_uint64 min,
                                   netwib_uint64 max,
                                   netwib_uint64 *prand)
{
  netwib_uint32 r, r2;

#if NETWIB_INT64_FAKE == 0
  if (min > max) {
    return(NETWIB_ERR_PAINVALIDRANGE);
  }
#else
  netwib_cmp cmp;
  netwib_er(netwib_uint64_cmp(min, max, &cmp));
  if (cmp == NETWIB_CMP_GT) {
    return(NETWIB_ERR_PAINVALIDRANGE);
  }
#endif

  if (prand != NULL) {
    /* generate */
    netwib_er(netwib_priv_rand_gene(&r, NULL));
    netwib_er(netwib_priv_rand_gene(&r2, NULL));
    netwib_c2_uint64_set_32(*prand, r, r2);
    /* round */
#if NETWIB_INT64_FAKE == 0
    if (min != 0 || max != 0xFFFFFFFFU) {
      *prand = min + *prand % (max - min + 1);
    }
#else
    if (min.high != 0 || min.low != 0 ||
        max.high != 0xFFFFFFFFU || max.high != 0xFFFFFFFFU) {
      netwib_uint64 tmp;
      netwib_er(netwib_uint64_sub(max, min, &tmp));
      netwib_er(netwib_uint64_inc(&tmp));
      netwib_er(netwib_uint64_div(*prand, tmp, NULL, &tmp));
      netwib_er(netwib_uint64_add(min, tmp, prand));
    }
#endif
  }

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwib_buf_append_rand(netwib_uint32 size,
                                  netwib_byte min,
                                  netwib_byte max,
                                  netwib_buf *pbuf)
{
  netwib_data data;
  netwib_uint32 s, range;
  netwib_byte b, randarray[NETWIB_PRIV_RAND_ARRAY_LEN];

  if (min > max) {
    return(NETWIB_ERR_PAINVALIDRANGE);
  }

  netwib_er(netwib_buf_wantspace(pbuf, size, &data));

  /* chunks of 6/8 */
  s = size; /* we need to keep size for endoffset */
  while (s > NETWIB_PRIV_RAND_ARRAY_LEN - 1) {
    netwib_er(netwib_priv_rand_gene(NULL, data));
    data += NETWIB_PRIV_RAND_ARRAY_LEN;
    s -= NETWIB_PRIV_RAND_ARRAY_LEN;
  }

  /* last bytes */
  if (s) {
    netwib_er(netwib_priv_rand_gene(NULL, randarray));
    netwib_c_memcpy(data, randarray, s);
    data += s;
  }

  /* eventually recompute bytes if a smaller range is expected */
  if (min != 0 || max != 255) {
    range = max - min + 1;
    s = size;
    data -= size;
    while (s--) {
      b = *data;
      *data++ = (netwib_byte)(min + ((b*range) / 256));
    }
  }

  pbuf->endoffset += size;
  return(NETWIB_ERR_OK);
}
