/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  main.c
 * Purpose: Call all initialization routines and then start boot process
 * Entries: main
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <general.h>
#include <version.h>
#include <minidos.h>
#include <net.h>
#include <boot.h>
#include <romlib.h>



/*
 **************************************************************************
 * 
 * Main routine: call all the initialization routines, and then start
 * the net boot process
 *
 */
void kernelmain(progadr)
unsigned long progadr;
{

  /* Initialize all modules */
  init_minidos(progadr);
  init_net();

  /* Print some messages */
#if defined(PATCHLEVEL) && PATCHLEVEL > 0
  printf("\nFree memory: %d\n\n\nBoot-Rom V%d.%d.%d, %s\n\n",
		memavail(), MAJOR_VER, MINOR_VER, PATCHLEVEL, COPYRIGHT);
#else
  printf("\nFree memory: %d\n\n\nBoot-Rom V%d.%d, %s\n\n",
		memavail(), MAJOR_VER, MINOR_VER, COPYRIGHT);
#endif

  /* Now actually load the operating system */
  do_boot();
}
