#include <includes.h>
#include <zlib.h>
#include "nessus_plugin.h"




struct nessus_plugin * nessus_plugin_new(char * id, char * name, char * category, char * copyright, char * description, char * summary, char * family, char * version, char * cve, char * bid, char * xrefs)
{
 struct nessus_plugin * np = malloc(sizeof(*np));
 unsigned char * buf;
 unsigned long    bufsz;

 if ( np == NULL ) abort();
 bzero(np, sizeof(*np));
 np->id = atoi(id);
 np->asc_id = cache_inc(id);

 np->name = cache_inc(name); 
 np->category = cache_inc(category);
 np->copyright = cache_inc(copyright);
 
 np->desc_len = strlen(description);

 bufsz = np->desc_len + 255;
 buf = malloc ( bufsz );
 
 if ( buf == NULL ) abort();
 compress2(buf, &bufsz, (unsigned char*)description, np->desc_len, 3);
 buf = realloc(buf, bufsz);
 np->zdesc_len = bufsz;
 if ( buf == NULL ) abort();
 np->zdescription = buf;

 np->summary = strdup(summary);
 np->family  = cache_inc(family);
 np->version = cache_inc(version);
 np->cve     = cache_inc(cve);
 np->bid     = cache_inc(bid);
 np->xrefs   = cache_inc(xrefs);
 np->next    = NULL;
 return np;
}



struct nessus_plugin * nessus_plugin_get_by_name(struct nessus_plugin * plugins, char * name)
{
 while ( plugins != NULL )
	{
 	if ( strcmp(plugins->name, name) == 0 ) return plugins;
	plugins = plugins->next;
	}

 return NULL;
}


struct nessus_plugin * nessus_plugin_get_by_id(struct nessus_plugin * plugins, int id )
{
 while ( plugins != NULL )
 	{
	if ( plugins->id == id ) return plugins;
	plugins = plugins->next;
	}

  return NULL;
}

char * nessus_plugin_get_description(struct nessus_plugin * plugin)
{
 char * ret;
 unsigned long retsz = plugin->desc_len;
 ret = emalloc(plugin->desc_len + 1);
 uncompress((unsigned char*)ret, &retsz, plugin->zdescription, plugin->zdesc_len);
 return ret;
}



void nessus_plugin_free(struct nessus_plugin * plugins)
{
 /* TBD */
}
