/* NessusClient
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */
 
#ifndef _NESSUSC_COMM_H
#define _NESSUSC_COMM_H

#define PREF_CHECKBOX "checkbox"
#define PREF_ENTRY "entry"
#define PREF_RADIO "radio"
#define PREF_PASSWORD "password"
#define PREF_FILE "file"


#include "context.h"

int comm_init(int,char*);
int comm_get_pluginlist();
int comm_get_preferences(struct context *);
int comm_get_rules(struct context *);

int comm_get_plugins(struct context *);

int comm_send_preferences(struct context *);
int comm_send_long_preferences(struct context *);
int comm_send_rules(struct context *);
void comm_get_preferences_errors(struct context*);

harglst * comm_get_sessions();
int comm_server_restores_sessions(struct context *);
int comm_server_detached_sessions(struct context *);
void comm_delete_session(struct context *, char*);
void comm_restore_session(struct context *, char*);
void comm_stop_detached_session(struct context *, char *name);

int comm_plugin_upload(char*);

int comm_get_dependencies(struct context*);

#ifdef ENABLE_SAVE_TESTS
harglst * comm_get_detached_sessions(struct context *);
#endif


#endif
