#TRUSTED b2a508f8d7e510ed6c11d3e666954bd87fca1054a37aeaff0e4d852296195500419e86f1279d6847e62621723a525085b7c8c78a53541d7e1951aeed791bd3b9fca9d31e1cb67f4bc8275b1abd19273567a65fe096a869e8a4b4308807a24ee5d25471291fed5dede59c63dd191cba7d26e7ecd0c59608d4ac7fe1bec3649d397cadbc51858af9a92f1448f826c8318e5e961f3ccc1c9d809b35014c2c539418f400335d6d2a7dce4a9b8a9a3ffa4e71b09e4f57d808e4d4215346352917adf493a8620b9e115e4dfb92d916d2ec9fabab52e223510dfa428cf96e82667dbce271c7f13b8d6f006c2e74be03b9a0c715f2c023c1ec5aa11fcd96cb6a9b1c3bc4eefe73b5b0e594a00736893bb0ff75db1c462ed4d7001b08b724e758b4ca3fc69845f7cb854406af0d741596b5ee6851ff00fd22a3200d0e0a6ad54a0b5cb9f7fabd4f21743b6a4ccf0285d8a19fb06c601258add3bc7aa2983f0671b794381ba728be60ebd1a9e82da32655581a8af80848259e646f465ce41165e906edf72192281be057823294474539e9b232ecdd3857ad76d83652bd9702fe92e912026edaebdcb7ff956270cb20ffffd50566247d510fad0f168bf4f9109dd9a2d824f86d91e226ffe5e23e81770a2e4df25bbf1803e153cafb7675066a9fc9536683cf4fa2acc152fffeef08a9de462c434e061c80f16af03140ba27db7d300e7192c8
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("script_get_preference_file_location")) exit(0);
if ( ! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15884);
 script_version ("1.1");
 name["english"] = "Hydra: SMB";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SMB accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SMB authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_DESTRUCTIVE_ATTACK); # Because of accounts autolock
 
 script_add_preference(name: "Check local / domain accounts", 
	value: "Local accounts; Domain Accounts; Either", type: "radio");
 script_add_preference(name: "Interpret passwords as NTLM hashes", 
	value: "no", type: "checkbox");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports(139,445);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("SMB/transport"); port = int(port);
if (! port) port = 445;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "smbnt";	# what's "smb"?

opt = "";
p = script_get_preference("Check local / domain accounts");
if ("Local" >< p) opt = "L";
else if ("Domain" >< p) opt = "D";
else opt = "B";

p = script_get_preference("Interpret passwords as NTLM hashes");
if ("yes" >< p) opt += "H";
argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SMB accounts:\n' + report);
