#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Karol Wiesek - iDEFENSE 
#
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(15394);
 script_bugtraq_id(11216, 11281);
 script_cve_id("CVE-2004-0815");
 script_xref(name:"OSVDB", value:"10464");
 script_version ("$Revision: 1.8 $");
 name["english"] = "Samba Remote Arbitrary File Access";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote file server allows access to arbitrary files.

Description :

According to its version number, the remote Samba server is affected
by a flaw that allows an attacker to access arbitrary files which
exist outside of the shares's defined path.  An attacker needs a valid
account to exploit this flaw. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=146
http://archives.neohapsis.com/archives/bugtraq/2004-09/0443.html
http://archives.neohapsis.com/archives/bugtraq/2004-10/0038.html

Solution : 

Upgrade to Samba 2.2.12 / 3.0.7 or later.

Risk factor : 

Low / CVSS Base Score : 2 
(AV:R/AC:L/Au:R/C:C/I:N/A:N/B:N)";


 script_description(english:desc["english"]);
 
 summary["english"] = "checks samba version";
 summary["francais"] = "vrifie la version de samba";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
  
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 
 family["english"] = "Remote file access";
 script_family(english:family["english"]);
 script_dependencie("smb_nativelanman.nasl");
 script_require_keys("SMB/NativeLanManager");
 exit(0);
}

#
# The script code starts here
#

lanman = get_kb_item("SMB/NativeLanManager");
if("Samba" >< lanman)
{
 if(ereg(pattern:"Samba 2\.2\.([0-9]|1[01])[^0-9]*$",string:lanman))
   security_note(get_kb_item("SMB/transport"));
 else if(ereg(pattern:"Samba 3\.0\.([01]|2|2a)$", string:lanman))
   security_note(get_kb_item("SMB/transport"));
}
