#
# This script was written by Vincent Renardias <vincent@efb2.com>
#
# Licence : GPL v2
#

if(description)
{
 script_id(10678);
 name["english"] = "Apache /server-info accessible";
 name["francais"] = "Apache /server-info accessible";
 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
Requesting the URI /server-info gives information about
your Apache configuration.

Risk factor : Low.
Solution : 
If you don't use this feature, comment the appropriate section in
your httpd.conf file. If you really need it, limit its access to
the administrator's machine.";

 script_description(english:desc["english"]);
 
 summary["english"] = "Make a request like http://foo.bar.edu/server-info";
 summary["francais"] = "Fait une requte du type http://foo.bar.edu/server-info";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Vincent Renardias",
		francais:"Ce script est Copyright (C) 2001 Vincent Renardias");
 family["english"] = "Misc.";
 family["francais"] = "Divers";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/apache");
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
str = "Apache Server Information";
if(!port) port = 80;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  buffer = http_get(item:"/server-info", port:port);
  send(socket:soc, data:buffer);
  data = recv(socket:soc, length:100000);
  if( str >< data )
  {
   security_warning(port);
  }
  close(soc);
 }
}
