/*
 * Copyright (c) 2003, 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using Sioux;
using Nemerle.Collections;
using Nemerle.Xml;
using System.Xml;

namespace Sioux.Sessions
{
    public class Sessions : Application
    {

        protected override DoGet() : void
        {
            def doc = XmlDocument ();
            def sb = System.Text.StringBuilder();
            ignore(sb.Append("[html][head][title]Sessions</title></head>[body][b]Sessions example</b><br/>"));
            def session = request.GetSession();
            ignore(sb.Append("Session ID: " + session.SessionID + "<br/>"));
            ignore(sb.Append("Created: " + session.CreationTime.ToString() + "<br/>"));
            ignore(sb.Append("Last accessed: " + session.LastAccesedTime.ToString() + "<br/>"));
            ignore(sb.Append("Following data is in your session: <br/>"));
            ignore(sb.Append(compute_vars(session)  + "<br/>"));
            ignore(sb.Append("<form action=\"sendvars.xml\" method=\"POST\">"));
            ignore(sb.Append("Name of session attribute:  <input type=\"text\" length=\"20\" name=\"name\" /><br/>"));
            ignore(sb.Append("Value of session attribute:  <input type=\"text\" length=\"20\" name=\"value\" /><br/>"));
            ignore(sb.Append("<input type=\"submit\" /></form>"));
            ignore(sb.Append("</body></html>"));

            doc.LoadXml(sb.ToString());
            
            FormTemplate = Some (XmlPipeline.Process(XmlGenerator(doc),[Transformers.EncodeUrlTransformer("*/href|*/action","")]));
        }

        protected override DoPost() : void
        {
            def session = request.GetSession();
            when(PageName == "/sendvars.xml")
            {    
                match( (PostVars.Get("name"),PostVars.Get("value") ))
                {
                    | (Some(name),Some(val)) =>
                      {
                          session.AddAttribute(name,val);
                      }
                    | _ => ()
                }
            }
            DoGet()
        }

        private compute_vars (s : Session) : string
        {
            def attrs = s.Attributes;
            def loop (lst) : string
            {
                match(lst)
                {
                    | [] => "<br/>"
                    | (name,val) :: rest => name + " = " + val.ToString() + "<br/>" + loop (rest)
                }
            }
            loop(attrs)
        }

    }
}
