/*
BSD License
Copyright 2003-2004 Randy Ridge
http://www.randyridge.com/Tao/Default.aspx
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither Randy Ridge nor the names of any Tao contributors may be used to
   endorse or promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
   BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
   CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
   ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/



/*
 * Copyright (c) 1993-1997, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED 
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation, and that 
 * the name of Silicon Graphics, Inc. not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission. 
 *
 * THE MATERIAL EMBODIED ON THIS SOFTWARE IS PROVIDED TO YOU "AS-IS"
 * AND WITHOUT WARRANTY OF ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL SILICON
 * GRAPHICS, INC.  BE LIABLE TO YOU OR ANYONE ELSE FOR ANY DIRECT,
 * SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY
 * KIND, OR ANY DAMAGES WHATSOEVER, INCLUDING WITHOUT LIMITATION,
 * LOSS OF PROFIT, LOSS OF USE, SAVINGS OR REVENUE, OR THE CLAIMS OF
 * THIRD PARTIES, WHETHER OR NOT SILICON GRAPHICS, INC.  HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS, HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE
 * POSSESSION, USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * US Government Users Restricted Rights 
 * Use, duplication, or disclosure by the Government is subject to
 * restrictions set forth in FAR 52.227.19(c)(2) or subparagraph
 * (c)(1)(ii) of the Rights in Technical Data and Computer Software
 * clause at DFARS 252.227-7013 and/or in similar or successor
 * clauses in the FAR or the DOD or NASA FAR Supplement.
 * Unpublished-- rights reserved under the copyright laws of the
 * United States.  Contractor/manufacturer is Silicon Graphics,
 * Inc., 2011 N.  Shoreline Blvd., Mountain View, CA 94039-7311.
 *
 * OpenGL(R) is a registered trademark of Silicon Graphics, Inc.
 */


using System;
using Tao.Glut;
using Tao.OpenGl;

namespace Redbook {

    /// 
    ///     This program demonstrates the use of the GL lighting model.  Objects are drawn
    ///     using a grey material characteristic.  A single light source illuminates the
    ///     objects.
    /// 
    /// [remarks]
    ///     [para]
    ///         Original Author:    Silicon Graphics, Inc.
    ///         http://www.opengl.org/developers/code/examples/redbook/scene.c
    ///     </para>
    ///     [para]
    ///         C# Implementation:  Randy Ridge
    ///         http://www.randyridge.com/Tao/Default.aspx
    ///     </para>    ///     [para]
    ///         Nemerle Implementation:  Kamil Skalski
    ///     </para>
    /// </remarks>

    public sealed class Scene {
        // --- Entry Point ---

        public static Main() : void {
            Glut.glutInit();
            Glut.glutInitDisplayMode(Glut.GLUT_SINGLE  %| Glut.GLUT_RGB %| 
                                     Glut.GLUT_DEPTH);
            Glut.glutInitWindowSize(500, 500);
            ignore (Glut.glutCreateWindow("Scene"));
            Init();
            Glut.glutDisplayFunc(Glut.DisplayCallback(Display));
            Glut.glutKeyboardFunc(Glut.KeyboardCallback(Keyboard));
            Glut.glutReshapeFunc(Glut.ReshapeCallback(Reshape));
            Glut.glutMainLoop();
        }


        // --- Application Methods ---

        private static Init() : void {
            def lightAmbient = array [ 0.0f, 0.0f, 0.0f, 1.0f ];
            def lightDiffuse = array [ 1.0f, 1.0f, 1.0f, 1.0f ];
            def lightSpecular = array [ 1.0f, 1.0f, 1.0f, 1.0f ];
            // light_position is NOT default value
            def lightPosition = array [ 1.0f, 1.0f, 1.0f, 0.0f ];

            Gl.glLightfv(Gl.GL_LIGHT0, Gl.GL_AMBIENT, lightAmbient);
            Gl.glLightfv(Gl.GL_LIGHT0, Gl.GL_DIFFUSE, lightDiffuse);
            Gl.glLightfv(Gl.GL_LIGHT0, Gl.GL_SPECULAR, lightSpecular);
            Gl.glLightfv(Gl.GL_LIGHT0, Gl.GL_POSITION, lightPosition);

            Gl.glEnable(Gl.GL_LIGHTING);
            Gl.glEnable(Gl.GL_LIGHT0);
            Gl.glEnable(Gl.GL_DEPTH_TEST);
        }


        // --- Callbacks ---

        private static Display() : void {
            Gl.glClear(Gl.GL_COLOR_BUFFER_BIT %| Gl.GL_DEPTH_BUFFER_BIT);

            Gl.glPushMatrix();
                Gl.glRotatef(20.0f, 1.0f, 0.0f, 0.0f);

                Gl.glPushMatrix();
                    Gl.glTranslatef(-0.75f, 0.5f, 0.0f); 
                    Gl.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
                    Glut.glutSolidTorus(0.275, 0.85, 15, 15);
                Gl.glPopMatrix();

                Gl.glPushMatrix();
                    Gl.glTranslatef(-0.75f, -0.5f, 0.0f); 
                    Gl.glRotatef(270.0f, 1.0f, 0.0f, 0.0f);
                    Glut.glutSolidCone(1.0, 2.0, 15, 15);
                Gl.glPopMatrix();

                Gl.glPushMatrix();
                    Gl.glTranslatef(0.75f, 0.0f, -1.0f); 
                    Glut.glutSolidSphere(1.0, 15, 15);
                Gl.glPopMatrix();
            Gl.glPopMatrix();
            Gl.glFlush();
        }



        private static Keyboard(key : byte, _x : int, _y : int) : void {
            match (key) {
              |  27b =>
                    Environment.Exit(0);
              | _ => () 
            }
        }

        private static Reshape(w : int, h : int) : void {
            Gl.glViewport(0, 0, w, h);
            Gl.glMatrixMode(Gl.GL_PROJECTION);
            Gl.glLoadIdentity();
            def (w, h) = ((w :> double), (h :> double));
            if(w <= h) {
                Gl.glOrtho(-2.5, 2.5, -2.5 * h / w, 2.5 * h / w, -10.0, 10.0);
            }
            else {
                Gl.glOrtho(-2.5 * w / h, 2.5 * w / h, -2.5, 2.5, -10.0, 10.0);
            };
            Gl.glMatrixMode(Gl.GL_MODELVIEW);
            Gl.glLoadIdentity();
        }

    }
}
