using Nemerle.IO;

class A {
  public this () {}

  public Y : int * int
  {
    mutable x : int;
    mutable y : int;
    get { (x, y) }
    set { def (a, b) = value; x = a + 1; y = b + 1; }
  }
}

 module PairParameters {
  public Run ():void{
    def PairFoo(pair){
      | (_,b) => b
    }
    def ListFoo(list){
      | pair::rest =>
        Nemerle.IO.printf ("%s\n", pair.ToString ());
        PairFoo(pair) || ListFoo(rest);
      | [] => false;
    }
    ignore(ListFoo([ (10,true),(9,false) ] ));
  }
 }


module M {

  public Main () : void {
    def x = (2, "aa");
    def y = (2, "aa");
    def z = (1, "aa");
    def w = (2, "ab");
    when (x.Equals (y)) Nemerle.IO.printf ("1\n");
    when (x.Equals (z)) Nemerle.IO.printf ("2\n");
    when (x.Equals (w)) Nemerle.IO.printf ("3\n");
    when (y.Equals (z)) Nemerle.IO.printf ("4\n");
    when (y.Equals (w)) Nemerle.IO.printf ("5\n");
    when (z.Equals (w)) Nemerle.IO.printf ("6\n");
    Nemerle.IO.printf ("%s %s %s %s\n", x.ToString (), y.ToString (), z.ToString (), w.ToString ());
    
    def a = A();
    Nemerle.IO.printf ("%s\n", a.Y.ToString ());
    a.Y = (41, 41);
    Nemerle.IO.printf ("%s\n", a.Y.ToString ());

    mutable x1 = 5;
    mutable x2 = "6";
    Nemerle.IO.printf ("%d %s\n", x1, x2);
    (x1, x2) = (7, "3");
    Nemerle.IO.printf ("%d %s\n", x1, x2);
    _ = 5;

    PairParameters.Run ();
    TupleIdx.Go ();
  }
}

class TupleIdx {
  static id['a] (x : 'a) : 'a { x }
  
  public static Go () : void
  {
    def x = (1, "foo", 1.3);
    
    def y = x[1] + "bar";
    def z = (x[0] * 42) : int;
    def zz = x[2] / 0;

    printf ("%s %d %lf\n", y, z, zz);

    def y = id(x)[1] + "bar";
    def z = (id(x)[0] * 42) : int;
    def zz = id(x)[2] / 0;

    printf ("%s %d %lf\n", y, z, zz);
  }
}

/*
BEGIN-OUTPUT
1
(2, aa) (2, aa) (1, aa) (2, ab)
(0, 0)
(42, 42)
5 6
7 3
(10, True)
foobar 42 Infinity
foobar 42 Infinity
END-OUTPUT
*/

