#include "base.h"
#include "tree.h"
#include "escape.h"
#include "proc.h"
#include "gui.h"


static char *help_txt[] =
  {
    "[12345678]..sort by corresponding column",
    "0...........tree view",
    "u/d.........move highlight up/down",
    "r...........refresh",
    "k...........kill processes",
    "t...........toggle kill signal",
    "q...........quit",        
    "LEFT........back one screen",
    "e...........expand/collapse all",
    "ENTER.......expand/collapse",
    "c...........issue command",
    "a...........select all",
    "C...........clear all selections",
    "R...........reverse selections",
    "m...........monitor selected processes",
    "ctrl-g......cancel",
    "f...........find",
    "g...........find again",
    "s...........search and select",
    "\n",
    "press any key to exit this screen",
    NULL
  };

static char *color_template[] = 
  {
    " ",
    "normal_color",
    "selected_color",
    "banner_color",
    "highlight_color",
    "selected_highlight_color",
    "banner_selected_color",
    NULL
  };
    


int getchoice(killer_t * chow)
{
    static int selected_row = 0;
    static unsigned int selected = 0;
    
    static int buffer = 0;

    static int key = KEY_F(3);
    static int tag = 0;
    static int sig = 0;
    #define NRSIGS 6
    int siglist[NRSIGS] = {1, 9, 6, 3, 2, 15};
    char *signame[NRSIGS] = { "SIGHUP ", "SIGKILL", "SIGABRT", 
			 "SIGQUIT", "SIGINT ", "SIGTERM" };
    int tmp = NORMAL;
    char sigstr[8];
    /*static int t_view = 0;*/
    procinfo_t *list;
    static int e_view = 1;

    int i;

    int count;
    /* char input[BOX_WIDTH - 5]; */ /* gcc doesnt like this*/
    static char *finput;
    char *input;
     
    int pos;

    killer_t *sub;    
     
    input = (char *) malloc((BOX_WIDTH - 5) * sizeof(char));

    strcpy(sigstr, signame[sig]);

    if (key == KEY_F(1) || key == KEY_F(2) || key == KEY_F(3) 
        || key == KEY_F(4) || key == KEY_F(5) || key == KEY_F(6) 
	|| key == 'k' || key == 'r' || key == '\n' || key == 'e' 
	|| key == 's' || key == KEY_LEFT || key == 'c' || key == ' ' 
	|| key == KEY_F(7) || key == KEY_F(8) || key == 'a' || key == 'C' || key == 'm'
	|| key == '1' || key == '2' || key == '3' || key == '4' || key == '5'
	|| key == '6' || key == '7' || key == '8') {
	
      if (key == 'k' || key == 'r' || key == '\n' || key == 'e' 
	  || key == 's' || key == KEY_LEFT || key == 'c' || key == ' ' 
	  || key == 'a' || key == 'C' || key == 'm') {
	    tag = -1;
	   
      } else
	    tag = key;

      
      if (e_view) {
	for (i = 0; i < chow->count; i++) {
	  chow->pidlist[i].expand = 1;
	}
      }
      shell_sort(chow->pidlist, tag, chow->count);

      if((key > 48 && key < 58) || key == 's' || key == 'm' || key == 'r')
	make_tree(chow);
      
      chow->t_count = 0;
      graph_branch(chow->ptree, chow, 0);

      draw_strings(chow->trunk, chow->t_count);
	      
    }
#if !DEBUG
    draw_top(tag);
    attrset(COLOR_PAIR(NORMAL_COLOR));
    mvprintw(0, COLS - strlen(sigstr), "%s", sigstr);
    refresh();
#endif
    /*  printf("chk point\n"); */
    if (key == KEY_F(10) || key == '0') {
      /*  clear_all_screen(); */
      for (i = 0; i <= MAX_ROW; i++) {
	row_clear(i);
      }
      if (t_view == 0) {
	    /*  selected_row = selected = 0; */
	    t_view = 1;
	} else
	    t_view = 0;
    }
   
    if (t_view) {
	list = chow->trunk;
	count = chow->t_count;
	/* clear_all_screen(); */
    } else {
	list = chow->pidlist;
	count = chow->count;
    }

    if(selected > count - 1) {
      if (count - 1 < MAX_ROW) {
	selected = selected_row = count - 1;
      } else {
	selected = selected_row = 0;
	move_down(buffer, &selected_row, &selected, count);
      }
    }
	
    if (key != 'h') {
	
#if !DEBUG
	draw_menu(chow, selected_row, selected, count, t_view);
#endif

    } else
	help_screen();

    if (key != 'h') {

	fflush(stdin);
	key = getch();

	if (key == KEY_UP || key == 'u') {
	    move_up(1, &selected_row, &selected);
	}
	if (key == KEY_DOWN || key == 'd') {

	    move_down(1, &selected_row, &selected, count);
	    /*  else */
	    /*            move_down(1, &selected_row, &selected, ); */
	}
	if (key == KEY_NPAGE) {
	    /*  if(!t_view) */
	    move_down(MAX_ROW, &selected_row, &selected, count);
	    /*  else */
	    /*            move_down(MAX_ROW, &selected_row, &selected, t_row); */
	}
	if (key == KEY_PPAGE) {
	    move_up(MAX_ROW, &selected_row, &selected);
	}
	/*  mvprintw(0, 0, "%i",  list[selected].proc->pid); */
	if (key == 'k' && count) {

	    murder(selected, list, count, siglist[sig]);

	    if (chow->monitoring)
		tmp = MONITOR_REFRESH;
	    else
		tmp = REINIT;
	}
	if (key == '\n') {
	    if (t_view) {
		pos = pid_pos(list[selected].proc->pid, chow->pidlist, chow->count);
		chow->pidlist[pos].expand = (chow->pidlist[pos].expand + 1) % 2;
		e_view = 0;
		/*  selected_row = selected = 0; */
		clear_all_screen();
	    }
	    tmp = NORMAL;	    
	}

	if (key == 'e') {
	    for (i = 0; i <= MAX_ROW; i++) {
		row_clear(i);
	    }
	    if (t_view) {
		if (!e_view) {
		    for (i = 0; i < chow->count; i++) {
			chow->pidlist[i].expand = 1;
		    }
		    e_view = 1;
		} else
		    for (i = 0; i < chow->count; i++) {
			chow->pidlist[i].expand = 0;
			e_view = 0;
		    }
	    }
	    clear_all_screen();
	    tmp = NORMAL;
	}
	if (key == 's') {
	    if (chow->count) {
		input[0] = '\0';
		input_dlg(input, "search and select:");
		if (input[0] != '\0') {
		    search(chow, input, t_view);
		}
	    }
	    tmp = NORMAL;
	}	

	if (key == 'f') {
	    if (chow->count){	      
	      if(finput)
		free(finput);
	      finput = (char * ) malloc((BOX_WIDTH - 5) * sizeof(char));
	      finput[0] = '\0';
	      input_dlg(finput, "find:");
	      if (finput[0] != '\0') {
		move_down(find(chow, selected, finput, t_view) -  selected, &selected_row, &selected, chow->count);
	      }
	    }
	    tmp = NORMAL;
	}


	if (key == 'g') {
	    if (chow->count && finput) {
	      if (finput[0] != '\0') {
		move_down(find(chow, selected, finput, t_view) -  selected, &selected_row, &selected, chow->count);
		}
	    }
	    tmp = NORMAL;
	}

	
	if (key == 'c') {
	    if (chow->count) {
		sprintf(input, "%i", list[selected].proc->pid);
		input_dlg(input, "command:");
		if (input[0] != '\0') {
		    system(input);
		    sleep(1);
		    tmp = REINIT;
		} else
		    tmp = NORMAL;
	    } else
		tmp = NORMAL;
	}
	if (key == ' ') {
	    if (count) {
		sub = chow;
		while (sub) {
		    pos = pid_pos(list[selected].proc->pid, sub->pidlist, sub->count);
		    sub->pidlist[pos].is_selected = (sub->pidlist[pos].is_selected + 1) % 2;
		    sub = sub->mother;
		}
	    }
	    move_down(1, &selected_row, &selected, count);
	    tmp = NORMAL;
	}
	if (key == 'a') {
	    for (i = 0; i < count; i++) {
		sub = chow;
		while (sub) {
		    pos = pid_pos(list[i].proc->pid, sub->pidlist, sub->count);
		    sub->pidlist[pos].is_selected = 1;
		    sub = sub->mother;
		}
	    }
	    tmp = NORMAL;
	}
	if (key == 'C') {
	    for (i = 0; i < chow->count; i++) {
		    chow->pidlist[i].is_selected = 0;
	    }
	    tmp = NORMAL;
	}
	if (key == 'R') {
	    for (i = 0; i < count; i++) {
	        int pmt;
	        sub = chow;
		while (sub) {
		    pos = pid_pos(list[i].proc->pid, sub->pidlist, sub->count);
		    pmt = sub->pidlist[pos].is_selected;
		    sub->pidlist[pos].is_selected = !pmt;
		    sub = sub->mother;
		}
	    }
	    tmp = NORMAL;
	}
	if (key == 'q')
	    tmp = QUIT;

	if (key == 'r') {

	    if (chow->monitoring)
		tmp = MONITOR_REFRESH;
	    else
		tmp = REINIT;
	}
	if (key == KEY_LEFT) {
	    /*  e_view = 0; */
	    tmp = LEFT;
	}
	/*  if(key == 'R') */
	/*      tmp = -5; */

	if (key == 't') {
	    sig = (sig + 1) % NRSIGS;
	}
	if (key == 'm') {
	    selected = 0;
	    selected_row = 0;
	    tmp = MONITOR;
	}
	
	free(input);

	buffer = selected;

	return tmp;
    } else {
	key = getch();
	key = ' ';
	clear_all_screen();
	draw_top(tag);
	attrset(COLOR_PAIR(NORMAL_COLOR));
	mvprintw(0, COLS - 8, "%s", sigstr);
	refresh();
	
	free(input);
	
	return NORMAL;
    }

}


void draw_menu(killer_t *chow, int current_highlight, unsigned int selected, int count, int t_view)
{
    int current_row = 0;
    int i;
    int pos;
    int col = START_COL;
    int row;
    char *str_buf;
    procinfo_t *options;
    int is_selected;
    char *item, *blank;


    if (t_view)
	options = chow->trunk;
    else
	options = chow->pidlist;

    str_buf = (char *) malloc((COLS + 1) * sizeof(char));
    /*  setpwent(); */
    /* printf("in draw menu\n"); */

    blank = (char *) malloc((COLS + 1) * sizeof(char));
    for (i = 0; i < COLS; i++)
	blank[i] = ' ';
    blank[COLS] = '\0';

    for (i = 0; i <= MAX_ROW; i++) {
	row_clear(i);
    }

    if (count) {
	while (current_row < MAX_ROW && selected + current_row - current_highlight < count) {

	    row = START_ROW + ROW_SPACE + current_row;
	    pos = (selected + current_row - current_highlight);
	    row_clear(current_row);

	    if (current_row < count) {
		is_selected = options[pos].is_selected;

		if (is_selected) {
		    attrset(COLOR_PAIR(SELECTED_COLOR) | A_BOLD);
		} else
		    attrset(COLOR_PAIR(NORMAL_COLOR));

		if (current_row == current_highlight) {
		    strncpy(str_buf, chow->pidlist[pid_pos(options[pos].proc->pid, chow->pidlist, chow->count)].pname, COLS);

		    if (is_selected)
			attrset(COLOR_PAIR(SELECTED_HIGHLIGHT_COLOR) | A_STANDOUT);
		    else
			attrset(COLOR_PAIR(HIGHLIGHT_COLOR) | A_STANDOUT);
		}

		mvprintw(row, 0, "%s", blank);

		item = (char *) malloc((COLS + 1) * sizeof(char));
		
		make_item(item,  options[pos]);
		
		mvprintw(row, col, "%s", item);
		
		if (current_row == current_highlight) 
		  mvprintw(row, USER + TTY_WIDTH + PID + CPU + NICE + MEM  + 2, ">");
		
		free(item);
	    }
	    current_row++;
	}
    }	
		       
    if (count) {
	attrset(COLOR_PAIR(BANNER_COLOR) | A_STANDOUT | A_BOLD);
	mvprintw(LINES - 1, 0, "%s", blank);
	mvprintw(LINES - 1, 0, "%s", str_buf);
    }
    refresh();
    free(blank);
}


void clear_all_screen()
{
    clear();
    refresh();
}


void move_up(int times, int *selected_row, unsigned int *selected)
{
    int i;
    for (i = 0; i < times; i++) {

	if (*selected_row > 0) {
	    (*selected_row)--;
	}
	if (*selected > 0) {
	    (*selected)--;
	}
    }
}


void move_down(int times, int *selected_row, unsigned int *selected, int count)
{
    int i;
    if (count) {
	for (i = 0; i < times; i++) {
	  if (*selected < count - 1) {
	    (*selected)++;
	    
	    if (*selected_row < (MAX_ROW - 1) && *selected_row < count - 1) {
	      (*selected_row)++;
	    }
	  }
	}
    }

}
void row_clear(int current_row)
{
    int i;
    char *tmp;

    tmp = (char *) malloc((COLS + 1) * sizeof(char));

    attrset(0);

    for (i = 0; i < COLS; i++) {
	tmp[i] = ' ';
    }

    tmp[COLS] = '\0';

    mvprintw(START_ROW + ROW_SPACE + current_row, 0, "%s", tmp);
    free(tmp);
}


void draw_top(int key)
{
    int col = START_COL;
    char *tmp;
    int size;
    int i;
    int space;
    static int key_buf;

    if (key == -1)
	key = key_buf;
    else
	key_buf = key;

    size = sizeof(char);

    space = USER;
    if (key == KEY_F(1) || key == '1' || key == 0)
	attrset(COLOR_PAIR(BANNER_SELECTED_COLOR) | A_NORMAL);
    else
	attrset(COLOR_PAIR(BANNER_COLOR) | A_STANDOUT);
    tmp = (char *) malloc((space + START_COL) * size);
    for (i = 0; i < space + START_COL - 1; i++)
	tmp[i] = ' ';

    tmp[i] = '\0';

    mvprintw(START_ROW, 1, tmp);
    mvprintw(START_ROW, col, "user");

    col += space;
    space = TTY_WIDTH;
    if (key == KEY_F(2) || key == '2')
	attrset(COLOR_PAIR(BANNER_SELECTED_COLOR) | A_NORMAL);
    else
	attrset(COLOR_PAIR(BANNER_COLOR) | A_STANDOUT);
    free(tmp);
    tmp = (char *) malloc(space * size);
    for (i = 0; i < space - 1; i++)
	tmp[i] = ' ';
    tmp[i] = '\0';
    mvprintw(START_ROW, col + 1, tmp);
    mvprintw(START_ROW, col, "tty");

    col += space;
    space = PID;
    if (key == KEY_F(3) || key == '3')
	attrset(COLOR_PAIR(BANNER_SELECTED_COLOR) | A_NORMAL);
    else
	attrset(COLOR_PAIR(BANNER_COLOR) | A_STANDOUT);
    free(tmp);
    tmp = (char *) malloc(space * size);
    for (i = 0; i < space - 1; i++)
	tmp[i] = ' ';
    tmp[i] = '\0';
    mvprintw(START_ROW, col + 1, tmp);
    mvprintw(START_ROW, col, "PID");

    col += space;
    space = CPU;
    if (key == KEY_F(4) || key == '4')
	attrset(COLOR_PAIR(BANNER_SELECTED_COLOR) | A_NORMAL);
    else
	attrset(COLOR_PAIR(BANNER_COLOR) | A_STANDOUT);
    free(tmp);
    tmp = (char *) malloc(space * size);
    for (i = 0; i < space - 1; i++)
	tmp[i] = ' ';
    tmp[i] = '\0';
    mvprintw(START_ROW, col + 1, tmp);
    mvprintw(START_ROW, col, "%cCPU", '%');

    col += space;
    space = MEM;
    if (key == KEY_F(5) || key == '5')
	attrset(COLOR_PAIR(BANNER_SELECTED_COLOR) | A_NORMAL);
    else
	attrset(COLOR_PAIR(BANNER_COLOR) | A_STANDOUT);
    free(tmp);
    tmp = (char *) malloc(space * size);
    for (i = 0; i < space - 1; i++)
	tmp[i] = ' ';

    tmp[i] = '\0';
    mvprintw(START_ROW, col + 1, tmp);
    mvprintw(START_ROW, col, "%MEM");
/*----------------------------------------*/
    col += space;
    space = NICE;
    if (key == KEY_F(6) || key == '6')
	attrset(COLOR_PAIR(BANNER_SELECTED_COLOR) | A_NORMAL);
    else
	attrset(COLOR_PAIR(BANNER_COLOR) | A_STANDOUT);
    free(tmp);
    tmp = (char *) malloc(space * size);
    for (i = 0; i < space - 1; i++)
	tmp[i] = ' ';

    tmp[i] = '\0';
    mvprintw(START_ROW, col + 1, tmp);
    mvprintw(START_ROW, col, "nice");
    /*----------------------------------------*/

    col += space;
    space = STAT;
    if (key == KEY_F(7) || key == '7')
	attrset(COLOR_PAIR(BANNER_SELECTED_COLOR) | A_NORMAL);
    else
	attrset(COLOR_PAIR(BANNER_COLOR) | A_STANDOUT);
    free(tmp);
    tmp = (char *) malloc(space * size);
    for (i = 0; i < space - 1; i++)
	tmp[i] = ' ';

    tmp[i] = '\0';
    mvprintw(START_ROW, col + 1, tmp);
    mvprintw(START_ROW, col, "STAT");

    /*----------------------------------------*/

    col += space;
    space = COLS - col;
    if (key == KEY_F(8) || key == '8')
	attrset(COLOR_PAIR(BANNER_SELECTED_COLOR) | A_NORMAL);
    else
	attrset(COLOR_PAIR(BANNER_COLOR) | A_STANDOUT);
    free(tmp);
    tmp = (char *) malloc(space * size);
    for (i = 0; i < space - 1; i++)
	tmp[i] = ' ';

    tmp[i] = '\0';
    mvprintw(START_ROW, col + 1, tmp);
    mvprintw(START_ROW, col + 1, " command");
    free(tmp);
}


void help_screen(void)
{
    int line;

    clear_all_screen();

    attrset(0);

    for (line = 0; help_txt[line]; line++) {
	mvprintw(line+2, 4, "%s", help_txt[line]);
    }
}


void input_dlg(char *input, char *greet)
{
    WINDOW *dialogue;
    int i, check, pos, length, j;
    /* char blank[COLS]; */ /* gcc doent like */

    char *blank;
    
    int tmp;
    int field = 0;
    int init_pos = strlen(greet) + 1;

    blank = (char * ) malloc(COLS * sizeof(char));
    
    for (i = 0; i < COLS - 1; i++)
	blank[i] = ' ';

    blank[i] = '\0';

    dialogue = newwin(1, COLS, LINES - 1, 0);

    wbkgd(dialogue, COLOR_PAIR(0));

   
    wattrset(dialogue, COLOR_PAIR(0));

    mvwprintw(dialogue, 0, 0, "%s", greet);
    
    noecho();
    curs_set(1);
    refresh();

    wrefresh(dialogue);
    /*  mvwgetstr(dialogue, 1, 0, input); */
    /*  wscanw(dialogue, "which da fuck one? %s", &input); */

    length = strlen(input);;
    i = 0;
    check = 1;
    pos = init_pos;

    while (check) {
	mvwprintw(dialogue, 0, 0, "%s", greet);
	if (field == 0) {
	    input[length] = '\0';
	    wattrset(dialogue, COLOR_PAIR(0));
	    mvwprintw(dialogue, 0, init_pos, "%s", blank);
	    mvwprintw(dialogue, 0, init_pos, "%s", input);
	   
	    wmove(dialogue, 0, pos);
	    wrefresh(dialogue);
	    /*  mvwprintw(dialogue, 3, pos, "%s", "    "); */
	    /*  tmp = mvwgetch(dialogue, 2, pos); */
	    tmp = getch();
	    if (tmp != ctrl ('G')) {
		if (tmp != '\n') {
		    if (tmp == KEY_BACKSPACE) {
			if (pos > init_pos) {
			    for (j = i; j < length; j++) {
				input[j - 1] = input[j];
			    }
			    pos--;
			    i--;
			    length--;
			}
		    } else if (tmp == KEY_LEFT) {
			if (i > 0) {
			    pos--;
			    i--;
			}
		    } else if (tmp == KEY_RIGHT) {
			if (i < length) {
			    pos++;
			    i++;
			}
		    } else if (tmp == ' ') {
			if (length < BOX_WIDTH - 5) {
			    for (j = length; j > i; j--) {
				input[j] = input[j - 1];
			    }
			    input[i] = ' ';
			    pos++;
			    length++;
			    i++;
			}
		    } else if (tmp == KEY_DC) {
			if (i < length) {
			    for (j = i; j < length; j++) {
				input[j] = input[j + 1];
			    }
			    length--;
			}
		    } else {
			if (length < BOX_WIDTH - 5) {
			    for (j = length; j > i; j--) {
				input[j] = input[j - 1];
			    }
			    input[i] = tmp;
			    pos++;
			    length++;
			    i++;
			}
		    }
		} else
		    check = 0;
	    } else {
		field = (field + 1) % 2;
	    }
	} else {
	    /*  mvwprintw(dialogue, 3, pos, "%s", "    "); */
	  input[0] = '\0';
	  check = 0;
	}
    }

    input[length] = '\0';
   
    wattrset(dialogue, COLOR_PAIR(0));
    
    wrefresh(dialogue);
    noecho();
    curs_set(0);
    /*  tmp = mvwgetch(dialogue, 5, 2); */
    delwin(dialogue);
    refresh();
    free(blank);

}


void murder(int selected, procinfo_t * list, int count, int sig)
{
    int i;
    int group = 0;

    for (i=0; i<count; ++i) {
	if (list[i].is_selected) {
	    if (kill(list[i].proc->pid, sig) == -1) {
	      /* XXX we should do something about... */
	    };
	    group = 1;
	}
    }

    if (!group)
	kill(list[selected].proc->pid, sig);
	
    sleep(1);
}

void make_item(char *item, procinfo_t procinfo)
{

  int i, col;
  char *tmp;

  for (i = 0; i < COLS; i++)
    item[i] = ' ';
  
  item[COLS] = '\0';
  
  col = START_COL;
  
  for(i = 0; i < USER; i++) {
    if(procinfo.proc->suser[i] && ((procinfo.proc->suser)[i] != '\0'))
      item[i + col] = (procinfo.proc->suser)[i];
    else
      break;
  }
  /*--------------------------------------*/
  col += USER;
  
  for(i = 0; i < TTY_WIDTH; i++) {
    if(procinfo.ttyc[i] && (procinfo.ttyc[i] != '\0'))
      item[i + col] = procinfo.ttyc[i];
    else
      break;
  }

  /*---------------------------------------*/

  col += TTY_WIDTH;

  tmp = (char *) malloc(PID * sizeof(char));
  sprintf(tmp, "%i", procinfo.proc->pid);

  for(i = 0; i < PID; i++) {
    if (tmp[i] && (tmp[i] != '\0'))
      item[i + col] = tmp[i];
    else 
      break;
  }

  free(tmp);
  
  /*--------------------------------------*/
  col += PID;
  
  tmp = (char *) malloc(CPU * sizeof(char));
  sprintf(tmp, "%2u.%u", procinfo.proc->pcpu / 10, procinfo.proc->pcpu % 10);
  
  for(i = 0; i < CPU; i++) {
    if(tmp[i] && (tmp[i] != '\0'))
      item[i + col] = (char) tmp[i];
    else
      break;
  }

  free(tmp);
  /*---------------------------------------*/
  col += CPU;

  tmp = (char *) malloc(MEM * sizeof(char));
  sprintf(tmp, "%2ld.%ld", procinfo.pmem / 10, procinfo.pmem % 10);
  
  for(i = 0; i < MEM; i++) {
    if(tmp[i]  && (tmp[i] != '\0'))
      item[i + col] = (char) tmp[i];
    else
      break;
  }

  free(tmp);
  /*---------------------------------------*/

  col += MEM;

  tmp = (char *) malloc(NICE * sizeof(char));
  sprintf(tmp, "%2ld", procinfo.proc->nice);

  for(i = 0; i < NICE; i++) {
    if(tmp[i]  && (tmp[i] != '\0'))
      item[i + col] = tmp[i];
    else
      break;    
  }

  free(tmp);
  
  /*----------------------------------------*/
  col += NICE;
  
  item[col] = procinfo.proc->state;
  

  /*----------------------------------------*/
  col += STAT;
  
  if(procinfo.is_selected)
    item[col] = '*';
  
  /*----------------------------------------*/
  col += 2;

  for(i = 0; i + col  < COLS; i++) {
    if (procinfo.s_pname[i] && (procinfo.s_pname[i] != '\0'))
      item[i + col] = (procinfo.s_pname)[i];
    else
      break;
  }
  /*-----------------------------------------*/

  item[COLS] = '\0';

}

int parse_rc_color(const char *path, color_config_t *color_config)
{
  
  FILE *f;
  char *linebuf; 
  int i;

  color_config[0].background = COLOR_BLACK;
  color_config[0].foreground = COLOR_WHITE;
  
  color_config[NORMAL_COLOR].background = COLOR_BLACK;
  color_config[NORMAL_COLOR].foreground = COLOR_WHITE;

  color_config[SELECTED_COLOR].background = COLOR_RED;
  color_config[SELECTED_COLOR].foreground = COLOR_GREEN;

  color_config[BANNER_COLOR].background = COLOR_YELLOW;
  color_config[BANNER_COLOR].foreground = COLOR_BLUE;

  color_config[HIGHLIGHT_COLOR].background = COLOR_BLACK;
  color_config[HIGHLIGHT_COLOR].foreground = COLOR_CYAN;

  color_config[SELECTED_HIGHLIGHT_COLOR].background = COLOR_BLACK;
  color_config[SELECTED_HIGHLIGHT_COLOR].foreground = COLOR_RED;

  color_config[BANNER_SELECTED_COLOR].background = COLOR_BLACK;
  color_config[BANNER_SELECTED_COLOR].foreground = COLOR_WHITE;

  f = fopen(path, "r");

  if(f == NULL) {
    
    return 1;
  }
  linebuf = (char *) malloc(STRING_LENGTH * sizeof(char));
  
  while((i = read_line(f, linebuf))) {
    if(i == 1)
      parse_line_color(color_config, linebuf);
  }

  free(linebuf);
  
  fclose(f);
  
  return 0;
    
}

int read_line(FILE *fp, char *s) 
{

  char *ch;  
  
  if(fgets(s, STRING_LENGTH, fp) == NULL)
    return 0;

  if(s[0] == '#')
    return 2;
  
  if ((ch = strchr(s, '\n')) != NULL)
    {
      return 1;
    } 
  else 
    {
      int c;
      c = getc (fp); /* This is kind of a hack. We want to know if the
                        char at the current point in the input stream is EOF.
                        feof() will only tell us if we've already hit EOF, not
                        if the next character is EOF. So, we need to read in
                        the next character and manually check if it is EOF. courtesy of mutt*/
      if (c == EOF)
      {
        return 1;
      }
      
    }

  return 0;
  
}
 
void parse_line_color(color_config_t *color_config, char *s)
{

  int i = 1;
  size_t offset = 0;
  size_t j = 0;
  int check = 1;
  char sbuf[1];
  char ch;
  int color;
  int space;
  
  space = 0;
  while(s[space] == ' ' || s[space] == '\t')
    space++;

  offset += (size_t) space;

  while(check && i < COLOR_OPTIONS) {
	if(strncmp(color_template[i], s + offset, strlen(color_template[i])) == 0) {
	  check = 0;
	}
    i++;
  }

  offset +=  strlen(color_template[i - 1]) - 1;

  if(i - 1 < COLOR_OPTIONS) {
    for(j = 0; (int) j + (int) offset < strlen(s); j++) {
      ch = (s + offset + j)[0];
      if(ch == '\n' || ch == EOF)
	break;
      if (ch >= 48 && ch < 56) {
	sprintf(sbuf, "%c", ch);
	color = atoi(sbuf);
	color_config[i - 1].background = color;
	break;
      }
    }

    offset = offset + j + 1;
    
    for(j = 0; (int) j + (int) offset < strlen(s); j++) {
      ch = (s + offset + j)[0];
      if(ch == '\n' || ch == EOF)
	break;      
      if (ch >= 48 && ch < 56) {
	sprintf(sbuf, "%c", ch);
	color = atoi(sbuf);
	color_config[i - 1].foreground = color;
	break;
      }
    }
  }
}
