/* $Id: PDB_seq_id.hpp 601577 2020-02-10 19:22:25Z lanczyck $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqloc.asn'.
 */

#ifndef OBJECTS_SEQLOC_PDB_SEQ_ID_HPP
#define OBJECTS_SEQLOC_PDB_SEQ_ID_HPP


// generated includes
#include <objects/seqloc/PDB_seq_id_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class NCBI_SEQLOC_EXPORT CPDB_seq_id : public CPDB_seq_id_Base
{
    typedef CPDB_seq_id_Base Tparent;
public:
    // constructor
    CPDB_seq_id(void);
    // destructor
    ~CPDB_seq_id(void);

    // comaprison function
    bool Match(const CPDB_seq_id& psip2) const;
    int Compare(const CPDB_seq_id& psip2) const;

    // format a FASTA style string
    ostream& AsFastaString(ostream& s) const;


    //  Reset both chain and chain-id.  
    void ResetChainIdentifiers(void);

    //  Sets both 'chain' and 'chain-id'.
    void SetChainIdentifiers(TChain chainIdentifier);

    //  Sets 'chain' and 'chain-id' to the same value, when possible.
    //  When chainIdentifier is not a single-character, 'chain' is reset to avoid internal inconsistency.
    //  If chainIdentifier is empty, or  both 'chain' and 'chain-id' are reset.
    //  If chainIdentifier contains only whitespace:
    //      length == 1:  both fields set to ' ' (this is a valid 'chain' value)
    //      length >  1:  both 'chain' and 'chain-id' are reset (an invalid 'chain_id' value)
    void SetChainIdentifiers(const TChain_id& chainIdentifier);

    
    //  How to define the effective chain identifier when neither 'chain' nor 'chain-id' has been set.
    enum EBothUnsetPriority {
        eBothUnset_Chain,     //  a single space ('chain's default value)
        eBothUnset_ChainId    //  empty string   ('chain-id' does not have a default)
    };
    
    //  Return the effective chain identifier string defined as:
    //
    //    i) 'chain-id', when set;
    //   ii) 'chain', when set;
    //  iii) when neither are set, as per 'bothUnsetPriority'. 
    //
    //  NB:  When both 'chain' and 'chain-id' are set there is no guarantee they are consistent.
    //  See also:  IsChainConflict
    string GetEffectiveChain_id(EBothUnsetPriority bothUnsetPriority = eBothUnset_ChainId) const;

    
    //  "Legacy" encoding represents a lowercase character as the  corresponding uppercase character, doubled.
    //  E.g., in GenPept pages chain = 65 = 'a' would be displayed as "AA".
    enum EConflictMode {
        eConflictMode_default,  //  conflicts detected by string comparisons
        eConflictMode_legacy    //  ignore conflicts due purely to legacy encoding
    };
    
    //  True iff both 'chain' and 'chain-id' are set and the values aren't equivalent according to the
    //  specified conflict mode.
    //  eConflictMode_default  :  chain = 65 = 'a' and chain-id = "AA" are not equivalent.
    //  eConflictMode_legacy   :  chain = 65 = 'a' and chain-id = "AA" are considered equivalent.
    //
    //  Note: eConflictMode_legacy does not require that a lowercase chain value be encoded.
    bool IsChainConflict(EConflictMode encodingMode = eConflictMode_default) const;


private:
    // Prohibit copy constructor & assignment operator
    CPDB_seq_id(const CPDB_seq_id&);
    CPDB_seq_id& operator= (const CPDB_seq_id&);

};



/////////////////// CPDB_seq_id inline methods

// constructor
inline
CPDB_seq_id::CPDB_seq_id(void)
{
}


/////////////////// end of CPDB_seq_id inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_PDB_SEQ_ID_HPP
/* Original file checksum: lines: 85, chars: 2258, CRC32: 8edce8b4 */
