/* string.c: string routines for nawm */

/* Copyright (C) 1999 by the Massachusetts Institute of Technology.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 */

#include "nawmmod.h"

#include <stdlib.h>
#include <string.h>

int nawm_modrev = 1;

static void substr_fun(int argc, nawmval *argv, nawmval *ret);
static void tolower_fun(int argc, nawmval *argv, nawmval *ret);
static void toupper_fun(int argc, nawmval *argv, nawmval *ret);
static void strdup_fun(int argc, nawmval *argv, nawmval *ret);
static void strlen_fun(int argc, nawmval *argv, nawmval *ret);
static void strindex_fun(int argc, nawmval *argv, nawmval *ret);
static void strcspn_fun(int argc, nawmval *argv, nawmval *ret);
static void strspn_fun(int argc, nawmval *argv, nawmval *ret);
static void strtok_fun(int argc, nawmval *argv, nawmval *ret);
static void strexplode_fun(int argc, nawmval *argv, nawmval *ret);
static void ascii_fun(int argc, nawmval *argv, nawmval *ret);
static void char_fun(int argc, nawmval *argv, nawmval *ret);

void modinit(void)
{
  module_define_procedure("substr", T_STR, substr_fun, 3, T_STR, T_INT, T_INT);
  module_define_procedure("tolower", T_STR, tolower_fun, 1, T_STR);
  module_define_procedure("toupper", T_STR, toupper_fun, 1, T_STR);
  module_define_procedure("strdup", T_STR, strdup_fun, 1, T_STR);
  module_define_procedure("strlen", T_INT, strlen_fun, 1, T_STR);
  module_define_procedure("strindex", T_INT, strindex_fun, 2, T_STR, T_STR);
  module_define_procedure("strcspn", T_INT, strcspn_fun, 2, T_STR, T_STR);
  module_define_procedure("strspn", T_INT, strspn_fun, 2, T_STR, T_STR);
  module_define_procedure("strtok", array_type(T_STR, T_INT), strtok_fun, 2, T_STR, T_STR);
  module_define_procedure("strexplode", array_type(T_STR, T_INT), strexplode_fun, 1, T_STR);
  module_define_procedure("ascii", T_INT, ascii_fun, 1, T_STR);
  module_define_procedure("char", T_STR, char_fun, 1, T_INT);
}

static void substr_fun(int argc, nawmval *argv, nawmval *ret)
{
  char *s = (char *)argv[0];
  int start = argv[1], len = argv[2];

  if (len == 0)
    len = strlen(s) - start + 1;

  *ret = (nawmval)gcmalloc(len + 1, free);
  memcpy((void *)*ret, s + start, len);
}

static void tolower_fun(int argc, nawmval *argv, nawmval *ret)
{
  char *s = (char *)argv[0], *p;

  *ret = (nawmval)gcstrdup(s);
  for (p = (char *)*ret; *p; p++)
    *p = tolower(*p);
}

static void toupper_fun(int argc, nawmval *argv, nawmval *ret)
{
  char *s = (char *)argv[0], *p;

  *ret = (nawmval)gcstrdup(s);
  for (p = (char *)*ret; *p; p++)
    *p = toupper(*p);
}

static void strdup_fun(int argc, nawmval *argv, nawmval *ret)
{
  *ret = (nawmval)gcstrdup((char *)argv[0]);
}

static void strlen_fun(int argc, nawmval *argv, nawmval *ret)
{
  *ret = strlen((char *)argv[0]);
}

static void strindex_fun(int argc, nawmval *argv, nawmval *ret)
{
  char *s = (char *)argv[0], *match = (char *)argv[1], *p;

  p = strstr(s, match);
  if (!p)
    *ret = -1;
  else
    *ret = p - s;
}

static void strcspn_fun(int argc, nawmval *argv, nawmval *ret)
{
  *ret = strcspn((char *)argv[0], (char *)argv[1]);
}

static void strspn_fun(int argc, nawmval *argv, nawmval *ret)
{
  *ret = strspn((char *)argv[0], (char *)argv[1]);
}

static void strtok_fun(int argc, nawmval *argv, nawmval *ret)
{
  int n;
  char *s = (char *)argv[0], *sep = (char *)argv[1], *dup, *p;

  dup = xstrdup(s);
  for (p = strtok(dup, sep), n = 0; p; p = strtok(NULL, sep))
    n++;
  free(dup);

  *ret = (nawmval)create_array(array_type(T_STR, T_INT), n);
  dup = xstrdup(s);
  for (p = strtok(dup, sep); p; p = strtok(dup, sep))
    array_insert((array *)*ret, n++, (nawmval)gcstrdup(p));
  free(dup);
}

static void strexplode_fun(int argc, nawmval *argv, nawmval *ret)
{
  char *s = (char *)argv[0], *p, ch[2] = {0, 0};
  int n;

  *ret = (nawmval)create_array(array_type(T_STR, T_INT), strlen(s));

  for (p = s, n = 0; *p; p++)
    {
      ch[0] = *p;
      array_insert((array *)*ret, n++, (nawmval)gcstrdup(ch));
    }
}

static void ascii_fun(int argc, nawmval *argv, nawmval *ret)
{
  *ret = *(char *)argv[0];
}

static void char_fun(int argc, nawmval *argv, nawmval *ret)
{
  char s[2] = {0, 0};
  s[0] = argv[0];
  *ret = (nawmval)gcstrdup(s);
}
