--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with System;
with System.Storage_Elements;

with Shared_Library;
pragma Elaborate_All (Shared_Library);

package Narval.Actors.Actives.Consumers.Basic_Generic is

   type Generic_Consumer_Type is new Consumer_Type with private;

private

   type Init_Function_Type is access function return System.Address;
   type Procedure_On_Order_Type is access procedure (Object : System.Address);
   type Procedure_On_Start_Type is access procedure (Object : System.Address;
                                                    Run_Number : Integer);
   type Procedure_On_Work_Type is access procedure
     (Object : System.Address;
      Address : System.Address;
      Size : System.Storage_Elements.Storage_Count;
      Swap : Integer);

   function Library_Symbol is new
     Shared_Library.Library_Symbol (Init_Function_Type);
   function Library_Symbol is new
     Shared_Library.Library_Symbol (Procedure_On_Order_Type);
   function Library_Symbol is new
     Shared_Library.Library_Symbol (Procedure_On_Start_Type);
   function Library_Symbol is new
     Shared_Library.Library_Symbol (Procedure_On_Work_Type);

   type Generic_Consumer_Type is new Consumer_Type with record
      Library_Reference : Shared_Library.Handle_Type;
      Common_Reference : System.Address;
      Init_Function : Init_Function_Type;
      Buffer_Handling : Procedure_On_Work_Type;
      On_Unload : Procedure_On_Order_Type;
      On_Reset_Com : Procedure_On_Order_Type;
      On_Start : Procedure_On_Start_Type;
      On_Stop : Procedure_On_Order_Type;
      On_Suspend : Procedure_On_Order_Type;
      On_Resume : Procedure_On_Order_Type;
      Swap_To_C : Integer := 0;
   end record;

   procedure Buffer_Handling
     (Object : access Generic_Consumer_Type);
   procedure On_Unload
     (Object : access Generic_Consumer_Type);
   procedure On_Start
     (Object : access Generic_Consumer_Type);
   procedure On_Stop
     (Object : access Generic_Consumer_Type);
   procedure On_Suspend
     (Object : access Generic_Consumer_Type);
   procedure On_Resume
     (Object : access Generic_Consumer_Type);
   procedure On_Initialise
     (Object : access Generic_Consumer_Type);
   procedure On_Reset_Com
     (Object : access Generic_Consumer_Type);
end Narval.Actors.Actives.Consumers.Basic_Generic;
