--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Unchecked_Conversion;
with Ada.Streams;
package body Swap is
   function "/"(Left, Right : in Ada.Streams.Stream_Element_Offset)
               return Ada.Streams.Stream_Element_Offset
     renames Ada.Streams."/";
   function "-"(Left, Right : in Ada.Streams.Stream_Element_Offset)
               return Ada.Streams.Stream_Element_Offset
     renames Ada.Streams."-";
   function "+"(Left, Right : in Ada.Streams.Stream_Element_Offset)
               return Ada.Streams.Stream_Element_Offset
     renames Ada.Streams."+";
   subtype Stream_64 is Ada.Streams.Stream_Element_Array
     (1 .. Long_Float'Size / 8);
   subtype Stream_32 is Ada.Streams.Stream_Element_Array
     (1 .. Integer'Size / 8);
   subtype Stream_16 is Ada.Streams.Stream_Element_Array
     (1 .. Interfaces.Unsigned_16'Size / 8);
   function To_Stream is new Ada.Unchecked_Conversion (Integer, Stream_32);
   function To_Objet is new Ada.Unchecked_Conversion (Stream_32, Integer);
   function To_Stream is new Ada.Unchecked_Conversion (Interfaces.Unsigned_32,
                                                       Stream_32);
   function To_Objet is new Ada.Unchecked_Conversion (Stream_32,
                                                      Interfaces.Unsigned_32);
   function To_Stream is new Ada.Unchecked_Conversion (Interfaces.Unsigned_16,
                                                       Stream_16);
   function To_Objet is new Ada.Unchecked_Conversion (Stream_16,
                                                      Interfaces.Unsigned_16);
   function To_Stream is new Ada.Unchecked_Conversion (Long_Float, Stream_64);
   function To_Objet is new Ada.Unchecked_Conversion (Stream_64, Long_Float);
   function To_Stream is new Ada.Unchecked_Conversion (Interfaces.Unsigned_64,
                                                       Stream_64);
   function To_Objet is new Ada.Unchecked_Conversion (Stream_64,
                                                      Interfaces.Unsigned_64);

   procedure Swap_Integer (Data : in out Integer) is
      Data_Before, Data_After : Stream_32;
   begin
      Data_Before := To_Stream (Data);
      for I in Data_Before'Range loop
         Data_After (I) := Data_Before (Data_Before'Last - I + 1);
      end loop;
      Data := To_Objet (Data_After);
   end Swap_Integer;
   function Swap_Integer (Data : Integer) return Integer is
      Data_Before, Data_After : Stream_32;
   begin
      Data_Before := To_Stream (Data);
      for I in Data_Before'Range loop
         Data_After (I) := Data_Before (Data_Before'Last - I + 1);
      end loop;
      return To_Objet (Data_After);
   end Swap_Integer;
   procedure Swap_Integer (Data : in out Interfaces.Unsigned_32) is
      Data_Before, Data_After : Stream_32;
   begin
      Data_Before := To_Stream (Data);
      for I in Data_Before'Range loop
         Data_After (I) := Data_Before (Data_Before'Last - I + 1);
      end loop;
      Data := To_Objet (Data_After);
   end Swap_Integer;
   function Swap_Integer (Data : Interfaces.Unsigned_32)
                         return Interfaces.Unsigned_32 is
      Data_Before, Data_After : Stream_32;
   begin
      Data_Before := To_Stream (Data);
      for I in Data_Before'Range loop
         Data_After (I) := Data_Before (Data_Before'Last - I + 1);
      end loop;
      return To_Objet (Data_After);
   end Swap_Integer;
   function Swap_Integer (Data : Interfaces.Unsigned_64)
                         return Interfaces.Unsigned_64 is
      Data_Before, Data_After : Stream_64;
   begin
      Data_Before := To_Stream (Data);
      for I in Data_Before'Range loop
         Data_After (I) := Data_Before (Data_Before'Last - I + 1);
      end loop;
      return To_Objet (Data_After);
   end Swap_Integer;

   procedure Swap_Integer (Data : in out Interfaces.Unsigned_16) is
      Data_Before, Data_After : Stream_16;
   begin
      Data_Before := To_Stream (Data);
      for I in Data_Before'Range loop
         Data_After (I) := Data_Before (Data_Before'Last - I + 1);
      end loop;
      Data := To_Objet (Data_After);
   end Swap_Integer;
   function Swap_Integer (Data : Interfaces.Unsigned_16)
                         return Interfaces.Unsigned_16 is
      Data_Before, Data_After : Stream_16;
   begin
      Data_Before := To_Stream (Data);
      for I in Data_Before'Range loop
         Data_After (I) := Data_Before (Data_Before'Last - I + 1);
      end loop;
      return To_Objet (Data_After);
   end Swap_Integer;
   function Swap_Long_Float (Data : Long_Float) return Long_Float is
      Data_Before, Data_After : Stream_64;
   begin
      Data_Before := To_Stream (Data);
      for I in Data_Before'Range loop
         Data_After (I) := Data_Before (Data_Before'Last - I + 1);
      end loop;
      return To_Objet (Data_After);
   end Swap_Long_Float;
end Swap;
