--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Command_Line;
with Ada.Strings.Fixed;

function Narval_Server_Name return String is
   use Ada.Command_Line;
begin
   for I in 1 .. Argument_Count loop
      if Argument (I) = "--boot_server" then
         if I = Argument_Count then
            return "";
         end if;
         declare
            Slash_Position : constant Natural := Ada.Strings.Fixed.Index
              (Argument (I + 1), "/", Ada.Strings.Backward);
            Double_Point_Position : constant Natural := Ada.Strings.Fixed.Index
              (Argument (I + 1), ":", Ada.Strings.Backward);
         begin
            return Argument (I + 1)
              (Slash_Position + 1 .. Double_Point_Position - 1);
         end;
      end if;
   end loop;
   return "";
end Narval_Server_Name;

