/* Copyright (C) 2000 Monty Program KB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Returns info about database status */

#include "heapdef.h"


byte *heap_position(HP_INFO *info)
{
  return ((info->update & HA_STATE_AKTIV) ? info->current_ptr :
	  (HEAP_PTR) 0);
}


#ifdef WANT_OLD_HEAP_VERSION

/*
  The following should NOT be used anymore as this can't be used together with
   heap_rkey()
*/

ulong heap_position_old(HP_INFO *info)
{
  return ((info->update & HA_STATE_AKTIV) ? info->current_record :
	  (ulong) ~0L);
}

#endif /* WANT_OLD_HEAP_CODE */

/* Note that heap_info does NOT return information about the
   current position anymore;  Use heap_position instead */

int heap_info(reg1 HP_INFO *info,reg2 HEAPINFO *x,int flag)
{
  DBUG_ENTER("heap_info");
  x->records	 = info->s->records;
  x->deleted	 = info->s->deleted;
  x->reclength	 = info->s->reclength;
  x->data_length = info->s->data_length;
  x->index_length= info->s->index_length;
  x->max_records = info->s->max_records;
  x->errkey	 = info->errkey;
  DBUG_RETURN(0);
} /* heap_info */
