# #########################################################
#
# NAME:
#       setup.pro
#
# PURPOSE:
#       Use qt qmake on this to make the Makefile.
#
# DESCRIPTION:
#       This setup code is based upon the Qt class library
#       where the usual way to build code is to use the
#       Qt qmake tool to create a Makefile from a project
#       (this file).
#
# NOTES:
#       On UNIX, Linux and OSX your preference should be
#       to use the GNU auto-build but this will do as an 
#       alternative.
#
#	We need to build as a 'plugin' and not just a 'dll'
#	because on OSX plugins are special share libraries
#	called 'bundles' which can be explicitly loaded.
#
#	The target directory is hard-coded but could be 
#	done using an environment variable substitution
#	- or one could just edit this file. The hard coding
#	has been done just to save some time (for me).
#
# #########################################################

# #########################################################
# COMMON
# #########################################################
TEMPLATE                = lib
TARGET                  = myodbc3S
DESTDIR                 = ./
!win32:VERSION		= 3.51.11
UI_DIR                  = .tmp
MOC_DIR                 = .tmp
OBJECTS_DIR             = .tmp
LANGUAGE                = C++
CPP_ALWAYS_CREATE_SOURCE = TRUE
CONFIG                  += plugin qt thread warn_on release

# #########################################################
# WIN
# #########################################################
win32:DEFINES           -= UNICODE
win32:DEFINES           += WIN32 HAVE_SQLGETPRIVATEPROFILESTRING HAVE_ODBCINST_H
win32:LIBS              += ../util/myodbcutil.lib odbc32.lib odbccp32.lib
win32:DEF_FILE          = myodbc3S.def
win32:RC_FILE           = myodbc3S.rc
win32:libraries.path	= /windows/system32
win32:libraries.files	= myodbc3S.dll

# #########################################################
# UNIX
#       Your preference should be to use the GNU auto-build
#       on unix - but this will do as alternative.
# #########################################################
unix:DEFINES		+= HAVE_CONFIG_H
unix:INCLUDEPATH	+= /usr/include
unix:LIBS               += -L../util/.libs -lmyodbcutil  -L/usr/lib -lodbc -lodbcinst
unix:libraries.path	= /usr/lib
unix:libraries.files	= libmyodbc*

# #########################################################
# OSX
#       Your preference should be to use the GNU auto-build
#       on OSX - but this will do as alternative.
# #########################################################
# mac:CONFIG		-= thread
mac:LIBS		-= -lodbc -lodbcinst
mac:LIBS		+= -liodbc -liodbcinst
mac:libraries.path     = /usr/lib
mac:libraries.files    = libmyodbc3S.dylib

INSTALLS		+= libraries

# #########################################################
# FILES
# #########################################################
HEADERS			= \
			MYODBCSetupCheckBox.h \
			MYODBCSetupComboBox.h \
			MYODBCSetupComboBoxDatabases.h \
			MYODBCSetup.h \
			MYODBCSetupDataSourceDialog.h \
			MYODBCSetupDataSourceTab1.h \
			MYODBCSetupDataSourceTab2.h \
			MYODBCSetupDataSourceTab3.h \
			MYODBCSetupDataSourceTab3a.h \
			MYODBCSetupDataSourceTab3b.h \
			MYODBCSetupDataSourceTab3c.h \
			MYODBCSetupDataSourceTab3d.h \
			MYODBCSetupLineEdit.h
SOURCES			= \
			ConfigDSN.c \
			MYODBCSetupCheckBox.cpp \
			MYODBCSetupComboBox.cpp \
			MYODBCSetupComboBoxDatabases.cpp \
			MYODBCSetupConfigDSNAdd.c \
			MYODBCSetupConfigDSNEdit.c \
			MYODBCSetupConfigDSNRemove.c \
			MYODBCSetupDataSourceConfig.cpp \
			MYODBCSetupDataSourceDialog.cpp \
			MYODBCSetupDataSourceTab1.cpp \
			MYODBCSetupDataSourceTab2.cpp \
			MYODBCSetupDataSourceTab3.cpp \
			MYODBCSetupDataSourceTab3a.cpp \
			MYODBCSetupDataSourceTab3b.cpp \
			MYODBCSetupDataSourceTab3c.cpp \
			MYODBCSetupDataSourceTab3d.cpp \
			MYODBCSetupDriverConnect.c \
			MYODBCSetupDriverConnectPrompt.cpp \
			MYODBCSetupHandleInstallerError.c \
			MYODBCSetupLineEdit.cpp
			
