# #########################################################
#
# NAME:         
#       imyodbc.pro
#
# PURPOSE:
#       Use qt qmake on this to make the Makefile.
#
# DESCRIPTION:
#       This file is really only for XP because UNIX, 
#       Linux, and OSX can use the gnu automake.
#
#       This file exists for those that have qt (such as
#       myself). Others may simply use the Makefile.win
#
#
# #########################################################

# #########################################################
# COMMON
# #########################################################

TEMPLATE                = app
TARGET                  = imyodbc
DESTDIR                 = ./
OBJECTS_DIR             = ./
CONFIG                  += thread console
DEFINES           	+= HAVE_SQLGETPRIVATEPROFILESTRING HAVE_ODBCINST_H

# #########################################################
# WIN
# #########################################################
win32:DEFINES           -= UNICODE
win32:DEFINES           += WIN32
win32:LIBS              += ..\util\myodbcutil.lib odbc32.lib odbccp32.lib

# #########################################################
# UNIX
# #########################################################
unix:LIBS               += -L../util -lmyodbcutil -L/usr/lib -lodbc -lodbcinst

# #########################################################
# OSX
# #########################################################
mac:CONFIG		-= thread
mac:LIBS		-= -lodbc -lodbcinst
mac:LIBS		+= -liodbc -liodbcinst

# #########################################################
# FILES
# #########################################################
HEADERS			= \
                        imyodbc.h

SOURCES			= \
                        imyodbc.c

