// smartmem.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
 
#ifndef _SMARTMEM_H_
#define _SMARTMEM_H_

// SmartMemory handles all memory acquisition that is not done via new, and 
// keeps track of total allocations.  Note that the call to free() includes the
// size of the chunk being freed, for bookkeeping.

class SmartMemory {
public:
	static void setMaxTotalAllocation(size_t);
	static size_t maxTotalAllocation() { return max_TotalAllocation; }
	static void setMaxSingleAllocation(size_t);
	static size_t maxSingleAllocation() { return max_SingleAllocation; }
	static size_t totalBytesAllocated() { return totalBytes_Allocated; }

	static void* allocate(size_t* size);
	static void free(void* ptr, size_t size);
	static void* changeAllocation(void* ptr, size_t oldSize, size_t* size);
	static void* zero(void* ptr, size_t size, int zero=0);
	static void* copy(void* from, void* to, size_t size);
protected:
	static int isLegalAllocation(size_t size);
private:
	static size_t totalBytes_Allocated;
	static size_t max_TotalAllocation;
	static size_t max_SingleAllocation;
};

#endif
