/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

/* mxfft.f -- translated by f2c (version of 16 February 1991  0:35:15).
   You must link the resulting object file with the libraries:
	-lf2c -lm -lc   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct cstak_1_ {
    doublereal dstak[2500];
};

#define cstak_1 (*(struct cstak_1_ *) &cstak_)

/* Initialized data */

static struct {
    integer e_1[10];
    doublereal fill_2[2495];
    doublereal e_3;
    } cstak_ = { 0, 10, 10, 5000, 10, 1, 1, 1, 2, 2, {0}, 0. };


/* Table of constant values */

static integer c__4 = 4;
static integer c__1 = 1;
static integer c__3 = 3;
static integer c__2 = 2;


/* ----------------------------------------------------------------------- */
/* block data:  initializes labeled common */
/* ----------------------------------------------------------------------- */

/*<       block data >*/

/*<       common /cstak/ dstak(2500) >*/

/*<       double precision dstak >*/
/*<       integer istak(5000) >*/
/*<       integer isize(5) >*/

/*<       equivalence (dstak(1),istak(1)) >*/
/*<       equivalence (istak(1),lout) >*/
/*<       equivalence (istak(2),lnow) >*/
/*<       equivalence (istak(3),lused) >*/
/*<       equivalence (istak(4),lmax) >*/
/*<       equivalence (istak(5),lbook) >*/
/*<       equivalence (istak(6),isize(1)) >*/

/*<       data isize(1), isize(2), isize(3), isize(4), isize(5) /1,1,1,2,2/ >*/
/*<       data lout, lnow, lused, lmax, lbook /0,10,10,5000,10/ >*/

/*<       end >*/


/* ----------------------------------------------------------------------- */
/* subroutine:  fft */
/* multivariate complex fourier transform, computed in place */
/* using mixed-radix fast fourier transform algorithm. */
/* ----------------------------------------------------------------------- */

/*<       subroutine fft(a, b, nseg, n, nspn, isn) >*/
/* Subroutine */ int fft_(a, b, nseg, n, nspn, isn)
real *a, *b;
integer *nseg, *n, *nspn, *isn;
{
    /* Format strings */
    static char fmt_9999[] = "(\002 error - zero in fft parameters\002,4i10)";

    static char fmt_9998[] = "(\002 error - fft parameter n has more than 15\
 factors-\002,i20)";

    /* System generated locals */
    integer i__1, i__2;

#if 0
    /* Builtin functions */
    integer s_wsfe(), do_fio(), e_wsfe();
#endif

    /* Local variables */
    static integer nfac[15], maxf, ierr, maxp, ntot, j, k, m;
#define istak ((integer *)&cstak_1)
    static integer nspan;
#define rstak ((real *)&cstak_1)
    extern /* Subroutine */ int fftmx_();
    static integer j2, j3;
    extern integer i1mach_();
    static integer nf, jj, kt;
    extern integer istkgt_();
    extern /* Subroutine */ int istkrl_();

    /* Fortran I/O blocks */
    static cilist io___16 = { 0, 0, 0, fmt_9999, 0 };
    static cilist io___25 = { 0, 0, 0, fmt_9998, 0 };



/* arrays a and b originally hold the real and imaginary */
/*      components of the data, and return the real and */
/*      imaginary components of the resulting fourier coefficients. */
/* multivariate data is indexed according to the fortran */
/*      array element successor function, without limit */
/*      on the number of implied multiple subscripts. */
/*      the subroutine is called once for each variate. */
/*      the calls for a multivariate transform may be in any order. */

/* n is the dimension of the current variable. */
/* nspn is the spacing of consecutive data values */
/*      while indexing the current variable. */
/* nseg*n*nspn is the total number of complex data values. */
/* the sign of isn determines the sign of the complex */
/*      exponential, and the magnitude of isn is normally one. */
/*      the magnitude of isn determines the indexing increment for a&b. */


/* if fft is called twice, with opposite signs on isn, an */
/*      identity transformation is done...calls can be in either order. */

/*      the results are scaled by 1/n when the sign of isn is positive. */


/* a tri-variate transform with a(n1,n2,n3), b(n1,n2,n3) */
/* is computed by */
/*        call fft(a,b,n2*n3,n1,1,-1) */
/*        call fft(a,b,n3,n2,n1,-1) */
/*        call fft(a,b,1,n3,n1*n2,-1) */

/* a single-variate transform of n complex data values is computed by */
/*        call fft(a,b,1,n,1,-1) */

/* the data may alternatively be stored in a single complex */
/*      array a, then the magnitude of isn changed to two to */
/*      give the correct indexing increment and a(2) used to */
/*      pass the initial address for the sequence of imaginary */
/*      values, e.g. */
/*        call fft(a,a(2),nseg,n,nspn,-2) */

/* array nfac is working storage for factoring n.  the smallest */
/*      number exceeding the 15 locations provided is 12,754,584. */

/*<       dimension a(1), b(1), nfac(15) >*/

/*<       common /cstak/ dstak(2500) >*/
/*<       double precision dstak >*/
/*<       integer istak(5000) >*/
/*<       real rstak(5000) >*/

/*<       equivalence (dstak(1),istak(1)) >*/
/*<       equivalence (dstak(1),rstak(1)) >*/

/* determine the factors of n */

/*<       m = 0 >*/
    /* Parameter adjustments */
    --b;
    --a;

    /* Function Body */
    m = 0;
/*<       nf = iabs(n) >*/
    nf = abs(*n);
/*<       k = nf >*/
    k = nf;
/*<       if (nf.eq.1) return >*/
    if (nf == 1) {
	return 0;
    }
/*<       nspan = iabs(nf*nspn) >*/
    nspan = (i__1 = nf * *nspn, abs(i__1));
/*<       ntot = iabs(nspan*nseg) >*/
    ntot = (i__1 = nspan * *nseg, abs(i__1));
/*<       if (isn*ntot.ne.0) go to 20 >*/
    if (*isn * ntot != 0) {
	goto L20;
    }
#if 0
/*<       ierr = i1mach(4) >*/
    ierr = i1mach_(&c__4);
/*<       write (ierr,9999) nseg, n, nspn, isn >*/
    io___16.ciunit = ierr;
    s_wsfe(&io___16);
    do_fio(&c__1, (char *)&(*nseg), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*n), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*nspn), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*isn), (ftnlen)sizeof(integer));
    e_wsfe();
/*< 9999  format (31h error - zero in fft parameters, 4i10) >*/
#endif
/*<       return >*/
    return 0;

/*<   10  m = m + 1 >*/
L10:
    ++m;
/*<       nfac(m) = 4 >*/
    nfac[m - 1] = 4;
/*<       k = k/16 >*/
    k /= 16;
/*<   20  if (k-(k/16)*16.eq.0) go to 10 >*/
L20:
    if (k - (k / 16 << 4) == 0) {
	goto L10;
    }
/*<       j = 3 >*/
    j = 3;
/*<       jj = 9 >*/
    jj = 9;
/*<       go to 40 >*/
    goto L40;
/*<   30  m = m + 1 >*/
L30:
    ++m;
/*<       nfac(m) = j >*/
    nfac[m - 1] = j;
/*<       k = k/jj >*/
    k /= jj;
/*<   40  if (mod(k,jj).eq.0) go to 30 >*/
L40:
    if (k % jj == 0) {
	goto L30;
    }
/*<       j = j + 2 >*/
    j += 2;
/*<       jj = j**2 >*/
/* Computing 2nd power */
    i__1 = j;
    jj = i__1 * i__1;
/*<       if (jj.le.k) go to 40 >*/
    if (jj <= k) {
	goto L40;
    }
/*<       if (k.gt.4) go to 50 >*/
    if (k > 4) {
	goto L50;
    }
/*<       kt = m >*/
    kt = m;
/*<       nfac(m+1) = k >*/
    nfac[m] = k;
/*<       if (k.ne.1) m = m + 1 >*/
    if (k != 1) {
	++m;
    }
/*<       go to 90 >*/
    goto L90;
/*<   50  if (k-(k/4)*4.ne.0) go to 60 >*/
L50:
    if (k - (k / 4 << 2) != 0) {
	goto L60;
    }
/*<       m = m + 1 >*/
    ++m;
/*<       nfac(m) = 2 >*/
    nfac[m - 1] = 2;
/*<       k = k/4 >*/
    k /= 4;
/* all square factors out now, but k .ge. 5 still */
/*<   60  kt = m >*/
L60:
    kt = m;
/*<       maxp = max0(kt+kt+2,k-1) >*/
/* Computing MAX */
    i__1 = kt + kt + 2, i__2 = k - 1;
    maxp = max(i__1,i__2);
/*<       j = 2 >*/
    j = 2;
/*<   70  if (mod(k,j).ne.0) go to 80 >*/
L70:
    if (k % j != 0) {
	goto L80;
    }
/*<       m = m + 1 >*/
    ++m;
/*<       nfac(m) = j >*/
    nfac[m - 1] = j;
/*<       k = k/j >*/
    k /= j;
/*<   80  j = ((j+1)/2)*2 + 1 >*/
L80:
    j = ((j + 1) / 2 << 1) + 1;
/*<       if (j.le.k) go to 70 >*/
    if (j <= k) {
	goto L70;
    }
/*<   90  if (m.le.kt+1) maxp = m + kt + 1 >*/
L90:
    if (m <= kt + 1) {
	maxp = m + kt + 1;
    }
/*<       if (m+kt.gt.15) go to 120 >*/
    if (m + kt > 15) {
	goto L120;
    }
/*<       if (kt.eq.0) go to 110 >*/
    if (kt == 0) {
	goto L110;
    }
/*<       j = kt >*/
    j = kt;
/*<  100  m = m + 1 >*/
L100:
    ++m;
/*<       nfac(m) = nfac(j) >*/
    nfac[m - 1] = nfac[j - 1];
/*<       j = j - 1 >*/
    --j;
/*<       if (j.ne.0) go to 100 >*/
    if (j != 0) {
	goto L100;
    }

/*<  110  maxf = m - kt >*/
L110:
    maxf = m - kt;
/*<       maxf = nfac(maxf) >*/
    maxf = nfac[maxf - 1];
/*<       if (kt.gt.0) maxf = max0(nfac(kt),maxf) >*/
    if (kt > 0) {
/* Computing MAX */
	i__1 = nfac[kt - 1];
	maxf = max(i__1,maxf);
    }
/*<       j = istkgt(maxf*4,3) >*/
    i__1 = maxf << 2;
    j = istkgt_(&i__1, &c__3);
/*<       jj = j + maxf >*/
    jj = j + maxf;
/*<       j2 = jj + maxf >*/
    j2 = jj + maxf;
/*<       j3 = j2 + maxf >*/
    j3 = j2 + maxf;
/*<       k = istkgt(maxp,2) >*/
    k = istkgt_(&maxp, &c__2);
/*<    >*/
    fftmx_(&a[1], &b[1], &ntot, &nf, &nspan, isn, &m, &kt, &rstak[j - 1], &
	    rstak[jj - 1], &rstak[j2 - 1], &rstak[j3 - 1], &istak[k - 1], 
	    nfac);
/*<       call istkrl(2) >*/
    istkrl_(&c__2);
/*<       return >*/
    return 0;

/*<  120  ierr = i1mach(4) >*/
L120:
#if 0
    ierr = i1mach_(&c__4);
/*<       write (ierr,9998) n >*/
    io___25.ciunit = ierr;
    s_wsfe(&io___25);
    do_fio(&c__1, (char *)&(*n), (ftnlen)sizeof(integer));
    e_wsfe();
#endif
/*< 99 >*/
/*<       return >*/
    return 0;
/*<       end >*/
} /* fft_ */

#undef rstak
#undef istak



/* ----------------------------------------------------------------------- */
/* subroutine:  fftmx */
/* called by subroutine 'fft' to compute mixed-radix fourier transform */
/* ----------------------------------------------------------------------- */

/*<    >*/
/* Subroutine */ int fftmx_(a, b, ntot, n, nspan, isn, m, kt, at, ck, bt, sk, 
	np, nfac)
real *a, *b;
integer *ntot, *n, *nspan, *isn, *m, *kt;
real *at, *ck, *bt, *sk;
integer *np, *nfac;
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;

    /* Builtin functions */
    double atan(), cos(), sin(), sqrt();

    /* Local variables */
    static integer maxf, klim, i, j, k, kspan;
    static real c1, c2, c3;
    static integer kspnn, k1, k2, k3, k4;
    static real s1, s2, s3, aa, bb, cd, aj, c72, ak;
    static integer jc, jf;
    static real bk, bj;
    static integer jj;
    static real dr, sd;
    static integer kk, mm;
    static real s72;
    static integer nn, ks, nt;
    static real s120, rad, ajm, akm;
    static integer inc;
    static real ajp, akp, bkp, bkm, bjp, bjm;
    static integer lim;


/*<       dimension a(1), b(1), at(1), ck(1), bt(1), sk(1), np(1), nfac(1) >*/

/*<       inc = iabs(isn) >*/
    /* Parameter adjustments */
    --nfac;
    --np;
    --sk;
    --bt;
    --ck;
    --at;
    --b;
    --a;

    /* Function Body */
    inc = abs(*isn);
/*<       nt = inc*ntot >*/
    nt = inc * *ntot;
/*<       ks = inc*nspan >*/
    ks = inc * *nspan;
/*<       rad = atan(1.0) >*/
    rad = atan((float)1.);
/*<       s72 = rad/0.625 >*/
    s72 = rad / (float).625;
/*<       c72 = cos(s72) >*/
    c72 = cos(s72);
/*<       s72 = sin(s72) >*/
    s72 = sin(s72);
/*<       s120 = sqrt(0.75) >*/
    s120 = sqrt((float).75);
/*<       if (isn.gt.0) go to 10 >*/
    if (*isn > 0) {
	goto L10;
    }
/*<       s72 = -s72 >*/
    s72 = -(doublereal)s72;
/*<       s120 = -s120 >*/
    s120 = -(doublereal)s120;
/*<       rad = -rad >*/
    rad = -(doublereal)rad;
/*<       go to 30 >*/
    goto L30;

/* scale by 1/n for isn .gt. 0 */

/*<   10  ak = 1.0/float(n) >*/
L10:
    ak = (float)1. / (real) (*n);
/*<       do 20 j=1,nt,inc >*/
    i__1 = nt;
    i__2 = inc;
    for (j = 1; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {
/*<         a(j) = a(j)*ak >*/
	a[j] *= ak;
/*<         b(j) = b(j)*ak >*/
	b[j] *= ak;
/*<   20  continue >*/
/* L20: */
    }

/*<   30  kspan = ks >*/
L30:
    kspan = ks;
/*<       nn = nt - inc >*/
    nn = nt - inc;
/*<       jc = ks/n >*/
    jc = ks / *n;

/* sin, cos values are re-initialized each lim steps */

/*<       lim = 32 >*/
    lim = 32;
/*<       klim = lim*jc >*/
    klim = lim * jc;
/*<       i = 0 >*/
    i = 0;
/*<       jf = 0 >*/
    jf = 0;
/*<       maxf = m - kt >*/
    maxf = *m - *kt;
/*<       maxf = nfac(maxf) >*/
    maxf = nfac[maxf];
/*<       if (kt.gt.0) maxf = max0(nfac(kt),maxf) >*/
    if (*kt > 0) {
/* Computing MAX */
	i__2 = nfac[*kt];
	maxf = max(i__2,maxf);
    }

/* compute fourier transform */

/*<   40  dr = 8.0*float(jc)/float(kspan) >*/
L40:
    dr = (real) jc * (float)8. / (real) kspan;
/*<       cd = 2.0*sin(0.5*dr*rad)**2 >*/
/* Computing 2nd power */
    r__1 = sin(dr * (float).5 * rad);
    cd = r__1 * r__1 * (float)2.;
/*<       sd = sin(dr*rad) >*/
    sd = sin(dr * rad);
/*<       kk = 1 >*/
    kk = 1;
/*<       i = i + 1 >*/
    ++i;
/*<       if (nfac(i).ne.2) go to 110 >*/
    if (nfac[i] != 2) {
	goto L110;
    }

/* transform for factor of 2 (including rotation factor) */

/*<       kspan = kspan/2 >*/
    kspan /= 2;
/*<       k1 = kspan + 2 >*/
    k1 = kspan + 2;
/*<   50  k2 = kk + kspan >*/
L50:
    k2 = kk + kspan;
/*<       ak = a(k2) >*/
    ak = a[k2];
/*<       bk = b(k2) >*/
    bk = b[k2];
/*<       a(k2) = a(kk) - ak >*/
    a[k2] = a[kk] - ak;
/*<       b(k2) = b(kk) - bk >*/
    b[k2] = b[kk] - bk;
/*<       a(kk) = a(kk) + ak >*/
    a[kk] += ak;
/*<       b(kk) = b(kk) + bk >*/
    b[kk] += bk;
/*<       kk = k2 + kspan >*/
    kk = k2 + kspan;
/*<       if (kk.le.nn) go to 50 >*/
    if (kk <= nn) {
	goto L50;
    }
/*<       kk = kk - nn >*/
    kk -= nn;
/*<       if (kk.le.jc) go to 50 >*/
    if (kk <= jc) {
	goto L50;
    }
/*<       if (kk.gt.kspan) go to 350 >*/
    if (kk > kspan) {
	goto L350;
    }
/*<   60  c1 = 1.0 - cd >*/
L60:
    c1 = (float)1. - cd;
/*<       s1 = sd >*/
    s1 = sd;
/*<       mm = min0(k1/2,klim) >*/
/* Computing MIN */
    i__2 = k1 / 2;
    mm = min(i__2,klim);
/*<       go to 80 >*/
    goto L80;
/*<   70  ak = c1 - (cd*c1+sd*s1) >*/
L70:
    ak = c1 - (cd * c1 + sd * s1);
/*<       s1 = (sd*c1-cd*s1) + s1 >*/
    s1 = sd * c1 - cd * s1 + s1;

/* the following three statements compensate for truncation */
/* error.  if rounded arithmetic is used, substitute */
/* c1=ak */

/*      c1 = 0.5/(ak**2+s1**2) + 0.5 */
/*      s1 = c1*s1 */
/*      c1 = c1*ak */
/*<       c1 = ak >*/
    c1 = ak;
/*<   80  k2 = kk + kspan >*/
L80:
    k2 = kk + kspan;
/*<       ak = a(kk) - a(k2) >*/
    ak = a[kk] - a[k2];
/*<       bk = b(kk) - b(k2) >*/
    bk = b[kk] - b[k2];
/*<       a(kk) = a(kk) + a(k2) >*/
    a[kk] += a[k2];
/*<       b(kk) = b(kk) + b(k2) >*/
    b[kk] += b[k2];
/*<       a(k2) = c1*ak - s1*bk >*/
    a[k2] = c1 * ak - s1 * bk;
/*<       b(k2) = s1*ak + c1*bk >*/
    b[k2] = s1 * ak + c1 * bk;
/*<       kk = k2 + kspan >*/
    kk = k2 + kspan;
/*<       if (kk.lt.nt) go to 80 >*/
    if (kk < nt) {
	goto L80;
    }
/*<       k2 = kk - nt >*/
    k2 = kk - nt;
/*<       c1 = -c1 >*/
    c1 = -(doublereal)c1;
/*<       kk = k1 - k2 >*/
    kk = k1 - k2;
/*<       if (kk.gt.k2) go to 80 >*/
    if (kk > k2) {
	goto L80;
    }
/*<       kk = kk + jc >*/
    kk += jc;
/*<       if (kk.le.mm) go to 70 >*/
    if (kk <= mm) {
	goto L70;
    }
/*<       if (kk.lt.k2) go to 90 >*/
    if (kk < k2) {
	goto L90;
    }
/*<       k1 = k1 + inc + inc >*/
    k1 = k1 + inc + inc;
/*<       kk = (k1-kspan)/2 + jc >*/
    kk = (k1 - kspan) / 2 + jc;
/*<       if (kk.le.jc+jc) go to 60 >*/
    if (kk <= jc + jc) {
	goto L60;
    }
/*<       go to 40 >*/
    goto L40;
/*<   90  s1 = float((kk-1)/jc)*dr*rad >*/
L90:
    s1 = (real) ((kk - 1) / jc) * dr * rad;
/*<       c1 = cos(s1) >*/
    c1 = cos(s1);
/*<       s1 = sin(s1) >*/
    s1 = sin(s1);
/*<       mm = min0(k1/2,mm+klim) >*/
/* Computing MIN */
    i__2 = k1 / 2, i__1 = mm + klim;
    mm = min(i__2,i__1);
/*<       go to 80 >*/
    goto L80;

/* transform for factor of 3 (optional code) */

/*<  100  k1 = kk + kspan >*/
L100:
    k1 = kk + kspan;
/*<       k2 = k1 + kspan >*/
    k2 = k1 + kspan;
/*<       ak = a(kk) >*/
    ak = a[kk];
/*<       bk = b(kk) >*/
    bk = b[kk];
/*<       aj = a(k1) + a(k2) >*/
    aj = a[k1] + a[k2];
/*<       bj = b(k1) + b(k2) >*/
    bj = b[k1] + b[k2];
/*<       a(kk) = ak + aj >*/
    a[kk] = ak + aj;
/*<       b(kk) = bk + bj >*/
    b[kk] = bk + bj;
/*<       ak = -0.5*aj + ak >*/
    ak = aj * (float)-.5 + ak;
/*<       bk = -0.5*bj + bk >*/
    bk = bj * (float)-.5 + bk;
/*<       aj = (a(k1)-a(k2))*s120 >*/
    aj = (a[k1] - a[k2]) * s120;
/*<       bj = (b(k1)-b(k2))*s120 >*/
    bj = (b[k1] - b[k2]) * s120;
/*<       a(k1) = ak - bj >*/
    a[k1] = ak - bj;
/*<       b(k1) = bk + aj >*/
    b[k1] = bk + aj;
/*<       a(k2) = ak + bj >*/
    a[k2] = ak + bj;
/*<       b(k2) = bk - aj >*/
    b[k2] = bk - aj;
/*<       kk = k2 + kspan >*/
    kk = k2 + kspan;
/*<       if (kk.lt.nn) go to 100 >*/
    if (kk < nn) {
	goto L100;
    }
/*<       kk = kk - nn >*/
    kk -= nn;
/*<       if (kk.le.kspan) go to 100 >*/
    if (kk <= kspan) {
	goto L100;
    }
/*<       go to 290 >*/
    goto L290;

/* transform for factor of 4 */

/*<  110  if (nfac(i).ne.4) go to 230 >*/
L110:
    if (nfac[i] != 4) {
	goto L230;
    }
/*<       kspnn = kspan >*/
    kspnn = kspan;
/*<       kspan = kspan/4 >*/
    kspan /= 4;
/*<  120  c1 = 1.0 >*/
L120:
    c1 = (float)1.;
/*<       s1 = 0 >*/
    s1 = (float)0.;
/*<       mm = min0(kspan,klim) >*/
    mm = min(kspan,klim);
/*<       go to 150 >*/
    goto L150;
/*<  130  c2 = c1 - (cd*c1+sd*s1) >*/
L130:
    c2 = c1 - (cd * c1 + sd * s1);
/*<       s1 = (sd*c1-cd*s1) + s1 >*/
    s1 = sd * c1 - cd * s1 + s1;

/* the following three statements compensate for truncation */
/* error.  if rounded arithmetic is used, substitute */
/* c1=c2 */

/*      c1 = 0.5/(c2**2+s1**2) + 0.5 */
/*      s1 = c1*s1 */
/*      c1 = c1*c2 */
/*<       c1 = c2 >*/
    c1 = c2;
/*<  140  c2 = c1**2 - s1**2 >*/
L140:
/* Computing 2nd power */
    r__1 = c1;
/* Computing 2nd power */
    r__2 = s1;
    c2 = r__1 * r__1 - r__2 * r__2;
/*<       s2 = c1*s1*2.0 >*/
    s2 = c1 * s1 * (float)2.;
/*<       c3 = c2*c1 - s2*s1 >*/
    c3 = c2 * c1 - s2 * s1;
/*<       s3 = c2*s1 + s2*c1 >*/
    s3 = c2 * s1 + s2 * c1;
/*<  150  k1 = kk + kspan >*/
L150:
    k1 = kk + kspan;
/*<       k2 = k1 + kspan >*/
    k2 = k1 + kspan;
/*<       k3 = k2 + kspan >*/
    k3 = k2 + kspan;
/*<       akp = a(kk) + a(k2) >*/
    akp = a[kk] + a[k2];
/*<       akm = a(kk) - a(k2) >*/
    akm = a[kk] - a[k2];
/*<       ajp = a(k1) + a(k3) >*/
    ajp = a[k1] + a[k3];
/*<       ajm = a(k1) - a(k3) >*/
    ajm = a[k1] - a[k3];
/*<       a(kk) = akp + ajp >*/
    a[kk] = akp + ajp;
/*<       ajp = akp - ajp >*/
    ajp = akp - ajp;
/*<       bkp = b(kk) + b(k2) >*/
    bkp = b[kk] + b[k2];
/*<       bkm = b(kk) - b(k2) >*/
    bkm = b[kk] - b[k2];
/*<       bjp = b(k1) + b(k3) >*/
    bjp = b[k1] + b[k3];
/*<       bjm = b(k1) - b(k3) >*/
    bjm = b[k1] - b[k3];
/*<       b(kk) = bkp + bjp >*/
    b[kk] = bkp + bjp;
/*<       bjp = bkp - bjp >*/
    bjp = bkp - bjp;
/*<       if (isn.lt.0) go to 180 >*/
    if (*isn < 0) {
	goto L180;
    }
/*<       akp = akm - bjm >*/
    akp = akm - bjm;
/*<       akm = akm + bjm >*/
    akm += bjm;
/*<       bkp = bkm + ajm >*/
    bkp = bkm + ajm;
/*<       bkm = bkm - ajm >*/
    bkm -= ajm;
/*<       if (s1.eq.0.0) go to 190 >*/
    if (s1 == (float)0.) {
	goto L190;
    }
/*<  160  a(k1) = akp*c1 - bkp*s1 >*/
L160:
    a[k1] = akp * c1 - bkp * s1;
/*<       b(k1) = akp*s1 + bkp*c1 >*/
    b[k1] = akp * s1 + bkp * c1;
/*<       a(k2) = ajp*c2 - bjp*s2 >*/
    a[k2] = ajp * c2 - bjp * s2;
/*<       b(k2) = ajp*s2 + bjp*c2 >*/
    b[k2] = ajp * s2 + bjp * c2;
/*<       a(k3) = akm*c3 - bkm*s3 >*/
    a[k3] = akm * c3 - bkm * s3;
/*<       b(k3) = akm*s3 + bkm*c3 >*/
    b[k3] = akm * s3 + bkm * c3;
/*<       kk = k3 + kspan >*/
    kk = k3 + kspan;
/*<       if (kk.le.nt) go to 150 >*/
    if (kk <= nt) {
	goto L150;
    }
/*<  170  kk = kk - nt + jc >*/
L170:
    kk = kk - nt + jc;
/*<       if (kk.le.mm) go to 130 >*/
    if (kk <= mm) {
	goto L130;
    }
/*<       if (kk.lt.kspan) go to 200 >*/
    if (kk < kspan) {
	goto L200;
    }
/*<       kk = kk - kspan + inc >*/
    kk = kk - kspan + inc;
/*<       if (kk.le.jc) go to 120 >*/
    if (kk <= jc) {
	goto L120;
    }
/*<       if (kspan.eq.jc) go to 350 >*/
    if (kspan == jc) {
	goto L350;
    }
/*<       go to 40 >*/
    goto L40;
/*<  180  akp = akm + bjm >*/
L180:
    akp = akm + bjm;
/*<       akm = akm - bjm >*/
    akm -= bjm;
/*<       bkp = bkm - ajm >*/
    bkp = bkm - ajm;
/*<       bkm = bkm + ajm >*/
    bkm += ajm;
/*<       if (s1.ne.0.0) go to 160 >*/
    if (s1 != (float)0.) {
	goto L160;
    }
/*<  190  a(k1) = akp >*/
L190:
    a[k1] = akp;
/*<       b(k1) = bkp >*/
    b[k1] = bkp;
/*<       a(k2) = ajp >*/
    a[k2] = ajp;
/*<       b(k2) = bjp >*/
    b[k2] = bjp;
/*<       a(k3) = akm >*/
    a[k3] = akm;
/*<       b(k3) = bkm >*/
    b[k3] = bkm;
/*<       kk = k3 + kspan >*/
    kk = k3 + kspan;
/*<       if (kk.le.nt) go to 150 >*/
    if (kk <= nt) {
	goto L150;
    }
/*<       go to 170 >*/
    goto L170;
/*<  200  s1 = float((kk-1)/jc)*dr*rad >*/
L200:
    s1 = (real) ((kk - 1) / jc) * dr * rad;
/*<       c1 = cos(s1) >*/
    c1 = cos(s1);
/*<       s1 = sin(s1) >*/
    s1 = sin(s1);
/*<       mm = min0(kspan,mm+klim) >*/
/* Computing MIN */
    i__2 = kspan, i__1 = mm + klim;
    mm = min(i__2,i__1);
/*<       go to 140 >*/
    goto L140;

/* transform for factor of 5 (optional code) */

/*<  210  c2 = c72**2 - s72**2 >*/
L210:
/* Computing 2nd power */
    r__1 = c72;
/* Computing 2nd power */
    r__2 = s72;
    c2 = r__1 * r__1 - r__2 * r__2;
/*<       s2 = 2.0*c72*s72 >*/
    s2 = c72 * (float)2. * s72;
/*<  220  k1 = kk + kspan >*/
L220:
    k1 = kk + kspan;
/*<       k2 = k1 + kspan >*/
    k2 = k1 + kspan;
/*<       k3 = k2 + kspan >*/
    k3 = k2 + kspan;
/*<       k4 = k3 + kspan >*/
    k4 = k3 + kspan;
/*<       akp = a(k1) + a(k4) >*/
    akp = a[k1] + a[k4];
/*<       akm = a(k1) - a(k4) >*/
    akm = a[k1] - a[k4];
/*<       bkp = b(k1) + b(k4) >*/
    bkp = b[k1] + b[k4];
/*<       bkm = b(k1) - b(k4) >*/
    bkm = b[k1] - b[k4];
/*<       ajp = a(k2) + a(k3) >*/
    ajp = a[k2] + a[k3];
/*<       ajm = a(k2) - a(k3) >*/
    ajm = a[k2] - a[k3];
/*<       bjp = b(k2) + b(k3) >*/
    bjp = b[k2] + b[k3];
/*<       bjm = b(k2) - b(k3) >*/
    bjm = b[k2] - b[k3];
/*<       aa = a(kk) >*/
    aa = a[kk];
/*<       bb = b(kk) >*/
    bb = b[kk];
/*<       a(kk) = aa + akp + ajp >*/
    a[kk] = aa + akp + ajp;
/*<       b(kk) = bb + bkp + bjp >*/
    b[kk] = bb + bkp + bjp;
/*<       ak = akp*c72 + ajp*c2 + aa >*/
    ak = akp * c72 + ajp * c2 + aa;
/*<       bk = bkp*c72 + bjp*c2 + bb >*/
    bk = bkp * c72 + bjp * c2 + bb;
/*<       aj = akm*s72 + ajm*s2 >*/
    aj = akm * s72 + ajm * s2;
/*<       bj = bkm*s72 + bjm*s2 >*/
    bj = bkm * s72 + bjm * s2;
/*<       a(k1) = ak - bj >*/
    a[k1] = ak - bj;
/*<       a(k4) = ak + bj >*/
    a[k4] = ak + bj;
/*<       b(k1) = bk + aj >*/
    b[k1] = bk + aj;
/*<       b(k4) = bk - aj >*/
    b[k4] = bk - aj;
/*<       ak = akp*c2 + ajp*c72 + aa >*/
    ak = akp * c2 + ajp * c72 + aa;
/*<       bk = bkp*c2 + bjp*c72 + bb >*/
    bk = bkp * c2 + bjp * c72 + bb;
/*<       aj = akm*s2 - ajm*s72 >*/
    aj = akm * s2 - ajm * s72;
/*<       bj = bkm*s2 - bjm*s72 >*/
    bj = bkm * s2 - bjm * s72;
/*<       a(k2) = ak - bj >*/
    a[k2] = ak - bj;
/*<       a(k3) = ak + bj >*/
    a[k3] = ak + bj;
/*<       b(k2) = bk + aj >*/
    b[k2] = bk + aj;
/*<       b(k3) = bk - aj >*/
    b[k3] = bk - aj;
/*<       kk = k4 + kspan >*/
    kk = k4 + kspan;
/*<       if (kk.lt.nn) go to 220 >*/
    if (kk < nn) {
	goto L220;
    }
/*<       kk = kk - nn >*/
    kk -= nn;
/*<       if (kk.le.kspan) go to 220 >*/
    if (kk <= kspan) {
	goto L220;
    }
/*<       go to 290 >*/
    goto L290;

/* transform for odd factors */

/*<  230  k = nfac(i) >*/
L230:
    k = nfac[i];
/*<       kspnn = kspan >*/
    kspnn = kspan;
/*<       kspan = kspan/k >*/
    kspan /= k;
/*<       if (k.eq.3) go to 100 >*/
    if (k == 3) {
	goto L100;
    }
/*<       if (k.eq.5) go to 210 >*/
    if (k == 5) {
	goto L210;
    }
/*<       if (k.eq.jf) go to 250 >*/
    if (k == jf) {
	goto L250;
    }
/*<       jf = k >*/
    jf = k;
/*<       s1 = rad/(float(k)/8.0) >*/
    s1 = rad / ((real) k / (float)8.);
/*<       c1 = cos(s1) >*/
    c1 = cos(s1);
/*<       s1 = sin(s1) >*/
    s1 = sin(s1);
/*<       ck(jf) = 1.0 >*/
    ck[jf] = (float)1.;
/*<       sk(jf) = 0.0 >*/
    sk[jf] = (float)0.;
/*<       j = 1 >*/
    j = 1;
/*<  240  ck(j) = ck(k)*c1 + sk(k)*s1 >*/
L240:
    ck[j] = ck[k] * c1 + sk[k] * s1;
/*<       sk(j) = ck(k)*s1 - sk(k)*c1 >*/
    sk[j] = ck[k] * s1 - sk[k] * c1;
/*<       k = k - 1 >*/
    --k;
/*<       ck(k) = ck(j) >*/
    ck[k] = ck[j];
/*<       sk(k) = -sk(j) >*/
    sk[k] = -(doublereal)sk[j];
/*<       j = j + 1 >*/
    ++j;
/*<       if (j.lt.k) go to 240 >*/
    if (j < k) {
	goto L240;
    }
/*<  250  k1 = kk >*/
L250:
    k1 = kk;
/*<       k2 = kk + kspnn >*/
    k2 = kk + kspnn;
/*<       aa = a(kk) >*/
    aa = a[kk];
/*<       bb = b(kk) >*/
    bb = b[kk];
/*<       ak = aa >*/
    ak = aa;
/*<       bk = bb >*/
    bk = bb;
/*<       j = 1 >*/
    j = 1;
/*<       k1 = k1 + kspan >*/
    k1 += kspan;
/*<  260  k2 = k2 - kspan >*/
L260:
    k2 -= kspan;
/*<       j = j + 1 >*/
    ++j;
/*<       at(j) = a(k1) + a(k2) >*/
    at[j] = a[k1] + a[k2];
/*<       ak = at(j) + ak >*/
    ak = at[j] + ak;
/*<       bt(j) = b(k1) + b(k2) >*/
    bt[j] = b[k1] + b[k2];
/*<       bk = bt(j) + bk >*/
    bk = bt[j] + bk;
/*<       j = j + 1 >*/
    ++j;
/*<       at(j) = a(k1) - a(k2) >*/
    at[j] = a[k1] - a[k2];
/*<       bt(j) = b(k1) - b(k2) >*/
    bt[j] = b[k1] - b[k2];
/*<       k1 = k1 + kspan >*/
    k1 += kspan;
/*<       if (k1.lt.k2) go to 260 >*/
    if (k1 < k2) {
	goto L260;
    }
/*<       a(kk) = ak >*/
    a[kk] = ak;
/*<       b(kk) = bk >*/
    b[kk] = bk;
/*<       k1 = kk >*/
    k1 = kk;
/*<       k2 = kk + kspnn >*/
    k2 = kk + kspnn;
/*<       j = 1 >*/
    j = 1;
/*<  270  k1 = k1 + kspan >*/
L270:
    k1 += kspan;
/*<       k2 = k2 - kspan >*/
    k2 -= kspan;
/*<       jj = j >*/
    jj = j;
/*<       ak = aa >*/
    ak = aa;
/*<       bk = bb >*/
    bk = bb;
/*<       aj = 0.0 >*/
    aj = (float)0.;
/*<       bj = 0.0 >*/
    bj = (float)0.;
/*<       k = 1 >*/
    k = 1;
/*<  280  k = k + 1 >*/
L280:
    ++k;
/*<       ak = at(k)*ck(jj) + ak >*/
    ak = at[k] * ck[jj] + ak;
/*<       bk = bt(k)*ck(jj) + bk >*/
    bk = bt[k] * ck[jj] + bk;
/*<       k = k + 1 >*/
    ++k;
/*<       aj = at(k)*sk(jj) + aj >*/
    aj = at[k] * sk[jj] + aj;
/*<       bj = bt(k)*sk(jj) + bj >*/
    bj = bt[k] * sk[jj] + bj;
/*<       jj = jj + j >*/
    jj += j;
/*<       if (jj.gt.jf) jj = jj - jf >*/
    if (jj > jf) {
	jj -= jf;
    }
/*<       if (k.lt.jf) go to 280 >*/
    if (k < jf) {
	goto L280;
    }
/*<       k = jf - j >*/
    k = jf - j;
/*<       a(k1) = ak - bj >*/
    a[k1] = ak - bj;
/*<       b(k1) = bk + aj >*/
    b[k1] = bk + aj;
/*<       a(k2) = ak + bj >*/
    a[k2] = ak + bj;
/*<       b(k2) = bk - aj >*/
    b[k2] = bk - aj;
/*<       j = j + 1 >*/
    ++j;
/*<       if (j.lt.k) go to 270 >*/
    if (j < k) {
	goto L270;
    }
/*<       kk = kk + kspnn >*/
    kk += kspnn;
/*<       if (kk.le.nn) go to 250 >*/
    if (kk <= nn) {
	goto L250;
    }
/*<       kk = kk - nn >*/
    kk -= nn;
/*<       if (kk.le.kspan) go to 250 >*/
    if (kk <= kspan) {
	goto L250;
    }

/* multiply by rotation factor (except for factors of 2 and 4) */

/*<  290  if (i.eq.m) go to 350 >*/
L290:
    if (i == *m) {
	goto L350;
    }
/*<       kk = jc + 1 >*/
    kk = jc + 1;
/*<  300  c2 = 1.0 - cd >*/
L300:
    c2 = (float)1. - cd;
/*<       s1 = sd >*/
    s1 = sd;
/*<       mm = min0(kspan,klim) >*/
    mm = min(kspan,klim);
/*<       go to 320 >*/
    goto L320;
/*<  310  c2 = c1 - (cd*c1+sd*s1) >*/
L310:
    c2 = c1 - (cd * c1 + sd * s1);
/*<       s1 = s1 + (sd*c1-cd*s1) >*/
    s1 += sd * c1 - cd * s1;

/* the following three statements compensate for truncation */
/* error.  if rounded arithmetic is used, they may */
/* be deleted. */

/*      c1 = 0.5/(c2**2+s1**2) + 0.5 */
/*      s1 = c1*s1 */
/*      c2 = c1*c2 */
/*<  320  c1 = c2 >*/
L320:
    c1 = c2;
/*<       s2 = s1 >*/
    s2 = s1;
/*<       kk = kk + kspan >*/
    kk += kspan;
/*<  330  ak = a(kk) >*/
L330:
    ak = a[kk];
/*<       a(kk) = c2*ak - s2*b(kk) >*/
    a[kk] = c2 * ak - s2 * b[kk];
/*<       b(kk) = s2*ak + c2*b(kk) >*/
    b[kk] = s2 * ak + c2 * b[kk];
/*<       kk = kk + kspnn >*/
    kk += kspnn;
/*<       if (kk.le.nt) go to 330 >*/
    if (kk <= nt) {
	goto L330;
    }
/*<       ak = s1*s2 >*/
    ak = s1 * s2;
/*<       s2 = s1*c2 + c1*s2 >*/
    s2 = s1 * c2 + c1 * s2;
/*<       c2 = c1*c2 - ak >*/
    c2 = c1 * c2 - ak;
/*<       kk = kk - nt + kspan >*/
    kk = kk - nt + kspan;
/*<       if (kk.le.kspnn) go to 330 >*/
    if (kk <= kspnn) {
	goto L330;
    }
/*<       kk = kk - kspnn + jc >*/
    kk = kk - kspnn + jc;
/*<       if (kk.le.mm) go to 310 >*/
    if (kk <= mm) {
	goto L310;
    }
/*<       if (kk.lt.kspan) go to 340 >*/
    if (kk < kspan) {
	goto L340;
    }
/*<       kk = kk - kspan + jc + inc >*/
    kk = kk - kspan + jc + inc;
/*<       if (kk.le.jc+jc) go to 300 >*/
    if (kk <= jc + jc) {
	goto L300;
    }
/*<       go to 40 >*/
    goto L40;
/*<  340  s1 = float((kk-1)/jc)*dr*rad >*/
L340:
    s1 = (real) ((kk - 1) / jc) * dr * rad;
/*<       c2 = cos(s1) >*/
    c2 = cos(s1);
/*<       s1 = sin(s1) >*/
    s1 = sin(s1);
/*<       mm = min0(kspan,mm+klim) >*/
/* Computing MIN */
    i__2 = kspan, i__1 = mm + klim;
    mm = min(i__2,i__1);
/*<       go to 320 >*/
    goto L320;

/* permute the results to normal order---done in two stages */
/* permutation for square factors of n */

/*<  350  np(1) = ks >*/
L350:
    np[1] = ks;
/*<       if (kt.eq.0) go to 440 >*/
    if (*kt == 0) {
	goto L440;
    }
/*<       k = kt + kt + 1 >*/
    k = *kt + *kt + 1;
/*<       if (m.lt.k) k = k - 1 >*/
    if (*m < k) {
	--k;
    }
/*<       j = 1 >*/
    j = 1;
/*<       np(k+1) = jc >*/
    np[k + 1] = jc;
/*<  360  np(j+1) = np(j)/nfac(j) >*/
L360:
    np[j + 1] = np[j] / nfac[j];
/*<       np(k) = np(k+1)*nfac(j) >*/
    np[k] = np[k + 1] * nfac[j];
/*<       j = j + 1 >*/
    ++j;
/*<       k = k - 1 >*/
    --k;
/*<       if (j.lt.k) go to 360 >*/
    if (j < k) {
	goto L360;
    }
/*<       k3 = np(k+1) >*/
    k3 = np[k + 1];
/*<       kspan = np(2) >*/
    kspan = np[2];
/*<       kk = jc + 1 >*/
    kk = jc + 1;
/*<       k2 = kspan + 1 >*/
    k2 = kspan + 1;
/*<       j = 1 >*/
    j = 1;
/*<       if (n.ne.ntot) go to 400 >*/
    if (*n != *ntot) {
	goto L400;
    }

/* permutation for single-variate transform (optional code) */

/*<  370  ak = a(kk) >*/
L370:
    ak = a[kk];
/*<       a(kk) = a(k2) >*/
    a[kk] = a[k2];
/*<       a(k2) = ak >*/
    a[k2] = ak;
/*<       bk = b(kk) >*/
    bk = b[kk];
/*<       b(kk) = b(k2) >*/
    b[kk] = b[k2];
/*<       b(k2) = bk >*/
    b[k2] = bk;
/*<       kk = kk + inc >*/
    kk += inc;
/*<       k2 = kspan + k2 >*/
    k2 = kspan + k2;
/*<       if (k2.lt.ks) go to 370 >*/
    if (k2 < ks) {
	goto L370;
    }
/*<  380  k2 = k2 - np(j) >*/
L380:
    k2 -= np[j];
/*<       j = j + 1 >*/
    ++j;
/*<       k2 = np(j+1) + k2 >*/
    k2 = np[j + 1] + k2;
/*<       if (k2.gt.np(j)) go to 380 >*/
    if (k2 > np[j]) {
	goto L380;
    }
/*<       j = 1 >*/
    j = 1;
/*<  390  if (kk.lt.k2) go to 370 >*/
L390:
    if (kk < k2) {
	goto L370;
    }
/*<       kk = kk + inc >*/
    kk += inc;
/*<       k2 = kspan + k2 >*/
    k2 = kspan + k2;
/*<       if (k2.lt.ks) go to 390 >*/
    if (k2 < ks) {
	goto L390;
    }
/*<       if (kk.lt.ks) go to 380 >*/
    if (kk < ks) {
	goto L380;
    }
/*<       jc = k3 >*/
    jc = k3;
/*<       go to 440 >*/
    goto L440;

/* permutation for multivariate transform */

/*<  400  k = kk + jc >*/
L400:
    k = kk + jc;
/*<  410  ak = a(kk) >*/
L410:
    ak = a[kk];
/*<       a(kk) = a(k2) >*/
    a[kk] = a[k2];
/*<       a(k2) = ak >*/
    a[k2] = ak;
/*<       bk = b(kk) >*/
    bk = b[kk];
/*<       b(kk) = b(k2) >*/
    b[kk] = b[k2];
/*<       b(k2) = bk >*/
    b[k2] = bk;
/*<       kk = kk + inc >*/
    kk += inc;
/*<       k2 = k2 + inc >*/
    k2 += inc;
/*<       if (kk.lt.k) go to 410 >*/
    if (kk < k) {
	goto L410;
    }
/*<       kk = kk + ks - jc >*/
    kk = kk + ks - jc;
/*<       k2 = k2 + ks - jc >*/
    k2 = k2 + ks - jc;
/*<       if (kk.lt.nt) go to 400 >*/
    if (kk < nt) {
	goto L400;
    }
/*<       k2 = k2 - nt + kspan >*/
    k2 = k2 - nt + kspan;
/*<       kk = kk - nt + jc >*/
    kk = kk - nt + jc;
/*<       if (k2.lt.ks) go to 400 >*/
    if (k2 < ks) {
	goto L400;
    }
/*<  420  k2 = k2 - np(j) >*/
L420:
    k2 -= np[j];
/*<       j = j + 1 >*/
    ++j;
/*<       k2 = np(j+1) + k2 >*/
    k2 = np[j + 1] + k2;
/*<       if (k2.gt.np(j)) go to 420 >*/
    if (k2 > np[j]) {
	goto L420;
    }
/*<       j = 1 >*/
    j = 1;
/*<  430  if (kk.lt.k2) go to 400 >*/
L430:
    if (kk < k2) {
	goto L400;
    }
/*<       kk = kk + jc >*/
    kk += jc;
/*<       k2 = kspan + k2 >*/
    k2 = kspan + k2;
/*<       if (k2.lt.ks) go to 430 >*/
    if (k2 < ks) {
	goto L430;
    }
/*<       if (kk.lt.ks) go to 420 >*/
    if (kk < ks) {
	goto L420;
    }
/*<       jc = k3 >*/
    jc = k3;
/*<  440  if (2*kt+1.ge.m) return >*/
L440:
    if ((*kt << 1) + 1 >= *m) {
	return 0;
    }
/*<       kspnn = np(kt+1) >*/
    kspnn = np[*kt + 1];

/* permutation for square-free factors of n */

/*<       j = m - kt >*/
    j = *m - *kt;
/*<       nfac(j+1) = 1 >*/
    nfac[j + 1] = 1;
/*<  450  nfac(j) = nfac(j)*nfac(j+1) >*/
L450:
    nfac[j] *= nfac[j + 1];
/*<       j = j - 1 >*/
    --j;
/*<       if (j.ne.kt) go to 450 >*/
    if (j != *kt) {
	goto L450;
    }
/*<       kt = kt + 1 >*/
    ++(*kt);
/*<       nn = nfac(kt) - 1 >*/
    nn = nfac[*kt] - 1;
/*<       jj = 0 >*/
    jj = 0;
/*<       j = 0 >*/
    j = 0;
/*<       go to 480 >*/
    goto L480;
/*<  460  jj = jj - k2 >*/
L460:
    jj -= k2;
/*<       k2 = kk >*/
    k2 = kk;
/*<       k = k + 1 >*/
    ++k;
/*<       kk = nfac(k) >*/
    kk = nfac[k];
/*<  470  jj = kk + jj >*/
L470:
    jj = kk + jj;
/*<       if (jj.ge.k2) go to 460 >*/
    if (jj >= k2) {
	goto L460;
    }
/*<       np(j) = jj >*/
    np[j] = jj;
/*<  480  k2 = nfac(kt) >*/
L480:
    k2 = nfac[*kt];
/*<       k = kt + 1 >*/
    k = *kt + 1;
/*<       kk = nfac(k) >*/
    kk = nfac[k];
/*<       j = j + 1 >*/
    ++j;
/*<       if (j.le.nn) go to 470 >*/
    if (j <= nn) {
	goto L470;
    }

/* determine the permutation cycles of length greater than 1 */

/*<       j = 0 >*/
    j = 0;
/*<       go to 500 >*/
    goto L500;
/*<  490  k = kk >*/
L490:
    k = kk;
/*<       kk = np(k) >*/
    kk = np[k];
/*<       np(k) = -kk >*/
    np[k] = -kk;
/*<       if (kk.ne.j) go to 490 >*/
    if (kk != j) {
	goto L490;
    }
/*<       k3 = kk >*/
    k3 = kk;
/*<  500  j = j + 1 >*/
L500:
    ++j;
/*<       kk = np(j) >*/
    kk = np[j];
/*<       if (kk.lt.0) go to 500 >*/
    if (kk < 0) {
	goto L500;
    }
/*<       if (kk.ne.j) go to 490 >*/
    if (kk != j) {
	goto L490;
    }
/*<       np(j) = -j >*/
    np[j] = -j;
/*<       if (j.ne.nn) go to 500 >*/
    if (j != nn) {
	goto L500;
    }
/*<       maxf = inc*maxf >*/
    maxf = inc * maxf;

/* reorder a and b, following the permutation cycles */

/*<       go to 570 >*/
    goto L570;
/*<  510  j = j - 1 >*/
L510:
    --j;
/*<       if (np(j).lt.0) go to 510 >*/
    if (np[j] < 0) {
	goto L510;
    }
/*<       jj = jc >*/
    jj = jc;
/*<  520  kspan = jj >*/
L520:
    kspan = jj;
/*<       if (jj.gt.maxf) kspan = maxf >*/
    if (jj > maxf) {
	kspan = maxf;
    }
/*<       jj = jj - kspan >*/
    jj -= kspan;
/*<       k = np(j) >*/
    k = np[j];
/*<       kk = jc*k + i + jj >*/
    kk = jc * k + i + jj;
/*<       k1 = kk + kspan >*/
    k1 = kk + kspan;
/*<       k2 = 0 >*/
    k2 = 0;
/*<  530  k2 = k2 + 1 >*/
L530:
    ++k2;
/*<       at(k2) = a(k1) >*/
    at[k2] = a[k1];
/*<       bt(k2) = b(k1) >*/
    bt[k2] = b[k1];
/*<       k1 = k1 - inc >*/
    k1 -= inc;
/*<       if (k1.ne.kk) go to 530 >*/
    if (k1 != kk) {
	goto L530;
    }
/*<  540  k1 = kk + kspan >*/
L540:
    k1 = kk + kspan;
/*<       k2 = k1 - jc*(k+np(k)) >*/
    k2 = k1 - jc * (k + np[k]);
/*<       k = -np(k) >*/
    k = -np[k];
/*<  550  a(k1) = a(k2) >*/
L550:
    a[k1] = a[k2];
/*<       b(k1) = b(k2) >*/
    b[k1] = b[k2];
/*<       k1 = k1 - inc >*/
    k1 -= inc;
/*<       k2 = k2 - inc >*/
    k2 -= inc;
/*<       if (k1.ne.kk) go to 550 >*/
    if (k1 != kk) {
	goto L550;
    }
/*<       kk = k2 >*/
    kk = k2;
/*<       if (k.ne.j) go to 540 >*/
    if (k != j) {
	goto L540;
    }
/*<       k1 = kk + kspan >*/
    k1 = kk + kspan;
/*<       k2 = 0 >*/
    k2 = 0;
/*<  560  k2 = k2 + 1 >*/
L560:
    ++k2;
/*<       a(k1) = at(k2) >*/
    a[k1] = at[k2];
/*<       b(k1) = bt(k2) >*/
    b[k1] = bt[k2];
/*<       k1 = k1 - inc >*/
    k1 -= inc;
/*<       if (k1.ne.kk) go to 560 >*/
    if (k1 != kk) {
	goto L560;
    }
/*<       if (jj.ne.0) go to 520 >*/
    if (jj != 0) {
	goto L520;
    }
/*<       if (j.ne.1) go to 510 >*/
    if (j != 1) {
	goto L510;
    }
/*<  570  j = k3 + 1 >*/
L570:
    j = k3 + 1;
/*<       nt = nt - kspnn >*/
    nt -= kspnn;
/*<       i = nt - inc + 1 >*/
    i = nt - inc + 1;
/*<       if (nt.ge.0) go to 510 >*/
    if (nt >= 0) {
	goto L510;
    }
/*<       return >*/
    return 0;
/*<       end >*/
} /* fftmx_ */


/* ----------------------------------------------------------------------- */
/* subroutine:  reals */
/* used with 'fft' to compute fourier transform or inverse for real data */
/* ----------------------------------------------------------------------- */

/*<       subroutine reals(a, b, n, isn) >*/
/* Subroutine */ int reals_(a, b, n, isn)
real *a, *b;
integer *n, *isn;
{
    /* Format strings */
    static char fmt_9999[] = "(\002 error - zero in reals parameters\002,2i1\
0)";

    /* System generated locals */
    integer i__1, i__2;
    real r__1;

    /* Builtin functions */
#if 0
    integer s_wsfe(), do_fio(), e_wsfe();
#endif
    double atan(), sin(), cos();

    /* Local variables */
    static integer ierr, j, k;
    extern integer i1mach_();
    static real aa, ab, ba, bb, cd, cn, em;
    static integer nf, nh;
    static real dr, sd;
    static integer nk, mm, ml;
    static real re, sn, rad;
    static integer inc, lim;

    /* Fortran I/O blocks */
    static cilist io___77 = { 0, 0, 0, fmt_9999, 0 };



/* if isn=-1, this subroutine completes the fourier transform */
/*      of 2*n real data values, where the original data values are */
/*      stored alternately in arrays a and b, and are first */
/*      transformed by a complex fourier transform of dimension n. */
/*      the cosine coefficients are in a(1),a(2),...a(n),a(n+1) */
/*      and the sine coefficients are in b(1),b(2),...b(n),b(n+1). */
/*      note that the arrays a and b must have dimension n+1. */
/*      a typical calling sequence is */
/*        call fft(a,b,n,n,n,-1) */
/*        call reals(a,b,n,-1) */

/* if isn=1, the inverse transformation is done, the first */
/*      step in evaluating a real fourier series. */
/*      a typical calling sequence is */
/*        call reals(a,b,n,1) */
/*        call fft(a,b,n,n,n,1) */
/*      the time domain results alternate in arrays a and b, */
/*      i.e. a(1),b(1),a(2),b(2),...a(n),b(n). */

/* the data may alternatively be stored in a single complex */
/*      array a, then the magnitude of isn changed to two to */
/*      give the correct indexing increment and a(2) used to */
/*      pass the initial address for the sequence of imaginary */
/*      values, e.g. */
/*        call fft(a,a(2),n,n,n,-2) */
/*        call reals(a,a(2),n,-2) */
/*      in this case, the cosine and sine coefficients alternate in a. */

/*<       dimension a(1), b(1) >*/
/*<       inc = iabs(isn) >*/
    /* Parameter adjustments */
    --b;
    --a;

    /* Function Body */
    inc = abs(*isn);
/*<       nf = iabs(n) >*/
    nf = abs(*n);
/*<       if (nf*isn.ne.0) go to 10 >*/
    if (nf * *isn != 0) {
	goto L10;
    }
#if 0
/*<       ierr = i1mach(4) >*/
    ierr = i1mach_(&c__4);
/*<       write (ierr,9999) n, isn >*/
    io___77.ciunit = ierr;
    s_wsfe(&io___77);
    do_fio(&c__1, (char *)&(*n), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*isn), (ftnlen)sizeof(integer));
    e_wsfe();
/*< 9999  format (33h error - zero in reals parameters, 2i10) >*/
#endif
/*<       return >*/
    return 0;

/*<   10  nk = nf*inc + 2 >*/
L10:
    nk = nf * inc + 2;
/*<       nh = nk/2 >*/
    nh = nk / 2;
/*<       rad = atan(1.0) >*/
    rad = atan((float)1.);
/*<       dr = -4.0/float(nf) >*/
    dr = (float)-4. / (real) nf;
/*<       cd = 2.0*sin(0.5*dr*rad)**2 >*/
/* Computing 2nd power */
    r__1 = sin(dr * (float).5 * rad);
    cd = r__1 * r__1 * (float)2.;
/*<       sd = sin(dr*rad) >*/
    sd = sin(dr * rad);

/* sin,cos values are re-initialized each lim steps */

/*<       lim = 32 >*/
    lim = 32;
/*<       mm = lim >*/
    mm = lim;
/*<       ml = 0 >*/
    ml = 0;
/*<       sn = 0.0 >*/
    sn = (float)0.;
/*<       if (isn.gt.0) go to 40 >*/
    if (*isn > 0) {
	goto L40;
    }
/*<       cn = 1.0 >*/
    cn = (float)1.;
/*<       a(nk-1) = a(1) >*/
    a[nk - 1] = a[1];
/*<       b(nk-1) = b(1) >*/
    b[nk - 1] = b[1];
/*<   20  do 30 j=1,nh,inc >*/
L20:
    i__1 = nh;
    i__2 = inc;
    for (j = 1; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {
/*<         k = nk - j >*/
	k = nk - j;
/*<         aa = a(j) + a(k) >*/
	aa = a[j] + a[k];
/*<         ab = a(j) - a(k) >*/
	ab = a[j] - a[k];
/*<         ba = b(j) + b(k) >*/
	ba = b[j] + b[k];
/*<         bb = b(j) - b(k) >*/
	bb = b[j] - b[k];
/*<         re = cn*ba + sn*ab >*/
	re = cn * ba + sn * ab;
/*<         em = sn*ba - cn*ab >*/
	em = sn * ba - cn * ab;
/*<         b(k) = (em-bb)*0.5 >*/
	b[k] = (em - bb) * (float).5;
/*<         b(j) = (em+bb)*0.5 >*/
	b[j] = (em + bb) * (float).5;
/*<         a(k) = (aa-re)*0.5 >*/
	a[k] = (aa - re) * (float).5;
/*<         a(j) = (aa+re)*0.5 >*/
	a[j] = (aa + re) * (float).5;
/*<         ml = ml + 1 >*/
	++ml;
/*<         if (ml.eq.mm) go to 50 >*/
	if (ml == mm) {
	    goto L50;
	}
/*<         aa = cn - (cd*cn+sd*sn) >*/
	aa = cn - (cd * cn + sd * sn);
/*<         sn = (sd*cn-cd*sn) + sn >*/
	sn = sd * cn - cd * sn + sn;

/* the following three statements compensate for truncation */
/* error.  if rounded arithmetic is used, substitute */
/* cn=aa */

/*        cn = 0.5/(aa**2+sn**2) + 0.5 */
/*        sn = cn*sn */
/*        cn = cn*aa */
/*<       cn = aa >*/
	cn = aa;
/*<   30  continue >*/
L30:
	;
    }
/*<       return >*/
    return 0;

/*<   40  cn = -1.0 >*/
L40:
    cn = (float)-1.;
/*<       sd = -sd >*/
    sd = -(doublereal)sd;
/*<       go to 20 >*/
    goto L20;

/*<   50  mm = mm + lim >*/
L50:
    mm += lim;
/*<       sn = float(ml)*dr*rad >*/
    sn = (real) ml * dr * rad;
/*<       cn = cos(sn) >*/
    cn = cos(sn);
/*<       if (isn.gt.0) cn = -cn >*/
    if (*isn > 0) {
	cn = -(doublereal)cn;
    }
/*<       sn = sin(sn) >*/
    sn = sin(sn);
/*<       go to 30 >*/
    goto L30;
/*<       end >*/
} /* reals_ */


/* ----------------------------------------------------------------------- */
/* function:  istkgt(nitems,itype) */
/* allocates working storage for nitems of itype, as follows */

/* 1 - logical */
/* 2 - integer */
/* 3 - real */
/* 4 - double precision */
/* 5 - complex */

/* ----------------------------------------------------------------------- */

/*<       integer function istkgt(nitems, itype) >*/
integer istkgt_(nitems, itype)
integer *nitems, *itype;
{
    /* Format strings */
    static char fmt_9999[] = "(\002 \002,\002overflow of common array istak \
--- need\002,i10)";
    static char fmt_9998[] = "(12i6)";

    /* System generated locals */
    integer ret_val;

    /* Builtin functions */
#if 0
    integer s_wsfe(), do_fio(), e_wsfe();
#endif
    /* Subroutine */ int s_stop();

    /* Local variables */
#define lmax ((integer *)&cstak_1 + 3)
    static integer ierr;
#define lnow ((integer *)&cstak_1 + 1)
#define lout ((integer *)&cstak_1)
    static integer i, j;
#define lbook ((integer *)&cstak_1 + 4)
#define istak ((integer *)&cstak_1)
#define lused ((integer *)&cstak_1 + 2)
#define isize ((integer *)&cstak_1 + 5)
    extern integer i1mach_();

    /* Fortran I/O blocks */
    static cilist io___106 = { 0, 0, 0, fmt_9999, 0 };
    static cilist io___107 = { 0, 0, 0, fmt_9998, 0 };



/*<       common /cstak/ dstak(2500) >*/

/*<       double precision dstak >*/
/*<       integer istak(5000) >*/
/*<       integer isize(5) >*/

/*<       equivalence (dstak(1),istak(1)) >*/
/*<       equivalence (istak(1),lout) >*/
/*<       equivalence (istak(2),lnow) >*/
/*<       equivalence (istak(3),lused) >*/
/*<       equivalence (istak(4),lmax) >*/
/*<       equivalence (istak(5),lbook) >*/
/*<       equivalence (istak(6),isize(1)) >*/

/*<       istkgt = (lnow*isize(2)-1)/isize(itype) + 2 >*/
    ret_val = (*lnow * isize[1] - 1) / isize[*itype - 1] + 2;
/*<       i = ((istkgt-1+nitems)*isize(itype)-1)/isize(2) + 3 >*/
    i = ((ret_val - 1 + *nitems) * isize[*itype - 1] - 1) / isize[1] + 3;
/*<       if (i.gt.lmax) go to 10 >*/
    if (i > *lmax) {
	goto L10;
    }
/*<       istak(i-1) = itype >*/
    istak[i - 2] = *itype;
/*<       istak(i) = lnow >*/
    istak[i - 1] = *lnow;
/*<       lout = lout + 1 >*/
    ++(*lout);
/*<       lnow = i >*/
    *lnow = i;
/*<       lused = max0(lused,lnow) >*/
    *lused = max(*lused,*lnow);
/*<       return >*/
    return ret_val;

/*<   10  ierr = i1mach(4) >*/
L10:
#if 0
    ierr = i1mach_(&c__4);
/*<       write (ierr,9999) i >*/
    io___106.ciunit = ierr;
    s_wsfe(&io___106);
    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
    e_wsfe();
/*< 9999  format (1h , 39hoverflow of common array istak --- need, i10) >*/
/*<       write (ierr,9998) (istak(j),j=1,10), istak(lnow-1), istak(lnow) >*/
    io___107.ciunit = ierr;
    s_wsfe(&io___107);
    for (j = 1; j <= 10; ++j) {
	do_fio(&c__1, (char *)&istak[j - 1], (ftnlen)sizeof(integer));
    }
    do_fio(&c__1, (char *)&istak[*lnow - 2], (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&istak[*lnow - 1], (ftnlen)sizeof(integer));
    e_wsfe();
/*< 9998  format (12i6) >*/
#endif
/*<       stop >*/
    s_stop("", 0L);
/*<       end >*/
} /* istkgt_ */

#undef isize
#undef lused
#undef istak
#undef lbook
#undef lout
#undef lnow
#undef lmax



/* ----------------------------------------------------------------------- */
/* subroutine:  istkrl(k) */
/* de-allocates the last k working storage areas */
/* ----------------------------------------------------------------------- */

/*<       subroutine istkrl(k) >*/
/* Subroutine */ int istkrl_(k)
integer *k;
{
    /* Format strings */
    static char fmt_9999[] = "(\002 warning...istak(2),istak(3),istak(4) or \
istak(5) hit\002)";
    static char fmt_9997[] = "(12i6)";
    static char fmt_9998[] = "(\002 warning...pointer at istak(lnow) overwri\
tten\002/11x,\002de-allocation not completed\002)";

    /* Builtin functions */
#if 0
    integer s_wsfe(), e_wsfe(), do_fio();
#endif

    /* Local variables */
#define lmax ((integer *)&cstak_1 + 3)
    static integer ierr;
#define lnow ((integer *)&cstak_1 + 1)
#define lout ((integer *)&cstak_1)
    static integer j;
#define lbook ((integer *)&cstak_1 + 4)
#define istak ((integer *)&cstak_1)
#define lused ((integer *)&cstak_1 + 2)
    extern integer i1mach_();
    static integer in;

    /* Fortran I/O blocks */
    static cilist io___117 = { 0, 0, 0, fmt_9999, 0 };
    static cilist io___118 = { 0, 0, 0, fmt_9997, 0 };
    static cilist io___120 = { 0, 0, 0, fmt_9998, 0 };
    static cilist io___121 = { 0, 0, 0, fmt_9997, 0 };



/*<       common /cstak/ dstak(2500) >*/

/*<       double precision dstak >*/
/*<       integer istak(5000) >*/

/*<       equivalence (dstak(1),istak(1)) >*/
/*<       equivalence (istak(1),lout) >*/
/*<       equivalence (istak(2),lnow) >*/
/*<       equivalence (istak(3),lused) >*/
/*<       equivalence (istak(4),lmax) >*/
/*<       equivalence (istak(5),lbook) >*/

/*<       in = k >*/
    in = *k;

/*<    >*/
    if (*lbook <= *lnow && *lnow <= *lused && *lused <= *lmax) {
	goto L10;
    }
#if 0
/*<       ierr = i1mach(4) >*/
    ierr = i1mach_(&c__4);
/*<       write (ierr,9999) >*/
    io___117.ciunit = ierr;
    s_wsfe(&io___117);
    e_wsfe();
/*< 9999  format (53h warning...istak(2),istak(3),istak(4) or istak(5) hit) >*/
/*<       write (ierr,9997) (istak(j),j=1,10), istak(lnow-1), istak(lnow) >*/
    io___118.ciunit = ierr;
    s_wsfe(&io___118);
    for (j = 1; j <= 10; ++j) {
	do_fio(&c__1, (char *)&istak[j - 1], (ftnlen)sizeof(integer));
    }
    do_fio(&c__1, (char *)&istak[*lnow - 2], (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&istak[*lnow - 1], (ftnlen)sizeof(integer));
    e_wsfe();
#endif
/*<   10  if (in.le.0) return >*/
L10:
    if (in <= 0) {
	return 0;
    }
/*<       if (lbook.gt.istak(lnow) .or. istak(lnow).ge.lnow-1) go to 20 >*/
    if (*lbook > istak[*lnow - 1] || istak[*lnow - 1] >= *lnow - 1) {
	goto L20;
    }
/*<       lout = lout - 1 >*/
    --(*lout);
/*<       lnow = istak(lnow) >*/
    *lnow = istak[*lnow - 1];
/*<       in = in - 1 >*/
    --in;
/*<       go to 10 >*/
    goto L10;

/*<   20  ierr = i1mach(4) >*/
L20:
#if 0
    ierr = i1mach_(&c__4);
/*<       write (ierr,9998) >*/
    io___120.ciunit = ierr;
    s_wsfe(&io___120);
    e_wsfe();
/*< 99 >*/
/*<       write (ierr,9997) (istak(j),j=1,10), istak(lnow-1), istak(lnow) >*/
    io___121.ciunit = ierr;
    s_wsfe(&io___121);
    for (j = 1; j <= 10; ++j) {
	do_fio(&c__1, (char *)&istak[j - 1], (ftnlen)sizeof(integer));
    }
    do_fio(&c__1, (char *)&istak[*lnow - 2], (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&istak[*lnow - 1], (ftnlen)sizeof(integer));
    e_wsfe();
/*< 9997  format (12i6) >*/
#endif
/*<       return >*/
    return 0;

/*<       end >*/
} /* istkrl_ */

#undef lused
#undef istak
#undef lbook
#undef lout
#undef lnow
#undef lmax


