// lpcheader.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993 - 1999 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       April 20, 1999
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifndef LPCHEADER_H
#ifdef __GNUG__
#pragma interface
#endif
#define LPCHEADER_H

#include "header.h"
#include "diskstruct.h"
#include "localdefs.h"
#include "requester.h"

class LPCHeader : public FrameDataHeader {
	typedef FrameDataHeader Super;
	enum { LP_MAGIC = 999, LP_SWAPMAGIC = 0xe7030000 };
public:		// class portion
	enum Type { None=0x1, With=0x2 };
	enum Poles { defaultPoles = 34, maxPoles = 64 };
	static Type defaultHeaderType() { return default_HeaderType; }
	static ByteOrder defaultByteOrder() { return default_ByteOrder; }
	static void setDefaultHeaderType(Type t) { default_HeaderType = t; }
	static void setDefaultByteOrder(ByteOrder b) { default_ByteOrder = b; }
public:		// object portion
	LPCHeader(int poles, double framert, int srate, double dur=0);
	LPCHeader();
	virtual int nPoles() { return npoles; }
	static int readMagicNumber(DataFile *);
protected:
	redefined int diskHeaderSize() { return 32; }
	redefined int diskHeaderCommentSize() { return 4; }
	redefined int readMagic(DataFile *);
	redefined boolean isMagic();
	redefined boolean magicIsSwapped();
	redefined boolean isLittleEndian();
	redefined int checkHeader();
	redefined int readInfo(DataFile *);
	redefined int writeInfo(DataFile *);
	redefined const char* magicError();
	redefined void reset();	// used by LPCConfigRequester
protected:
	class LPCConfigRequester : public FrameConfigRequester {
		typedef FrameConfigRequester Super;
	public:
		LPCConfigRequester(Header* h);
	protected:
		redefined void configureRequest(Request *);
		redefined boolean confirmValues();
	};
	friend void LPCConfigRequester::configureRequest(Request *);
	friend boolean LPCConfigRequester::confirmValues();
	
	class LPCStruct : public DiskStruct {
	    typedef DiskStruct Super;
	public:
	    LPCStruct(int h=0, int m=LP_MAGIC, int np=0, int nv=0,
		      float fr=0, float sr=0, float dur=0)
	        : headersize(h), lpmagic(m), npoles(np), nvals(nv),
		  framrate(fr), srate(sr), duration(dur) {}
	    redefined long readSize();
	protected:
	    redefined ValueSetterBase** valueSetters();
	    enum { NumElements = 7 };
	private:
	    friend class LPCHeader;
	    int	headersize,
		lpmagic,
		npoles,		// number of filter pole coefficients per frame
		nvals;		// total number of channels of information
	    float   framrate,	// number of frames per second
		    srate,	// sampling rate of orig data
		    duration;	// duration of orig data analyzed
	};
	friend LPCStruct::LPCStruct(int, int, int, int, float, float, float);
	
public:
	redefined Requester* configRequester() {
		return new LPCConfigRequester(this);
	}
private:	// class members
	static Type default_HeaderType;
	static ByteOrder default_ByteOrder;
private:
	int npoles;
};

#endif /* LPCHEADER_H */
