// lowpassfilter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// this does f(x) = g1x + g2[x-1] [first order recursive filter]

#ifndef LOWPASSFILTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define LOWPASSFILTER_H

#include "processfun.h"

class Requester;

class LowPassFilter : public SimpleFunction {
	typedef SimpleFunction Super;
	friend class LowPassRequester;
public:
	LowPassFilter(Data* output);
	LowPassFilter(Data* output, double feedback);
	redefined const char* message() { return "Filtering..."; }
	redefined void operator () (double *input, int count);
	redefined void restoreState();
protected:
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void saveConfig();
private:
	void clear() { past = 0; }
	void setCoefficients(double *gn1, double *gn2);
private:
	double cutoff;
	double gain;
	double g1;	// these are initialized in ctor
	double g2;
	double past;
	boolean firstTime;
private:
	static double _savedCutoff;
	static double _savedGain;
};

#endif
