// datawindow.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifndef DATAWINDOW_H
#ifdef __GNUG__
#pragma interface
#endif
#define DATAWINDOW_H

// DataWindow is the outermost layer of structure for each visible data display
// window.  It contains a DataView subclass, and is (currently) responsible for
// the creation of the command menus based upon information returned by the
// DataEditor subclass.

#include "framedwindow.h"

class Controller;
class Data;
class Event;
struct MenuInfo;

class DataWindow : public FramedWindow {
	typedef FramedWindow Super;
public:
	DataWindow(Controller *, Interactor *);
	virtual ~DataWindow();
	redefined void Handle(Event &);
protected:
	redefined Handler* getWMDeleteHandler();
private:
	redefined Interactor* makeMenuBar();
	redefined Action* makeMenuItemAction(const struct MenuInfo*);
	redefined CommandState *getCommandState();
	void init();
private:
	Interactor* _view;
	Controller* _controller;
};

#endif
